/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Typeface  The Monotype Corporation plc. Data  The Monotype Corporation
 * plc/Type Solutions Inc. 1990-1992. All Rights Reserved
 * 
 * Trademark:
 * Arial Trademark of The Monotype Corporation plc registered in the US Pat & TM
 * Off. and elsewhere.
 * 
 * Description:
 * Contemporary sans serif design, Arial contains more humanist characteristics
 * than many of its predecessors and as such is more in tune with the mood of the
 * last decades of the twentieth century.  The overall treatment of curves is
 * softer and fuller than in most industrial style sans serif faces.  Terminal
 * strokes are cut on the diagonal which helps to give the face a less mechanical
 * appearance.  Arial is an extremely versatile family of typefaces which can be
 * used with equal success for text setting in reports, presentations, magazines
 * etc, and for display use in newspapers, advertising and promotions.
 * 
 * Manufacturer:
 * Monotype Typography
 * 
 * Designer:
 * Monotype Type Drawing Office - Robin Nicholas, Patricia Saunders 1982
 * 
 * Vendor URL:
 * http://www.monotype.com/html/mtname/ms_arial.html
 * 
 * License information:
 * http://www.monotype.com/html/type/license.html
 */
Cufon.registerFont({"w":200,"face":{"font-family":"Arial","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 6 4 2 2 2 2 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-17 -313 360 76.2176","underline-thickness":"26.3672","underline-position":"-24.9609","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":100,"k":{"Y":7,"T":7,"A":20}},"\u00a0":{"w":100},"!":{"d":"41,-64r-10,-137r0,-57r39,0v1,69,-5,130,-9,194r-20,0xm32,0r0,-36r37,0r0,36r-37,0","w":100},"\"":{"d":"25,-166v-5,-28,-10,-57,-8,-92r36,0v2,35,-3,64,-8,92r-20,0xm83,-166v-5,-28,-10,-57,-8,-92r36,0v2,35,-3,64,-9,92r-19,0","w":127},"#":{"d":"18,4r15,-74r-29,0r0,-27r35,0r13,-63r-48,0r0,-27r53,0r15,-75r27,0r-16,75r56,0r15,-75r27,0r-16,75r31,0r0,27r-36,0r-13,63r49,0r0,27r-54,0r-16,74r-26,0r15,-74r-55,0r-16,74r-26,0xm65,-97r55,0r13,-63r-55,0"},"$":{"d":"183,-73v2,43,-32,78,-75,78r0,32r-18,0r0,-32v-49,-4,-73,-29,-77,-77r32,-6v3,33,19,53,45,57r0,-101v-35,-7,-74,-27,-72,-72v1,-41,27,-69,72,-72r0,-15r18,0r0,15v40,4,64,26,69,63r-33,5v-3,-24,-15,-37,-36,-42r0,92v48,10,72,26,75,75xm90,-240v-32,2,-52,44,-31,70v6,7,17,14,31,18r0,-88xm108,-21v34,-1,56,-49,34,-78v-6,-7,-17,-13,-34,-19r0,97"},"%":{"d":"75,-126v-37,0,-55,-29,-54,-70v0,-34,18,-66,54,-66v35,0,56,29,56,68v0,39,-22,67,-56,68xm104,-195v0,-27,-7,-45,-28,-45v-22,0,-27,18,-27,47v0,28,6,45,27,45v22,0,28,-18,28,-47xm76,9r141,-271r26,0r-141,271r-26,0xm242,9v-36,0,-54,-29,-54,-69v0,-37,18,-67,54,-67v34,1,56,29,56,68v0,39,-21,68,-56,68xm270,-60v0,-27,-6,-45,-27,-45v-22,0,-28,19,-28,48v0,26,7,45,28,45v22,0,27,-19,27,-48","w":320},"&":{"d":"112,-262v34,0,60,24,60,55v0,24,-17,46,-49,63r46,59v5,-10,10,-22,13,-36r32,7v-6,22,-12,40,-22,55v12,16,25,29,40,40r-21,25v-13,-8,-26,-20,-40,-36v-18,20,-40,33,-74,34v-45,2,-83,-33,-82,-75v1,-40,29,-60,62,-77v-18,-21,-27,-30,-29,-57v-2,-32,30,-57,64,-57xm110,-236v-30,0,-39,38,-17,55r14,16v21,-13,29,-18,32,-41v1,-17,-13,-30,-29,-30xm50,-73v-2,35,40,65,77,41v10,-6,18,-14,24,-23r-58,-72v-26,16,-41,26,-43,54","w":240},"'":{"d":"24,-166v-5,-28,-10,-57,-8,-92r36,0v2,35,-3,64,-9,92r-19,0","w":68},"(":{"d":"107,-262v-66,97,-72,231,0,338r-23,0v-31,-40,-62,-101,-62,-169v1,-74,27,-121,62,-169r23,0","w":119},")":{"d":"107,-93v1,68,-32,129,-63,169r-22,0v71,-107,66,-242,0,-338r22,0v35,49,62,96,63,169","w":119},"*":{"d":"11,-210r8,-25v19,7,33,12,41,17v-2,-21,-4,-36,-4,-44r26,0v0,12,-2,27,-4,44v12,-6,25,-12,41,-17r8,25v-15,5,-29,7,-43,9v7,6,17,18,30,34r-21,15v-7,-9,-15,-22,-24,-38v-9,17,-16,29,-23,38r-21,-15v14,-17,23,-29,29,-34v-15,-3,-29,-5,-43,-9","w":140},"+":{"d":"90,-42r0,-70r-70,0r0,-30r70,0r0,-70r30,0r0,70r70,0r0,30r-70,0r0,70r-30,0","w":210},",":{"d":"32,0r0,-36r36,0v1,40,2,77,-29,87r-9,-14v15,-6,20,-16,20,-37r-18,0","w":100},"-":{"d":"11,-77r0,-32r98,0r0,32r-98,0","w":119},"\u00ad":{"d":"11,-77r0,-32r98,0r0,32r-98,0","w":119},".":{"d":"33,0r0,-36r36,0r0,36r-36,0","w":100},"\/":{"d":"0,4r75,-266r25,0r-75,266r-25,0","w":100},"0":{"d":"99,4v-67,0,-84,-54,-84,-131v0,-75,16,-132,84,-132v67,0,84,56,84,132v0,74,-16,131,-84,131xm99,-233v-46,6,-52,44,-52,106v0,65,8,98,52,105v44,-6,51,-40,51,-105v0,-65,-6,-99,-51,-106"},"1":{"d":"39,-194v32,-13,61,-39,75,-65r20,0r0,259r-32,0r0,-202v-14,14,-43,31,-63,39r0,-31","k":{"1":27}},"2":{"d":"181,-187v0,78,-96,103,-126,157r126,0r0,30r-170,0v6,-90,131,-106,137,-188v2,-26,-21,-46,-48,-45v-31,0,-51,20,-51,52r-32,-3v3,-47,35,-75,84,-75v46,0,80,30,80,72"},"3":{"d":"136,-140v88,26,42,150,-39,145v-45,-3,-78,-32,-82,-73r32,-4v6,31,18,50,50,50v30,1,54,-23,53,-53v0,-37,-34,-60,-72,-47r3,-28v28,4,58,-12,58,-42v0,-23,-19,-41,-42,-41v-28,0,-43,20,-47,47r-32,-6v7,-38,36,-64,78,-67v71,-6,103,95,40,119"},"4":{"d":"116,0r0,-62r-111,0r0,-29r117,-167r26,0r0,167r35,0r0,29r-35,0r0,62r-32,0xm116,-91r0,-116r-80,116r80,0"},"5":{"d":"186,-87v0,102,-163,129,-171,19r33,-2v3,29,21,48,50,48v31,0,54,-28,54,-63v0,-60,-78,-75,-102,-33r-29,-4r25,-132r128,0r0,30r-103,0r-14,69v54,-41,129,2,129,68"},"6":{"d":"14,-121v0,-103,66,-171,142,-121v14,9,20,27,23,47r-31,3v-4,-35,-42,-53,-70,-32v-23,18,-33,45,-33,91v13,-20,34,-34,63,-34v43,-1,77,38,76,83v-2,50,-31,88,-81,88v-63,0,-89,-47,-89,-125xm101,-139v-29,0,-52,24,-51,56v1,33,19,61,52,61v29,0,49,-26,49,-60v0,-33,-19,-57,-50,-57"},"7":{"d":"53,0v4,-86,46,-174,90,-224r-126,0r0,-30r167,0r0,24v-47,54,-92,133,-98,230r-33,0"},"8":{"d":"15,-75v1,-36,19,-57,49,-65v-71,-23,-35,-126,35,-119v70,-9,105,99,37,119v29,9,47,30,48,66v1,46,-38,78,-85,78v-48,0,-85,-33,-84,-79xm99,-233v-23,0,-42,18,-42,40v0,24,18,41,43,41v23,0,41,-18,41,-40v0,-23,-19,-41,-42,-41xm99,-126v-29,0,-53,23,-52,52v2,30,22,52,53,52v29,1,52,-22,52,-51v0,-30,-23,-53,-53,-53"},"9":{"d":"184,-134v0,81,-20,135,-92,138v-42,2,-68,-26,-72,-64r30,-2v5,25,16,40,43,40v49,0,58,-49,60,-99v-11,18,-35,34,-62,34v-43,0,-76,-38,-76,-85v0,-49,34,-90,81,-87v64,4,88,47,88,125xm99,-115v31,-1,50,-24,50,-58v0,-33,-19,-60,-49,-60v-30,1,-53,29,-53,62v0,31,22,56,52,56"},":":{"d":"33,-151r0,-36r36,0r0,36r-36,0xm33,0r0,-36r36,0r0,36r-36,0","w":100},";":{"d":"32,-151r0,-36r36,0r0,36r-36,0xm32,0r0,-36r36,0v1,40,2,77,-29,87r-9,-14v15,-6,20,-16,20,-37r-18,0","w":100},"\u037e":{"d":"32,-151r0,-36r36,0r0,36r-36,0xm32,0r0,-36r36,0v1,40,2,77,-29,87r-9,-14v15,-6,20,-16,20,-37r-18,0","w":100},"<":{"d":"20,-113r0,-29r170,-72r0,31r-135,56r135,56r0,31","w":210},"=":{"d":"190,-152r-170,0r0,-29r170,0r0,29xm190,-73r-170,0r0,-30r170,0r0,30","w":210},">":{"d":"190,-113r-170,73r0,-31r135,-56r-135,-56r0,-31r170,72r0,29","w":210},"?":{"d":"182,-192v0,61,-74,60,-69,129r-30,0v-10,-71,61,-75,67,-127v3,-24,-25,-47,-50,-46v-31,2,-47,20,-52,52r-32,-4v6,-45,33,-74,83,-74v46,0,83,28,83,70xm81,0r0,-36r36,0r0,36r-36,0"},"@":{"d":"238,1v-22,0,-33,-7,-34,-30v-13,16,-30,30,-54,30v-108,0,-62,-192,28,-192v25,0,42,14,53,33r6,-27r31,0r-30,145v0,7,5,11,12,11v38,-8,68,-51,68,-97v0,-70,-56,-111,-126,-111v-89,0,-145,64,-146,152v-1,91,61,134,151,135v57,0,101,-22,124,-53r31,0v-26,46,-78,80,-155,79v-107,-1,-177,-53,-177,-158v0,-107,64,-180,174,-180v88,0,146,52,150,137v3,58,-51,127,-106,126xm180,-164v-61,-1,-88,129,-23,139v41,-6,61,-45,64,-89v1,-28,-16,-50,-41,-50","w":365},"A":{"d":"-1,0r99,-258r37,0r106,258r-39,0r-30,-78r-108,0r-28,78r-37,0xm74,-106r87,0r-45,-125v-9,45,-28,84,-42,125","w":240,"k":{"\u2019":27,"y":7,"w":7,"v":7,"Y":27,"W":13,"V":27,"T":27," ":20}},"B":{"d":"221,-75v1,89,-104,75,-195,75r0,-258v82,0,182,-14,182,66v0,27,-15,46,-36,55v29,8,48,29,49,62xm175,-188v0,-52,-64,-37,-115,-39r0,78v50,-2,115,12,115,-39xm186,-75v0,-55,-70,-43,-126,-44r0,89v56,-2,126,12,126,-45","w":240},"C":{"d":"136,-25v43,0,68,-26,76,-65r34,8v-12,51,-48,86,-107,86v-84,1,-113,-57,-121,-135v-14,-136,189,-182,223,-56r-33,8v-11,-33,-29,-53,-69,-54v-60,-1,-86,44,-86,102v0,61,25,106,83,106","w":259},"D":{"d":"241,-130v0,82,-35,130,-120,130r-93,0r0,-258r89,0v89,-3,124,46,124,128xm206,-131v0,-64,-21,-99,-90,-96r-54,0r0,197r55,0v68,2,89,-37,89,-101","w":259},"E":{"d":"28,0r0,-258r187,0r0,31r-152,0r0,79r142,0r0,30r-142,0r0,88r158,0r0,30r-193,0","w":240},"F":{"d":"30,0r0,-258r173,0r0,31r-139,0r0,80r121,0r0,30r-121,0r0,117r-34,0","w":219,"k":{"A":20,".":40,",":40}},"G":{"d":"54,-130v-8,101,111,128,170,77r0,-48r-76,0r0,-30r110,0r0,95v-29,22,-61,40,-107,40v-80,0,-127,-52,-132,-132v-8,-116,138,-177,215,-100v10,10,16,25,20,42r-31,9v-9,-35,-33,-55,-75,-56v-64,0,-89,42,-94,103","w":280},"H":{"d":"29,0r0,-258r34,0r0,106r134,0r0,-106r34,0r0,258r-34,0r0,-121r-134,0r0,121r-34,0","w":259},"I":{"d":"34,0r0,-258r34,0r0,258r-34,0","w":100},"J":{"d":"152,-82v13,80,-77,109,-124,67v-13,-12,-18,-32,-18,-58r31,-4v1,34,9,51,38,51v31,0,39,-19,39,-54r0,-178r34,0r0,176","w":180},"K":{"d":"26,0r0,-258r34,0r0,128r128,-128r47,0r-108,105r112,153r-45,0r-91,-130r-43,41r0,89r-34,0","w":240},"L":{"d":"26,0r0,-258r34,0r0,228r127,0r0,30r-161,0","k":{"\u2019":20,"y":13,"Y":27,"W":27,"V":27,"T":27," ":13}},"M":{"d":"27,0r0,-258r51,0r73,221r76,-221r46,0r0,258r-33,0r0,-216r-75,216r-31,0r-74,-219r0,219r-33,0","w":299},"N":{"d":"27,0r0,-258r35,0r136,203r0,-203r32,0r0,258r-35,0r-135,-202r0,202r-33,0","w":259},"O":{"d":"141,4v-77,0,-122,-55,-124,-130v-2,-80,49,-136,124,-136v78,0,123,54,123,134v0,78,-48,132,-123,132xm141,-233v-57,0,-88,40,-88,108v0,57,35,100,87,100v55,0,90,-43,89,-104v-1,-60,-30,-104,-88,-104","w":280},"P":{"d":"224,-183v0,78,-78,83,-162,78r0,105r-34,0r0,-258v90,1,196,-17,196,75xm189,-182v0,-59,-69,-43,-127,-45r0,92v57,-1,127,12,127,-47","w":240,"k":{"A":27,".":46,",":46," ":7}},"Q":{"d":"262,-129v0,45,-14,77,-39,101v16,11,31,19,44,24r-10,24v-19,-7,-38,-18,-56,-32v-89,47,-191,-16,-186,-117v4,-77,45,-133,124,-133v77,0,123,53,123,133xm51,-129v0,75,53,122,122,97v-11,-7,-21,-11,-33,-14r8,-25v20,6,36,13,49,24v55,-50,34,-192,-58,-186v-55,3,-88,41,-88,104","w":280},"R":{"d":"234,-187v-1,42,-29,66,-72,70v46,24,63,76,93,117r-42,0v-30,-37,-46,-92,-92,-113v-15,-2,-41,-1,-59,-1r0,114r-34,0r0,-258v90,3,209,-22,206,71xm199,-187v0,-56,-81,-40,-137,-42r0,85v57,-2,136,14,137,-43","w":259,"k":{"Y":7,"W":7,"V":7,"T":7}},"S":{"d":"177,-136v81,33,37,140,-51,140v-65,0,-107,-28,-110,-87r32,-3v4,41,33,55,76,60v56,6,90,-59,34,-80v-45,-17,-132,-19,-132,-85v0,-83,139,-91,175,-35v8,12,12,26,13,41r-33,2v5,-62,-119,-67,-122,-10v-2,44,93,40,118,57","w":240},"T":{"d":"93,0r0,-227r-85,0r0,-31r205,0r0,31r-86,0r0,227r-34,0","w":219,"k":{"y":20,"w":20,"u":13,"s":40,"r":13,"o":40,"i":13,"e":40,"c":40,"a":40,"O":7,"A":27,";":40,":":40,".":40,"-":20,",":40," ":7}},"U":{"d":"127,-26v108,0,60,-141,70,-232r34,0r0,149v1,76,-28,113,-101,113v-74,0,-102,-37,-102,-113r0,-149r34,0v9,90,-34,232,65,232","w":259},"V":{"d":"101,0r-99,-258r36,0r81,230r83,-230r35,0r-101,258r-35,0","w":240,"k":{"y":13,"u":13,"r":13,"o":20,"i":7,"e":20,"a":27,"A":27,";":13,":":13,".":33,"-":20,",":33}},"W":{"d":"73,0r-69,-258r35,0r50,222r61,-222r41,0r37,131v9,32,16,63,20,91r53,-222r35,0r-71,258r-33,0r-62,-227r-62,227r-35,0","w":339,"k":{"y":3,"u":7,"r":7,"o":7,"e":7,"a":13,"A":13,";":7,":":7,".":20,"-":7,",":20}},"X":{"d":"2,0r99,-134r-88,-124r41,0r67,98r73,-98r37,0r-91,122r98,136r-42,0r-76,-109r-77,109r-41,0","w":240},"Y":{"d":"100,0r0,-109r-99,-149r42,0r77,122r78,-122r39,0r-103,149r0,109r-34,0","w":240,"k":{"v":20,"u":20,"q":33,"p":27,"o":33,"i":13,"e":33,"a":27,"A":27,";":23,":":20,".":46,"-":33,",":46," ":7}},"Z":{"d":"7,0r0,-32r132,-165v9,-12,19,-21,27,-30r-144,0r0,-31r185,0r0,31r-161,197r165,0r0,30r-204,0","w":219},"[":{"d":"24,72r0,-330r70,0r0,26r-38,0r0,277r38,0r0,27r-70,0","w":100},"\\":{"d":"75,4r-75,-266r25,0r75,266r-25,0","w":100},"]":{"d":"77,72r-70,0r0,-27r38,0r0,-277r-38,0r0,-26r70,0r0,330","w":100},"^":{"d":"42,-121r-33,0r63,-141r25,0r62,141r-31,0r-44,-105","w":168},"_":{"d":"-5,72r0,-23r209,0r0,23r-209,0"},"`":{"d":"82,-210r-26,0r-40,-49r42,0","w":119},"a":{"d":"175,-120v0,46,-6,99,10,120r-33,0v-3,-7,-5,-14,-6,-23v-33,39,-133,39,-133,-26v0,-63,86,-56,130,-69v3,-35,-13,-47,-45,-47v-32,0,-42,10,-49,36r-31,-4v8,-41,37,-58,85,-58v50,0,72,16,72,71xm84,-21v42,-2,63,-23,59,-73v-23,15,-97,3,-96,44v0,18,15,31,37,29"},"b":{"d":"185,-96v10,81,-84,134,-132,73r0,23r-29,0r0,-258r31,0r0,92v47,-57,140,-8,130,70xm104,-165v-33,0,-51,31,-51,70v0,44,15,73,49,73v33,0,51,-31,51,-72v0,-41,-16,-71,-49,-71"},"c":{"d":"47,-94v-15,78,93,98,99,26r31,4v-5,40,-35,68,-78,68v-54,0,-87,-39,-85,-97v-17,-102,139,-138,160,-39r-31,5v-6,-23,-18,-38,-43,-38v-37,0,-54,28,-53,71","w":180},"d":{"d":"91,-191v24,0,41,12,52,26r0,-93r31,0r0,258r-29,0r0,-24v-12,19,-29,28,-52,28v-53,-2,-81,-43,-81,-97v0,-55,26,-96,79,-98xm94,-165v-34,0,-49,29,-49,72v0,41,18,71,51,71v32,0,49,-29,49,-69v0,-44,-16,-74,-51,-74"},"e":{"d":"102,-22v28,0,41,-15,50,-38r32,4v-9,36,-37,60,-82,60v-56,1,-89,-38,-89,-96v0,-59,32,-99,87,-99v55,0,90,42,85,106r-139,0v2,37,21,63,56,63xm152,-111v2,-50,-57,-70,-88,-39v-10,10,-15,23,-16,39r104,0"},"f":{"d":"108,-231v-33,-9,-51,6,-45,44r36,0r0,25r-36,0r0,162r-32,0r0,-162r-28,0r0,-25r28,0v-7,-60,24,-85,81,-72","w":100,"k":{"\u2019":-7,"f":7}},"g":{"d":"176,-25v13,94,-74,121,-138,86v-15,-8,-20,-26,-20,-46r31,5v-1,35,56,37,77,21v18,-14,19,-25,18,-65v-14,16,-31,24,-52,24v-51,2,-80,-45,-80,-94v1,-55,25,-96,80,-97v22,0,41,9,55,27r0,-23r29,0r0,162xm95,-165v-33,0,-51,29,-51,68v0,42,16,71,51,71v35,0,52,-28,52,-70v0,-39,-20,-69,-52,-69"},"h":{"d":"105,-164v-69,0,-47,96,-50,164r-31,0r0,-258r31,0r0,93v38,-46,121,-31,121,47r0,118r-32,0v-8,-60,25,-164,-39,-164"},"i":{"d":"24,-221r0,-37r32,0r0,37r-32,0xm24,0r0,-187r32,0r0,187r-32,0","w":79},"j":{"d":"24,-221r0,-37r31,0r0,37r-31,0xm55,10v4,55,-26,74,-72,62r6,-26v28,7,35,-3,35,-37r0,-196r31,0r0,197","w":79},"k":{"d":"24,0r0,-258r32,0r0,147r74,-76r41,0r-71,70r79,117r-39,0r-62,-95r-22,21r0,74r-32,0","w":180},"l":{"d":"23,0r0,-258r32,0r0,258r-32,0","w":79},"m":{"d":"102,-163v-67,0,-42,97,-47,163r-31,0r0,-187r28,0r0,27v15,-38,98,-44,109,2v28,-52,116,-43,116,30r0,128r-32,0r0,-118v1,-31,-8,-44,-33,-45v-67,-2,-41,99,-46,163r-31,0r0,-121v-1,-26,-7,-42,-33,-42","w":299},"n":{"d":"105,-163v-69,-3,-46,97,-50,163r-31,0r0,-187r28,0r0,27v33,-53,123,-40,123,45r0,115r-31,0v-8,-59,25,-161,-39,-163"},"o":{"d":"99,4v-55,0,-87,-38,-87,-97v0,-59,32,-97,87,-98v54,0,88,39,88,95v0,64,-30,100,-88,100xm99,-165v-37,0,-55,30,-55,72v0,42,19,71,55,71v37,0,55,-29,55,-72v0,-42,-18,-71,-55,-71"},"p":{"d":"186,-95v8,78,-84,130,-131,76r0,91r-31,0r0,-259r29,0r0,25v12,-17,27,-29,54,-29v54,1,74,43,79,96xm104,-166v-32,0,-52,34,-52,74v0,41,17,70,50,70v34,0,51,-31,51,-73v0,-41,-16,-71,-49,-71"},"q":{"d":"13,-95v-11,-82,88,-129,133,-67r0,-25r28,0r0,259r-31,0r0,-92v-45,55,-141,3,-130,-75xm94,-166v-32,0,-49,31,-49,72v0,41,18,72,52,72v31,0,49,-30,49,-69v0,-42,-18,-75,-52,-75"},"r":{"d":"114,-151v-36,-23,-59,12,-59,53r0,98r-32,0r0,-187r29,0r0,29v13,-32,41,-42,73,-23","w":119,"k":{"\u2019":-13,".":20,",":20}},"s":{"d":"138,-99v56,31,18,103,-47,103v-48,0,-73,-19,-80,-60r31,-5v-2,47,89,53,92,9v-16,-47,-118,-16,-118,-85v0,-61,103,-69,132,-30v5,7,9,16,11,28r-31,5v2,-39,-81,-42,-81,-7v0,32,70,31,91,42","w":180},"t":{"d":"61,-53v-2,25,10,28,32,25r4,28v-45,6,-67,0,-67,-55r0,-107r-24,0r0,-25r24,0r0,-46r31,-19r0,65r32,0r0,25r-32,0r0,109","w":100},"u":{"d":"93,-23v70,2,46,-96,50,-164r31,0r0,187r-28,0r0,-27v-34,53,-123,38,-123,-44r0,-116r32,0v8,60,-25,163,38,164"},"v":{"d":"76,0r-71,-187r33,0r52,150r53,-150r33,0r-71,187r-29,0","w":180,"k":{".":27,",":27}},"w":{"d":"58,0r-57,-187r33,0r41,148v8,-38,28,-107,39,-148r32,0r38,144r42,-144r31,0r-58,187r-33,0r-37,-144r-38,144r-33,0","w":259,"k":{".":20,",":20}},"x":{"d":"3,0r68,-97r-63,-90r39,0r42,65v15,-24,30,-42,46,-65r37,0r-64,88r69,99r-38,0r-49,-74r-49,74r-38,0","w":180},"y":{"d":"22,72r-3,-30v38,11,50,-10,58,-42r-71,-187r34,0r39,108v5,14,9,29,13,44v14,-54,35,-101,53,-152r32,0r-89,233v-12,23,-35,37,-66,26","w":180,"k":{".":27,",":27}},"z":{"d":"7,0r0,-26r119,-136r-112,1r0,-26r153,0r0,21r-121,140r126,-1r0,27r-165,0","w":180},"{":{"d":"46,-9v0,-44,-1,-66,-36,-70r0,-29v34,-3,37,-25,36,-67v-2,-63,6,-89,66,-87r0,28v-30,-1,-37,4,-36,36v0,67,1,84,-37,105v29,13,36,33,37,79v1,48,-6,61,36,62r0,28v-59,3,-67,-25,-66,-85","w":120},"|":{"d":"33,76r0,-338r28,0r0,338r-28,0","w":93},"}":{"d":"74,-178v0,44,1,66,36,70r0,29v-34,3,-37,26,-36,68v1,63,-6,89,-66,87r0,-28v30,1,37,-4,36,-36v0,-64,1,-86,37,-105v-29,-15,-37,-32,-37,-79v0,-48,7,-62,-36,-62r0,-28v58,-3,67,25,66,84","w":120},"~":{"d":"61,-122v-23,0,-30,10,-46,24r0,-36v34,-42,92,-8,135,3v19,0,35,-14,45,-25r0,38v-14,12,-26,19,-49,20v-28,1,-59,-24,-85,-24","w":210},"\u00c4":{"d":"67,-274r0,-36r33,0r0,36r-33,0xm132,-274r0,-36r33,0r0,36r-33,0xm-1,0r99,-258r37,0r106,258r-39,0r-30,-78r-108,0r-28,78r-37,0xm74,-106r87,0r-45,-125v-9,45,-28,84,-42,125","w":240},"\u00c5":{"d":"116,-249v-18,0,-31,-14,-31,-32v0,-18,13,-32,31,-32v17,0,32,14,32,32v1,18,-14,33,-32,32xm117,-300v-10,0,-20,9,-19,19v-1,11,9,19,19,19v10,0,19,-9,18,-19v1,-10,-9,-19,-18,-19xm-1,0r99,-258r37,0r106,258r-39,0r-30,-78r-108,0r-28,78r-37,0xm74,-106r87,0r-45,-125v-9,45,-28,84,-42,125","w":240},"\u00d6":{"d":"91,-274r0,-36r33,0r0,36r-33,0xm156,-274r0,-36r33,0r0,36r-33,0xm141,4v-77,0,-122,-55,-124,-130v-2,-80,49,-136,124,-136v78,0,123,54,123,134v0,78,-48,132,-123,132xm141,-233v-57,0,-88,40,-88,108v0,57,35,100,87,100v55,0,90,-43,89,-104v-1,-60,-30,-104,-88,-104","w":280},"\u00dc":{"d":"80,-274r0,-36r33,0r0,36r-33,0xm145,-274r0,-36r33,0r0,36r-33,0xm127,-26v108,0,60,-141,70,-232r34,0r0,149v1,76,-28,113,-101,113v-74,0,-102,-37,-102,-113r0,-149r34,0v9,90,-34,232,65,232","w":259},"\u00e1":{"d":"81,-210r24,-49r41,0r-38,49r-27,0xm175,-120v0,46,-6,99,10,120r-33,0v-3,-7,-5,-14,-6,-23v-33,39,-133,39,-133,-26v0,-63,86,-56,130,-69v3,-35,-13,-47,-45,-47v-32,0,-42,10,-49,36r-31,-4v8,-41,37,-58,85,-58v50,0,72,16,72,71xm84,-21v42,-2,63,-23,59,-73v-23,15,-97,3,-96,44v0,18,15,31,37,29"},"\u00e0":{"d":"175,-120v0,46,-6,99,10,120r-33,0v-3,-7,-5,-14,-6,-23v-33,39,-133,39,-133,-26v0,-63,86,-56,130,-69v3,-35,-13,-47,-45,-47v-32,0,-42,10,-49,36r-31,-4v8,-41,37,-58,85,-58v50,0,72,16,72,71xm84,-21v42,-2,63,-23,59,-73v-23,15,-97,3,-96,44v0,18,15,31,37,29xm126,-210r-26,0r-40,-49r42,0"},"\u00e2":{"d":"99,-240r-19,30r-37,0r38,-49r34,0r40,49r-36,0xm175,-120v0,46,-6,99,10,120r-33,0v-3,-7,-5,-14,-6,-23v-33,39,-133,39,-133,-26v0,-63,86,-56,130,-69v3,-35,-13,-47,-45,-47v-32,0,-42,10,-49,36r-31,-4v8,-41,37,-58,85,-58v50,0,72,16,72,71xm84,-21v42,-2,63,-23,59,-73v-23,15,-97,3,-96,44v0,18,15,31,37,29"},"\u00e4":{"d":"50,-223r0,-36r33,0r0,36r-33,0xm115,-223r0,-36r33,0r0,36r-33,0xm175,-120v0,46,-6,99,10,120r-33,0v-3,-7,-5,-14,-6,-23v-33,39,-133,39,-133,-26v0,-63,86,-56,130,-69v3,-35,-13,-47,-45,-47v-32,0,-42,10,-49,36r-31,-4v8,-41,37,-58,85,-58v50,0,72,16,72,71xm84,-21v42,-2,63,-23,59,-73v-23,15,-97,3,-96,44v0,18,15,31,37,29"},"\u00e3":{"d":"77,-231v-9,0,-14,6,-13,17r-24,0v-1,-23,15,-40,36,-40v14,-4,57,33,59,-1r23,0v0,24,-12,40,-35,40v-9,2,-35,-15,-46,-16xm175,-120v0,46,-6,99,10,120r-33,0v-3,-7,-5,-14,-6,-23v-33,39,-133,39,-133,-26v0,-63,86,-56,130,-69v3,-35,-13,-47,-45,-47v-32,0,-42,10,-49,36r-31,-4v8,-41,37,-58,85,-58v50,0,72,16,72,71xm84,-21v42,-2,63,-23,59,-73v-23,15,-97,3,-96,44v0,18,15,31,37,29"},"\u00e5":{"d":"99,-202v-17,0,-32,-16,-32,-33v0,-17,15,-31,32,-32v17,0,32,16,32,33v0,17,-15,31,-32,32xm99,-254v-9,0,-19,9,-18,19v-1,11,8,19,18,19v10,0,19,-10,19,-19v0,-9,-10,-19,-19,-19xm175,-120v0,46,-6,99,10,120r-33,0v-3,-7,-5,-14,-6,-23v-33,39,-133,39,-133,-26v0,-63,86,-56,130,-69v3,-35,-13,-47,-45,-47v-32,0,-42,10,-49,36r-31,-4v8,-41,37,-58,85,-58v50,0,72,16,72,71xm84,-21v42,-2,63,-23,59,-73v-23,15,-97,3,-96,44v0,18,15,31,37,29"},"\u00e7":{"d":"100,35v-2,-11,-13,-11,-28,-11r9,-32r24,0r-6,19v17,1,30,11,30,26v0,31,-43,37,-76,31r2,-20v21,1,42,3,45,-13xm47,-94v-15,78,93,98,99,26r31,4v-5,40,-35,68,-78,68v-54,0,-87,-39,-85,-97v-17,-102,139,-138,160,-39r-31,5v-6,-23,-18,-38,-43,-38v-37,0,-54,28,-53,71","w":180},"\u00e9":{"d":"82,-210r23,-49r42,0r-39,49r-26,0xm102,-22v28,0,41,-15,50,-38r32,4v-9,36,-37,60,-82,60v-56,1,-89,-38,-89,-96v0,-59,32,-99,87,-99v55,0,90,42,85,106r-139,0v2,37,21,63,56,63xm152,-111v2,-50,-57,-70,-88,-39v-10,10,-15,23,-16,39r104,0"},"\u00e8":{"d":"102,-22v28,0,41,-15,50,-38r32,4v-9,36,-37,60,-82,60v-56,1,-89,-38,-89,-96v0,-59,32,-99,87,-99v55,0,90,42,85,106r-139,0v2,37,21,63,56,63xm152,-111v2,-50,-57,-70,-88,-39v-10,10,-15,23,-16,39r104,0xm121,-210r-26,0r-40,-49r42,0"},"\u00ea":{"d":"100,-240r-20,30r-36,0r38,-49r33,0r40,49r-36,0xm102,-22v28,0,41,-15,50,-38r32,4v-9,36,-37,60,-82,60v-56,1,-89,-38,-89,-96v0,-59,32,-99,87,-99v55,0,90,42,85,106r-139,0v2,37,21,63,56,63xm152,-111v2,-50,-57,-70,-88,-39v-10,10,-15,23,-16,39r104,0"},"\u00ed":{"d":"35,0r0,-187r31,0r0,187r-31,0xm33,-210r24,-49r41,0r-39,49r-26,0","w":100},"\u00ec":{"d":"35,0r0,-187r31,0r0,187r-31,0xm73,-210r-26,0r-40,-49r42,0","w":100},"\u00ee":{"d":"53,-240r-20,30r-36,0r38,-49r34,0r39,49r-36,0xm35,0r0,-187r31,0r0,187r-31,0","w":100},"\u00ef":{"d":"35,0r0,-187r31,0r0,187r-31,0xm2,-223r0,-36r33,0r0,36r-33,0xm67,-223r0,-36r33,0r0,36r-33,0","w":100},"\u00f1":{"d":"129,-215v-15,3,-59,-37,-60,1r-23,0v-1,-23,15,-40,36,-40v14,-3,57,33,59,-1r23,0v0,24,-12,40,-35,40xm105,-163v-69,-3,-46,97,-50,163r-31,0r0,-187r28,0r0,27v33,-53,123,-40,123,45r0,115r-31,0v-8,-59,25,-161,-39,-163"},"\u00f3":{"d":"82,-210r23,-49r42,0r-39,49r-26,0xm99,4v-55,0,-87,-38,-87,-97v0,-59,32,-97,87,-98v54,0,88,39,88,95v0,64,-30,100,-88,100xm99,-165v-37,0,-55,30,-55,72v0,42,19,71,55,71v37,0,55,-29,55,-72v0,-42,-18,-71,-55,-71"},"\u00f2":{"d":"99,4v-55,0,-87,-38,-87,-97v0,-59,32,-97,87,-98v54,0,88,39,88,95v0,64,-30,100,-88,100xm99,-165v-37,0,-55,30,-55,72v0,42,19,71,55,71v37,0,55,-29,55,-72v0,-42,-18,-71,-55,-71xm121,-210r-26,0r-40,-49r42,0"},"\u00f4":{"d":"100,-240r-20,30r-36,0r38,-49r33,0r40,49r-36,0xm99,4v-55,0,-87,-38,-87,-97v0,-59,32,-97,87,-98v54,0,88,39,88,95v0,64,-30,100,-88,100xm99,-165v-37,0,-55,30,-55,72v0,42,19,71,55,71v37,0,55,-29,55,-72v0,-42,-18,-71,-55,-71"},"\u00f6":{"d":"50,-223r0,-36r33,0r0,36r-33,0xm116,-223r0,-36r33,0r0,36r-33,0xm99,4v-55,0,-87,-38,-87,-97v0,-59,32,-97,87,-98v54,0,88,39,88,95v0,64,-30,100,-88,100xm99,-165v-37,0,-55,30,-55,72v0,42,19,71,55,71v37,0,55,-29,55,-72v0,-42,-18,-71,-55,-71"},"\u00f5":{"d":"124,-215v-15,3,-59,-37,-60,1r-23,0v-1,-23,14,-40,35,-40v14,-4,57,34,59,-1r23,0v0,23,-12,40,-34,40xm99,4v-55,0,-87,-38,-87,-97v0,-59,32,-97,87,-98v54,0,88,39,88,95v0,64,-30,100,-88,100xm99,-165v-37,0,-55,30,-55,72v0,42,19,71,55,71v37,0,55,-29,55,-72v0,-42,-18,-71,-55,-71"},"\u00fa":{"d":"80,-210r23,-49r41,0r-38,49r-26,0xm93,-23v70,2,46,-96,50,-164r31,0r0,187r-28,0r0,-27v-34,53,-123,38,-123,-44r0,-116r32,0v8,60,-25,163,38,164"},"\u00f9":{"d":"93,-23v70,2,46,-96,50,-164r31,0r0,187r-28,0r0,-27v-34,53,-123,38,-123,-44r0,-116r32,0v8,60,-25,163,38,164xm128,-210r-26,0r-40,-49r42,0"},"\u00fb":{"d":"99,-240r-20,30r-36,0r38,-49r34,0r39,49r-36,0xm93,-23v70,2,46,-96,50,-164r31,0r0,187r-28,0r0,-27v-34,53,-123,38,-123,-44r0,-116r32,0v8,60,-25,163,38,164"},"\u00fc":{"d":"49,-223r0,-36r33,0r0,36r-33,0xm115,-223r0,-36r33,0r0,36r-33,0xm93,-23v70,2,46,-96,50,-164r31,0r0,187r-28,0r0,-27v-34,53,-123,38,-123,-44r0,-116r32,0v8,60,-25,163,38,164"},"\u00a3":{"d":"190,-7v-55,33,-123,-30,-173,12r-12,-30v26,-14,49,-50,37,-91r-34,0r0,-26r27,0v-27,-60,6,-120,71,-120v44,0,73,28,78,67r-32,4v0,-56,-94,-59,-92,-2v0,13,3,30,10,51r55,0r0,26r-50,0v10,34,-9,61,-28,82v49,-15,93,26,133,-2"},"\u00df":{"d":"101,-236v-33,2,-43,19,-42,62r0,174r-32,0r0,-176v-2,-57,24,-84,75,-86v35,-1,65,20,65,50v1,28,-23,49,-27,72v10,34,69,40,69,85v0,48,-62,77,-103,48v-11,-8,-19,-19,-25,-31r27,-13v9,36,68,39,68,-1v0,-40,-68,-44,-68,-83v0,-28,29,-46,28,-73v0,-16,-15,-30,-35,-28","w":219},"\u2122":{"d":"86,-114r0,-122r-46,0r0,-22r117,0r0,22r-47,0r0,122r-24,0xm173,-114r0,-144r35,0r36,115r35,-115r34,0r0,144r-21,0r0,-121r-37,121r-22,0r-38,-122r0,122r-22,0","w":360},"\u00e6":{"d":"305,-57v-9,66,-121,82,-152,26v-21,20,-41,35,-77,35v-37,1,-63,-20,-64,-53v0,-61,77,-55,127,-69v1,-33,-8,-48,-41,-47v-30,1,-46,8,-50,36r-31,-4v2,-63,113,-77,146,-33v15,-16,31,-24,60,-25v59,0,86,48,82,106r-135,0v-11,72,91,83,102,24xm273,-111v2,-49,-55,-70,-87,-40v-9,9,-15,23,-16,40r103,0xm46,-50v5,49,85,28,91,-6v1,-6,2,-19,2,-38v-15,12,-97,5,-93,44","w":320},"\u00f8":{"d":"23,-91v-6,-84,76,-123,139,-85r17,-22r17,12r-19,24v44,57,17,166,-67,166v-19,0,-36,-5,-50,-14r-18,24r-17,-13r19,-24v-15,-17,-19,-39,-21,-68xm144,-152v-42,-33,-89,2,-89,59v0,18,3,32,9,44xm78,-33v56,40,111,-35,79,-102","w":219},"\u00bf":{"d":"129,-187r0,36r-36,0r0,-36r36,0xm28,5v0,-61,74,-59,68,-128r31,0v10,71,-61,73,-67,126v-3,24,24,48,50,46v32,-1,47,-20,52,-52r32,4v-6,45,-33,74,-83,74v-46,0,-83,-28,-83,-70","w":219},"\u00ab":{"d":"60,-93r45,80r-25,0r-56,-80r56,-80r26,0xm128,-93r46,80r-27,0r-55,-80r55,-80r27,0"},"\u00bb":{"d":"139,-93r-46,-80r26,0r56,80r-56,80r-26,0xm71,-93r-46,-80r26,0r55,80r-55,80r-26,0"},"\u2026":{"d":"42,0r0,-36r36,0r0,36r-36,0xm162,0r0,-36r36,0r0,36r-36,0xm282,0r0,-36r36,0r0,36r-36,0","w":360},"\u2013":{"d":"-1,-81r0,-25r201,0r0,25r-201,0"},"\u2014":{"d":"0,-81r0,-25r360,0r0,25r-360,0","w":360},"\u201c":{"d":"49,-214r0,36r-34,0v-1,-40,-2,-74,29,-84r7,12v-13,7,-19,16,-19,36r17,0xm103,-214r0,36r-34,0v-1,-41,0,-74,29,-84r8,12v-13,7,-19,16,-20,36r17,0","w":119},"\u201d":{"d":"15,-224r0,-36r34,0v1,40,2,74,-29,84r-8,-12v13,-6,20,-17,20,-36r-17,0xm70,-224r0,-36r34,0v1,41,0,74,-29,84r-8,-12v13,-6,19,-17,19,-36r-16,0","w":119},"\u2018":{"d":"56,-214r0,36r-34,0v-1,-41,0,-74,30,-84r7,12v-13,7,-19,16,-19,36r16,0","w":79,"k":{"\u2018":7}},"\u2019":{"d":"22,-224r0,-36r34,0v1,41,0,74,-29,84r-8,-12v13,-6,19,-17,19,-36r-16,0","w":79,"k":{"\u2019":7,"s":7," ":13}},"\u00ff":{"d":"43,-223r0,-36r33,0r0,36r-33,0xm108,-223r0,-36r33,0r0,36r-33,0xm22,72r-3,-30v38,11,50,-10,58,-42r-71,-187r34,0r39,108v5,14,9,29,13,44v14,-54,35,-101,53,-152r32,0r-89,233v-12,23,-35,37,-66,26","w":180},"\u20ac":{"d":"20,-164v6,-76,101,-122,175,-84r-7,33v-50,-42,-129,-5,-132,51r120,0r-5,23r-118,0r0,23r113,0r-4,24r-105,0v2,62,85,89,131,52r0,36v-78,31,-156,-11,-166,-88r-27,0r5,-24r18,0r0,-23r-23,0r5,-23r20,0"},"\u0142":{"d":"23,-101r-22,19r0,-27r22,-20r0,-129r32,0r0,103r24,-21r0,28r-24,20r0,128r-32,0r0,-101","w":79},"\u00d7":{"d":"28,-72r56,-55r-56,-55r22,-22r55,55r55,-55r21,22r-55,55r56,55r-22,21r-55,-55r-55,55","w":210},"\u0107":{"d":"75,-210r23,-49r41,0r-38,49r-26,0xm47,-94v-15,78,93,98,99,26r31,4v-5,40,-35,68,-78,68v-54,0,-87,-39,-85,-97v-17,-102,139,-138,160,-39r-31,5v-6,-23,-18,-38,-43,-38v-37,0,-54,28,-53,71","w":180},"\u0105":{"d":"223,60v-26,17,-81,14,-77,-28v0,-10,2,-24,7,-41r22,0v-13,23,-9,56,18,56v9,0,19,-3,30,-8r0,21xm175,-120v0,46,-6,99,10,120r-33,0v-3,-7,-5,-14,-6,-23v-33,39,-133,39,-133,-26v0,-63,86,-56,130,-69v3,-35,-13,-47,-45,-47v-32,0,-42,10,-49,36r-31,-4v8,-41,37,-58,85,-58v50,0,72,16,72,71xm84,-21v42,-2,63,-23,59,-73v-23,15,-97,3,-96,44v0,18,15,31,37,29"},"\u0119":{"d":"165,64v-27,18,-80,15,-77,-28v0,-10,2,-23,7,-40r22,0v-13,22,-9,55,18,55v9,0,19,-3,30,-8r0,21xm102,-22v28,0,41,-15,50,-38r32,4v-9,36,-37,60,-82,60v-56,1,-89,-38,-89,-96v0,-59,32,-99,87,-99v55,0,90,42,85,106r-139,0v2,37,21,63,56,63xm152,-111v2,-50,-57,-70,-88,-39v-10,10,-15,23,-16,39r104,0"},"\u0151":{"d":"50,-210r21,-49r41,0r-37,49r-25,0xm111,-210r22,-49r41,0r-37,49r-26,0xm99,4v-55,0,-87,-38,-87,-97v0,-59,32,-97,87,-98v54,0,88,39,88,95v0,64,-30,100,-88,100xm99,-165v-37,0,-55,30,-55,72v0,42,19,71,55,71v37,0,55,-29,55,-72v0,-42,-18,-71,-55,-71"},"\u015b":{"d":"69,-210r24,-49r41,0r-39,49r-26,0xm138,-99v56,31,18,103,-47,103v-48,0,-73,-19,-80,-60r31,-5v-2,47,89,53,92,9v-16,-47,-118,-16,-118,-85v0,-61,103,-69,132,-30v5,7,9,16,11,28r-31,5v2,-39,-81,-42,-81,-7v0,32,70,31,91,42","w":180},"\u0171":{"d":"42,-210r21,-49r41,0r-37,49r-25,0xm103,-210r22,-49r41,0r-37,49r-26,0xm93,-23v70,2,46,-96,50,-164r31,0r0,187r-28,0r0,-27v-34,53,-123,38,-123,-44r0,-116r32,0v8,60,-25,163,38,164"},"\u017a":{"d":"69,-210r23,-49r42,0r-39,49r-26,0xm7,0r0,-26r119,-136r-112,1r0,-26r153,0r0,21r-121,140r126,-1r0,27r-165,0","w":180},"\u017c":{"d":"70,-210r0,-39r39,0r0,39r-39,0xm7,0r0,-26r119,-136r-112,1r0,-26r153,0r0,21r-121,140r126,-1r0,27r-165,0","w":180},"\u2032":{"d":"22,-166v1,-34,5,-64,12,-92r36,0v-6,34,-16,64,-28,92r-20,0","w":67},"\u2033":{"d":"22,-166v1,-34,5,-64,12,-92r36,0v-6,34,-16,64,-28,92r-20,0xm72,-166v1,-34,5,-64,12,-92r36,0v-6,34,-16,64,-28,92r-20,0","w":127}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Typeface  The Monotype Corporation plc. Data  The Monotype Corporation
 * plc/Type Solutions Inc. 1990-1992. All Rights Reserved
 * 
 * Trademark:
 * Arial Trademark of The Monotype Corporation plc registered in the US Pat & TM
 * Off. and elsewhere.
 * 
 * Description:
 * Contemporary sans serif design, Arial contains more humanist characteristics
 * than many of its predecessors and as such is more in tune with the mood of the
 * last decades of the twentieth century.  The overall treatment of curves is
 * softer and fuller than in most industrial style sans serif faces.  Terminal
 * strokes are cut on the diagonal which helps to give the face a less mechanical
 * appearance.  Arial is an extremely versatile family of typefaces which can be
 * used with equal success for text setting in reports, presentations, magazines
 * etc, and for display use in newspapers, advertising and promotions.
 * 
 * Manufacturer:
 * Monotype Typography
 * 
 * Designer:
 * Monotype Type Drawing Office - Robin Nicholas, Patricia Saunders 1982
 * 
 * Vendor URL:
 * http://www.monotype.com/html/mtname/ms_arial.html
 * 
 * License information:
 * http://www.monotype.com/html/type/license.html
 */
Cufon.registerFont({"w":200,"face":{"font-family":"Arial","font-weight":700,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 7 4 2 2 2 2 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-17 -315 360 76.147","underline-thickness":"37.793","underline-position":"-19.3359","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":100,"k":{"Y":7,"A":13}},"\u00a0":{"w":100},"!":{"d":"45,-66v-5,-63,-15,-121,-13,-192r54,0v2,71,-7,129,-13,192r-28,0xm34,0r0,-49r50,0r0,49r-50,0","w":119},"\"":{"d":"29,-166v-6,-28,-11,-56,-9,-92r53,0v2,35,-2,64,-8,92r-36,0xm108,-166v-6,-28,-11,-56,-9,-92r54,0v2,35,-2,64,-8,92r-37,0","w":170},"#":{"d":"27,-64r-24,0r0,-39r32,0r10,-52r-42,0r0,-39r50,0r14,-68r40,0r-14,68r38,0r14,-68r41,0r-14,68r24,0r0,39r-32,0r-11,52r43,0r0,39r-51,0r-14,68r-39,0r14,-68r-39,0r-14,68r-40,0xm85,-155r-10,52r39,0r10,-52r-39,0"},"$":{"d":"184,-77v1,44,-31,76,-73,80r0,33r-25,0r0,-32v-42,-5,-67,-34,-74,-76r46,-5v4,17,15,33,28,39r0,-74v-40,-12,-67,-33,-67,-78v0,-39,30,-68,67,-71r0,-17r25,0r0,17v38,5,60,25,66,61r-44,6v-3,-14,-11,-23,-22,-28r0,69v48,14,72,26,73,76xm86,-223v-29,6,-30,54,0,61r0,-61xm111,-36v24,-2,40,-34,23,-55v-5,-6,-12,-10,-23,-13r0,68"},"%":{"d":"73,-126v-39,0,-57,-25,-57,-68v0,-42,18,-68,56,-68v39,0,57,25,57,68v0,42,-18,68,-56,68xm72,-234v-17,1,-18,16,-18,40v0,24,2,36,18,40v26,0,26,-82,0,-80xm110,10r-37,0r137,-272r36,0xm247,10v-40,0,-58,-26,-58,-68v0,-42,18,-68,57,-68v39,0,57,25,57,68v0,42,-17,68,-56,68xm246,-98v-17,2,-18,16,-18,40v0,24,1,37,18,40v17,-2,18,-16,18,-40v0,-24,-1,-37,-18,-40","w":320},"&":{"d":"214,-61v8,8,31,25,40,30r-30,38v-15,-7,-29,-17,-42,-30v-44,49,-172,32,-166,-48v2,-41,27,-62,59,-79v-15,-16,-27,-32,-27,-56v0,-35,31,-56,72,-56v40,0,71,23,71,59v0,33,-18,41,-47,61r36,47v4,-8,8,-17,11,-29r45,10v-7,26,-11,37,-22,53xm121,-227v-41,2,-19,42,-1,55v10,-8,28,-20,28,-32v0,-14,-12,-24,-27,-23xm100,-118v-39,12,-49,83,5,82v21,-1,32,-9,46,-20","w":259},"'":{"d":"25,-166v-6,-28,-11,-56,-9,-92r54,0v2,35,-2,64,-8,92r-37,0","w":85},"(":{"d":"108,-262v-55,100,-54,241,0,338r-34,0v-31,-46,-53,-103,-55,-169v-1,-69,26,-126,56,-169r33,0","w":119},")":{"d":"101,-96v-1,69,-23,124,-55,172r-34,0v54,-95,55,-240,0,-338r33,0v31,44,56,98,56,166","w":119},"*":{"d":"43,-139r-26,-21r33,-34r-45,-11r10,-31v15,6,29,13,41,21v-3,-19,-4,-35,-4,-47r31,0v0,9,-1,24,-4,47r44,-19r9,32v-13,3,-28,5,-45,8r31,36r-27,18r-23,-40v-7,13,-16,27,-25,41","w":140},"+":{"d":"82,-37r0,-67r-67,0r0,-46r67,0r0,-67r45,0r0,67r68,0r0,46r-68,0r0,67r-45,0","w":210},",":{"d":"25,-49r49,0v2,53,-1,95,-44,106r-9,-20v19,-5,27,-15,28,-37r-24,0r0,-49","w":100},"-":{"d":"20,-69r0,-49r97,0r0,49r-97,0","w":119},"\u00ad":{"d":"20,-69r0,-49r97,0r0,49r-97,0","w":119},".":{"d":"26,0r0,-49r49,0r0,49r-49,0","w":100},"\/":{"d":"-1,4r64,-266r37,0r-64,266r-37,0","w":100},"0":{"d":"15,-128v0,-79,18,-131,84,-131v66,0,83,54,83,132v0,78,-17,131,-83,131v-65,0,-84,-50,-84,-132xm99,-37v48,0,32,-111,27,-152v-2,-18,-10,-28,-27,-29v-35,7,-32,41,-32,91v0,52,-4,83,32,90"},"1":{"d":"28,-194v27,-9,65,-37,74,-65r40,0r0,259r-50,0r0,-186v-18,17,-40,29,-64,37r0,-45","k":{"1":20}},"2":{"d":"182,-187v1,71,-71,97,-98,141r98,0r0,46r-173,0v3,-65,81,-112,113,-153v20,-24,12,-67,-23,-65v-23,2,-33,15,-35,40r-49,-4v5,-51,34,-76,85,-77v46,-1,82,29,82,72"},"3":{"d":"136,-139v91,25,42,143,-38,143v-46,0,-81,-29,-84,-72r47,-6v3,21,16,37,37,37v22,1,36,-18,36,-42v0,-32,-25,-50,-57,-37r5,-40v45,8,58,-61,13,-62v-18,1,-31,15,-32,34r-46,-7v8,-43,32,-65,80,-68v69,-4,108,91,39,120"},"4":{"d":"112,0r0,-52r-105,0r0,-43r111,-164r42,0r0,164r32,0r0,43r-32,0r0,52r-48,0xm112,-95r0,-88r-59,88r59,0"},"5":{"d":"189,-86v0,103,-162,125,-173,20r49,-5v2,19,18,36,37,36v24,0,37,-22,37,-51v0,-49,-52,-62,-77,-28r-40,-6r25,-134r131,0r0,46r-93,0r-8,44v58,-28,112,19,112,78"},"6":{"d":"15,-125v0,-82,27,-134,95,-134v42,0,66,26,73,64r-48,6v0,-32,-39,-38,-55,-15v-7,9,-12,28,-14,58v44,-51,121,-3,121,63v0,50,-33,89,-82,87v-63,-2,-90,-51,-90,-129xm105,-131v-21,0,-34,18,-34,44v0,27,14,50,36,50v23,0,32,-18,32,-45v0,-29,-11,-49,-34,-49"},"7":{"d":"50,0v2,-81,37,-158,78,-208r-113,0r0,-46r169,0r0,36v-43,45,-85,132,-86,218r-48,0"},"8":{"d":"15,-74v0,-32,17,-55,43,-65v-22,-9,-37,-26,-37,-53v0,-41,31,-67,77,-67v76,0,106,96,42,120v26,10,43,31,44,63v0,48,-35,81,-83,81v-48,0,-87,-32,-86,-79xm99,-220v-17,0,-31,13,-31,31v0,19,12,31,30,31v18,0,31,-12,31,-31v0,-18,-13,-31,-30,-31xm99,-118v-22,0,-36,19,-36,40v-1,24,16,43,37,43v22,0,35,-18,35,-43v0,-23,-15,-40,-36,-40"},"9":{"d":"184,-129v0,81,-28,134,-95,134v-43,0,-66,-26,-73,-65r48,-5v0,31,40,38,55,15v7,-9,12,-29,14,-59v-44,51,-122,5,-122,-63v0,-49,35,-89,83,-87v63,3,90,52,90,130xm94,-123v21,0,34,-20,34,-45v0,-27,-13,-50,-36,-50v-22,0,-32,18,-32,46v0,29,11,49,34,49"},":":{"d":"35,-137r0,-50r50,0r0,50r-50,0xm35,0r0,-49r50,0r0,49r-50,0","w":119},";":{"d":"34,-137r0,-50r49,0r0,50r-49,0xm34,-49r49,0v2,52,1,96,-43,106r-10,-20v18,-6,27,-16,28,-37r-24,0r0,-49","w":119},"\u037e":{"d":"34,-137r0,-50r49,0r0,50r-49,0xm34,-49r49,0v2,52,1,96,-43,106r-10,-20v18,-6,27,-16,28,-37r-24,0r0,-49","w":119},"<":{"d":"193,-29r-176,-77r0,-43r176,-76r0,50r-123,47r123,49r0,50","w":210},"=":{"d":"15,-143r0,-46r180,0r0,46r-180,0xm15,-65r0,-46r180,0r0,46r-180,0","w":210},">":{"d":"17,-29r0,-50r123,-48r-123,-48r0,-50r177,77r0,42","w":210},"?":{"d":"111,-260v61,0,113,51,83,105v-6,11,-48,44,-59,60v-3,5,-3,15,-3,29r-45,0v-12,-71,62,-74,68,-122v3,-21,-20,-35,-42,-35v-29,1,-43,17,-49,44r-45,-6v1,-44,43,-75,92,-75xm87,0r0,-49r50,0r0,49r-50,0","w":219},"@":{"d":"191,43v56,1,97,-14,121,-46r38,0v-25,51,-81,79,-156,79v-110,0,-183,-55,-183,-161v0,-107,70,-177,180,-177v89,0,146,50,149,135v1,66,-53,129,-116,127v-19,0,-28,-5,-32,-20v-43,44,-115,10,-115,-54v0,-76,86,-160,141,-93r5,-19r46,0r-29,141v0,6,2,9,7,9v36,-8,61,-49,62,-92v0,-63,-51,-102,-119,-102v-93,0,-147,60,-147,148v0,84,62,125,148,125xm176,-159v-37,0,-52,47,-54,83v-1,26,11,44,32,44v40,0,53,-47,55,-86v1,-23,-13,-41,-33,-41","w":351},"A":{"d":"259,0r-57,0r-23,-59r-103,0r-21,59r-55,0r100,-258r55,0xm163,-102r-36,-96r-35,96r71,0","w":259,"k":{"\u2019":20,"y":13,"w":7,"v":13,"Y":33,"W":20,"V":27,"T":27," ":13}},"B":{"d":"242,-75v0,66,-41,75,-128,75r-88,0r0,-258v88,3,202,-21,204,65v0,27,-18,47,-37,56v29,8,49,28,49,62xm179,-185v0,-43,-52,-27,-101,-30r0,60v45,-2,101,11,101,-30xm188,-77v0,-49,-61,-32,-110,-35r0,69v47,-3,110,14,110,-34","w":259},"C":{"d":"134,-40v34,0,51,-23,57,-55r51,16v-15,51,-46,83,-108,83v-71,0,-117,-54,-117,-131v0,-139,187,-188,224,-60r-52,13v-5,-24,-25,-45,-54,-44v-44,1,-64,35,-64,88v0,56,18,90,63,90","w":259},"D":{"d":"242,-126v0,80,-32,126,-118,126r-98,0r0,-258r95,0v89,-2,121,47,121,132xm188,-129v2,-75,-30,-91,-110,-85r0,171r39,0v59,2,70,-28,71,-86","w":259},"E":{"d":"26,0r0,-258r191,0r0,44r-139,0r0,57r130,0r0,43r-130,0r0,71r144,0r0,43r-196,0","w":240},"F":{"d":"27,0r0,-258r176,0r0,44r-124,0r0,61r107,0r0,43r-107,0r0,110r-52,0","w":219,"k":{"A":20,".":40,",":40}},"G":{"d":"71,-132v0,87,83,114,135,70r0,-33r-60,0r0,-43r112,0r0,102v-20,21,-69,41,-110,40v-82,-1,-131,-52,-131,-134v0,-80,44,-131,128,-132v62,0,99,26,110,76r-52,9v-7,-25,-27,-41,-58,-41v-49,1,-74,33,-74,86","w":280},"H":{"d":"26,0r0,-258r52,0r0,102r102,0r0,-102r52,0r0,258r-52,0r0,-113r-102,0r0,113r-52,0","w":259},"I":{"d":"25,0r0,-258r52,0r0,258r-52,0","w":100},"J":{"d":"87,-40v29,0,31,-16,32,-51r0,-167r52,0v-8,109,36,267,-85,262v-52,-2,-81,-30,-80,-84r49,-5v1,29,9,45,32,45"},"K":{"d":"27,0r0,-258r52,0r0,115r105,-115r70,0r-97,101r102,157r-67,0r-71,-121r-42,43r0,78r-52,0","w":259},"L":{"d":"28,0r0,-256r52,0r0,213r129,0r0,43r-181,0","w":219,"k":{"\u2019":20,"y":13,"Y":33,"W":20,"V":27,"T":27," ":7}},"M":{"d":"25,0r0,-258r78,0r47,176r46,-176r78,0r0,258r-48,0r0,-203r-51,203r-50,0r-51,-203r0,203r-49,0","w":299},"N":{"d":"27,0r0,-258r50,0r106,172r0,-172r48,0r0,258r-52,0r-104,-168r0,168r-48,0","w":259},"O":{"d":"141,4v-76,0,-126,-52,-125,-131v1,-85,41,-133,124,-135v78,-1,126,54,126,134v0,81,-48,132,-125,132xm141,-218v-48,0,-72,36,-72,89v0,53,25,89,72,89v48,0,71,-37,71,-90v0,-53,-24,-88,-71,-88","w":280},"P":{"d":"224,-178v0,76,-62,85,-146,81r0,97r-52,0r0,-258r84,0v81,-4,114,15,114,80xm170,-178v-1,-42,-45,-36,-92,-36r0,73v47,0,92,5,92,-37","w":240,"k":{"A":27,".":46,",":46," ":7}},"Q":{"d":"265,-129v0,43,-10,72,-31,96v13,9,26,17,41,22r-19,37v-27,-10,-23,-10,-58,-33v-94,36,-182,-18,-182,-122v0,-82,45,-133,125,-133v78,0,125,52,124,133xm69,-129v0,60,35,102,91,86v-11,-7,-21,-12,-32,-16r15,-29v17,6,33,14,49,26v38,-46,23,-162,-51,-156v-47,4,-72,36,-72,89","w":280},"R":{"d":"237,-185v0,42,-27,66,-68,71v42,23,61,73,89,114r-62,0r-65,-94v-11,-13,-27,-14,-53,-14r0,108r-52,0r0,-258r110,0v68,-3,101,17,101,73xm184,-182v0,-46,-59,-29,-106,-32r0,65v47,-3,106,12,106,-33","w":259,"k":{"Y":13,"W":7,"V":7}},"S":{"d":"184,-142v73,44,30,156,-65,147v-65,-6,-99,-31,-106,-89r51,-5v6,32,21,47,56,50v46,4,72,-50,26,-63v-47,-14,-124,-26,-124,-88v0,-77,119,-89,167,-51v16,14,25,33,26,57r-52,2v-5,-26,-17,-35,-47,-37v-29,-2,-59,20,-36,41v14,13,87,26,104,36","w":240},"T":{"d":"84,0r0,-214r-76,0r0,-44r205,0r0,44r-77,0r0,214r-52,0","w":219,"k":{"y":27,"w":27,"u":27,"s":27,"r":20,"o":27,"i":7,"e":27,"c":27,"a":27,"O":7,"A":27,";":40,":":40,".":40,"-":20,",":40}},"U":{"d":"132,4v-85,0,-106,-36,-106,-124r0,-138r52,0r0,140v-2,56,7,78,52,78v44,0,49,-24,49,-75r0,-143r52,0r0,136v4,90,-19,126,-99,126","w":259},"V":{"d":"92,0r-92,-258r56,0r65,191r64,-191r55,0r-93,258r-55,0","w":240,"k":{"y":13,"u":13,"r":20,"o":27,"i":7,"e":20,"a":20,"A":27,";":20,":":20,".":33,"-":20,",":33}},"W":{"d":"63,0r-62,-258r53,0r39,177r47,-177r62,0r46,180r39,-180r52,0r-62,258r-55,0r-52,-193r-51,193r-56,0","w":339,"k":{"y":7,"u":7,"r":7,"o":7,"i":3,"e":7,"a":13,"A":20,";":7,":":7,".":20,"-":7,",":20}},"X":{"d":"0,0r88,-134r-80,-124r61,0r52,83r50,-83r61,0r-80,125r88,133r-63,0r-57,-89r-58,89r-62,0","w":240},"Y":{"d":"94,0r0,-108r-95,-150r61,0r61,102r60,-102r59,0r-94,150r0,108r-52,0","w":240,"k":{"v":20,"u":20,"q":27,"p":20,"o":27,"i":13,"e":20,"a":20,"A":33,";":27,":":27,".":40,"-":20,",":40," ":7}},"Z":{"d":"4,0r0,-47r135,-167r-120,0r0,-44r189,0r0,41r-141,174r146,0r0,43r-209,0","w":219},"[":{"d":"26,73r0,-331r87,0r0,39r-40,0r0,253r40,0r0,39r-87,0","w":119},"\\":{"d":"-1,-262r37,0r64,266r-37,0","w":100},"]":{"d":"94,-258r0,331r-87,0r0,-39r40,0r0,-253r-40,0r0,-39r87,0","w":119},"^":{"d":"20,-122r66,-140r40,0r64,140r-50,0r-35,-86r-35,86r-50,0","w":210},"_":{"d":"-3,71r0,-32r205,0r0,32r-205,0"},"`":{"d":"87,-210r-31,0r-49,-52r56,0","w":119},"a":{"d":"95,-153v-20,1,-26,7,-32,23r-45,-8v11,-36,33,-54,81,-53v56,2,78,12,78,72v0,43,-5,93,11,119r-49,0r-6,-20v-30,38,-120,31,-120,-31v0,-60,78,-55,116,-71v1,-24,-8,-31,-34,-31xm90,-31v30,-1,43,-21,39,-59v-18,8,-68,8,-67,34v0,14,12,26,28,25"},"b":{"d":"206,-95v11,86,-93,131,-136,68r0,27r-46,0r0,-258r49,0r0,93v49,-57,143,-12,133,70xm114,-153v-27,0,-41,23,-41,56v0,37,14,62,43,62v27,0,39,-24,39,-58v0,-37,-12,-60,-41,-60","w":219},"c":{"d":"15,-93v0,-107,150,-136,174,-38r-49,8v-3,-19,-14,-30,-34,-29v-29,1,-40,20,-40,55v0,66,70,83,77,25r48,9v-10,42,-36,66,-86,67v-56,0,-90,-39,-90,-97"},"d":{"d":"15,-94v-9,-83,83,-128,133,-71r0,-93r49,0r0,258r-46,0r0,-27v-43,63,-147,18,-136,-67xm107,-153v-28,0,-42,23,-42,56v0,39,13,62,42,62v27,0,41,-26,41,-58v0,-36,-12,-60,-41,-60","w":219},"e":{"d":"62,-79v-6,46,63,64,72,20r49,8v-11,34,-38,54,-81,55v-57,1,-91,-38,-91,-96v-1,-56,33,-100,86,-99v61,1,92,43,89,112r-124,0xm137,-109v4,-38,-41,-58,-64,-32v-7,8,-10,19,-10,32r74,0"},"f":{"d":"124,-221v-27,-8,-49,-1,-43,34r37,0r0,39r-37,0r0,148r-49,0r0,-148r-28,0r0,-39r28,0v-11,-69,41,-86,98,-69","w":119,"k":{"\u2019":-7}},"g":{"d":"108,76v-56,1,-87,-16,-87,-64r57,7v2,17,10,18,28,19v42,3,43,-26,41,-68v-45,64,-140,15,-132,-64v-10,-85,90,-131,136,-66r0,-27r46,0r0,168v2,69,-24,94,-89,95xm106,-153v-27,0,-41,23,-41,56v0,34,14,57,40,57v28,0,43,-22,43,-56v0,-34,-14,-57,-42,-57","w":219},"h":{"d":"116,-153v-61,0,-36,94,-41,153r-49,0r0,-258r49,0r0,95v41,-52,121,-31,121,53r0,110r-50,0r0,-99v0,-39,-1,-54,-30,-54","w":219},"i":{"d":"26,-212r0,-46r49,0r0,46r-49,0xm26,0r0,-187r49,0r0,187r-49,0","w":100},"j":{"d":"25,-212r0,-46r49,0r0,46r-49,0xm-8,28v26,5,33,-2,33,-37r0,-178r49,0r0,181v9,72,-31,92,-91,76","w":100},"k":{"d":"24,0r0,-258r49,0r0,137r58,-66r61,0r-64,69r69,118r-54,0r-46,-84r-24,24r0,60r-49,0"},"l":{"d":"26,0r0,-258r49,0r0,258r-49,0","w":100},"m":{"d":"109,-153v-59,0,-31,95,-37,153r-50,0r0,-187r46,0r0,26v26,-39,92,-40,111,0v30,-48,118,-40,118,42r0,119r-50,0r0,-107v0,-33,-3,-46,-26,-46v-57,0,-32,95,-37,153r-49,0r0,-102v-1,-35,0,-51,-26,-51","w":320},"n":{"d":"71,-159v36,-53,125,-40,125,43r0,116r-50,0v-7,-52,23,-153,-30,-153v-61,0,-36,93,-41,153r-50,0r0,-187r46,0r0,28","w":219},"o":{"d":"111,4v-60,-1,-98,-38,-97,-100v1,-55,39,-95,97,-95v55,0,96,42,96,97v0,54,-41,100,-96,98xm111,-151v-29,0,-46,24,-46,58v0,34,17,57,46,57v28,0,45,-25,45,-58v0,-32,-17,-57,-45,-57","w":219},"p":{"d":"207,-94v0,82,-86,130,-133,71r0,94r-50,0r0,-258r46,0r0,28v11,-17,32,-32,59,-32v48,1,78,43,78,97xm115,-152v-27,0,-42,23,-42,55v0,35,14,62,43,62v27,0,40,-23,40,-59v0,-34,-13,-58,-41,-58","w":219},"q":{"d":"16,-95v0,-84,97,-130,136,-64r0,-28r45,0r0,258r-49,0r0,-94v-10,15,-31,27,-55,27v-49,-1,-77,-45,-77,-99xm107,-35v27,0,42,-27,42,-61v0,-34,-13,-56,-41,-56v-29,0,-42,23,-42,59v0,35,13,58,41,58","w":219},"r":{"d":"129,-139v-48,-23,-60,18,-56,81r0,58r-49,0r0,-187r46,0r0,27v14,-31,43,-39,75,-22","w":140,"k":{"\u2019":-13,".":20,",":20}},"s":{"d":"167,-95v38,45,-4,99,-69,99v-49,0,-80,-20,-90,-57r50,-8v5,20,16,27,40,30v32,4,51,-29,15,-37v-64,-14,-92,-14,-98,-66v-7,-59,95,-69,136,-44v12,8,20,20,25,36r-46,9v0,-27,-63,-31,-69,-7v2,24,89,25,106,45"},"t":{"d":"115,-3v-47,18,-87,4,-87,-63r0,-81r-23,0r0,-40r23,0r0,-37r50,-29r0,66r33,0r0,40r-33,0r0,75v-3,35,5,40,33,31","w":119},"u":{"d":"105,-33v61,2,34,-93,40,-154r50,0r0,187r-46,0r0,-28v-29,50,-124,44,-124,-41r0,-118r49,0v7,55,-22,152,31,154","w":219},"v":{"d":"77,0r-75,-187r52,0r45,127r46,-127r51,0r-74,187r-45,0","k":{".":27,",":27}},"w":{"d":"61,0r-59,-187r48,0r35,123r32,-123r47,0r31,123r36,-123r49,0r-60,187r-48,0r-32,-120r-31,120r-48,0","w":280,"k":{".":13,",":13}},"x":{"d":"2,0r67,-96r-64,-91r60,0r33,52r35,-52r58,0r-63,89r69,98r-61,0r-38,-58r-38,58r-58,0"},"y":{"d":"2,-187r53,0r45,133r43,-133r51,0r-77,212v-11,40,-47,59,-98,48r-5,-39v33,9,54,-7,59,-33","k":{".":27,",":27}},"z":{"d":"6,0r0,-38r95,-109v-26,2,-60,1,-88,1r0,-41r154,0r0,35r-96,110r102,-1r0,43r-167,0","w":180},"{":{"d":"49,-3v0,-48,0,-64,-38,-69r0,-42v35,-2,40,-23,38,-63v-3,-69,17,-86,82,-85r0,42v-74,-12,-5,97,-69,127v31,9,33,64,33,101v0,24,9,25,36,26r0,42v-61,2,-82,-16,-82,-79","w":140},"|":{"d":"31,76r0,-338r39,0r0,338r-39,0","w":100},"}":{"d":"90,-183v-2,47,1,65,38,69r0,42v-35,2,-40,22,-38,62v3,70,-16,87,-82,86r0,-42v27,0,36,-2,36,-25v0,-37,1,-94,33,-102v-32,-24,-31,-39,-33,-100v-1,-26,-7,-27,-36,-27r0,-42v61,-2,84,15,82,79","w":140},"~":{"d":"146,-92v-27,0,-63,-25,-86,-24v-16,0,-32,9,-48,25r0,-46v35,-46,97,-12,138,0v19,-1,36,-11,48,-25r0,47v-9,11,-32,23,-52,23","w":210},"\u00c4":{"d":"67,-272r0,-43r43,0r0,43r-43,0xm143,-272r0,-43r42,0r0,43r-42,0xm259,0r-57,0r-23,-59r-103,0r-21,59r-55,0r100,-258r55,0xm163,-102r-36,-96r-35,96r71,0","w":259},"\u00c5":{"d":"127,-309v18,0,35,15,35,34v0,18,-17,35,-35,35v-18,0,-34,-17,-34,-35v0,-17,17,-34,34,-34xm127,-259v9,1,17,-7,16,-16v1,-9,-7,-15,-16,-15v-8,0,-15,7,-15,15v0,9,6,17,15,16xm259,0r-57,0r-23,-59r-103,0r-21,59r-55,0r100,-258r55,0xm163,-102r-36,-96r-35,96r71,0","w":259},"\u00d6":{"d":"79,-272r0,-43r42,0r0,43r-42,0xm154,-272r0,-43r43,0r0,43r-43,0xm141,4v-76,0,-126,-52,-125,-131v1,-85,41,-133,124,-135v78,-1,126,54,126,134v0,81,-48,132,-125,132xm141,-218v-48,0,-72,36,-72,89v0,53,25,89,72,89v48,0,71,-37,71,-90v0,-53,-24,-88,-71,-88","w":280},"\u00dc":{"d":"70,-272r0,-43r42,0r0,43r-42,0xm146,-272r0,-43r42,0r0,43r-42,0xm132,4v-85,0,-106,-36,-106,-124r0,-138r52,0r0,140v-2,56,7,78,52,78v44,0,49,-24,49,-75r0,-143r52,0r0,136v4,90,-19,126,-99,126","w":259},"\u00e1":{"d":"75,-210r25,-52r55,0r-48,52r-32,0xm95,-153v-20,1,-26,7,-32,23r-45,-8v11,-36,33,-54,81,-53v56,2,78,12,78,72v0,43,-5,93,11,119r-49,0r-6,-20v-30,38,-120,31,-120,-31v0,-60,78,-55,116,-71v1,-24,-8,-31,-34,-31xm90,-31v30,-1,43,-21,39,-59v-18,8,-68,8,-67,34v0,14,12,26,28,25"},"\u00e0":{"d":"95,-153v-20,1,-26,7,-32,23r-45,-8v11,-36,33,-54,81,-53v56,2,78,12,78,72v0,43,-5,93,11,119r-49,0r-6,-20v-30,38,-120,31,-120,-31v0,-60,78,-55,116,-71v1,-24,-8,-31,-34,-31xm90,-31v30,-1,43,-21,39,-59v-18,8,-68,8,-67,34v0,14,12,26,28,25xm125,-210r-31,0r-49,-52r56,0"},"\u00e2":{"d":"41,-210r37,-52r46,0r36,52r-40,0r-20,-26r-19,26r-40,0xm95,-153v-20,1,-26,7,-32,23r-45,-8v11,-36,33,-54,81,-53v56,2,78,12,78,72v0,43,-5,93,11,119r-49,0r-6,-20v-30,38,-120,31,-120,-31v0,-60,78,-55,116,-71v1,-24,-8,-31,-34,-31xm90,-31v30,-1,43,-21,39,-59v-18,8,-68,8,-67,34v0,14,12,26,28,25"},"\u00e4":{"d":"41,-220r0,-42r43,0r0,42r-43,0xm117,-220r0,-42r43,0r0,42r-43,0xm95,-153v-20,1,-26,7,-32,23r-45,-8v11,-36,33,-54,81,-53v56,2,78,12,78,72v0,43,-5,93,11,119r-49,0r-6,-20v-30,38,-120,31,-120,-31v0,-60,78,-55,116,-71v1,-24,-8,-31,-34,-31xm90,-31v30,-1,43,-21,39,-59v-18,8,-68,8,-67,34v0,14,12,26,28,25"},"\u00e3":{"d":"130,-213v-26,2,-62,-33,-68,1r-22,0v-2,-25,9,-44,32,-44v23,0,60,35,67,-1r22,0v0,27,-9,42,-31,44xm95,-153v-20,1,-26,7,-32,23r-45,-8v11,-36,33,-54,81,-53v56,2,78,12,78,72v0,43,-5,93,11,119r-49,0r-6,-20v-30,38,-120,31,-120,-31v0,-60,78,-55,116,-71v1,-24,-8,-31,-34,-31xm90,-31v30,-1,43,-21,39,-59v-18,8,-68,8,-67,34v0,14,12,26,28,25"},"\u00e5":{"d":"100,-270v18,0,35,15,35,34v0,18,-18,35,-35,35v-17,0,-34,-17,-34,-35v0,-17,17,-34,34,-34xm100,-220v8,0,16,-8,16,-16v0,-8,-8,-16,-16,-16v-8,0,-15,8,-15,16v0,8,7,16,15,16xm95,-153v-20,1,-26,7,-32,23r-45,-8v11,-36,33,-54,81,-53v56,2,78,12,78,72v0,43,-5,93,11,119r-49,0r-6,-20v-30,38,-120,31,-120,-31v0,-60,78,-55,116,-71v1,-24,-8,-31,-34,-31xm90,-31v30,-1,43,-21,39,-59v-18,8,-68,8,-67,34v0,14,12,26,28,25"},"\u00e7":{"d":"151,35v0,39,-58,43,-95,36r0,-21v25,2,57,7,62,-14v-1,-18,-29,-17,-46,-12r5,-17v29,-11,74,-4,74,28xm15,-93v0,-107,150,-136,174,-38r-49,8v-3,-19,-14,-30,-34,-29v-29,1,-40,20,-40,55v0,66,70,83,77,25r48,9v-10,42,-36,66,-86,67v-56,0,-90,-39,-90,-97"},"\u00e9":{"d":"74,-210r24,-52r55,0r-48,52r-31,0xm62,-79v-6,46,63,64,72,20r49,8v-11,34,-38,54,-81,55v-57,1,-91,-38,-91,-96v-1,-56,33,-100,86,-99v61,1,92,43,89,112r-124,0xm137,-109v4,-38,-41,-58,-64,-32v-7,8,-10,19,-10,32r74,0"},"\u00e8":{"d":"62,-79v-6,46,63,64,72,20r49,8v-11,34,-38,54,-81,55v-57,1,-91,-38,-91,-96v-1,-56,33,-100,86,-99v61,1,92,43,89,112r-124,0xm137,-109v4,-38,-41,-58,-64,-32v-7,8,-10,19,-10,32r74,0xm124,-210r-31,0r-49,-52r56,0"},"\u00ea":{"d":"39,-210r37,-52r46,0r36,52r-40,0r-20,-26r-19,26r-40,0xm62,-79v-6,46,63,64,72,20r49,8v-11,34,-38,54,-81,55v-57,1,-91,-38,-91,-96v-1,-56,33,-100,86,-99v61,1,92,43,89,112r-124,0xm137,-109v4,-38,-41,-58,-64,-32v-7,8,-10,19,-10,32r74,0"},"\u00ed":{"d":"26,0r0,-187r49,0r0,187r-49,0xm22,-210r24,-52r56,0r-49,52r-31,0","w":100},"\u00ec":{"d":"26,0r0,-187r49,0r0,187r-49,0xm76,-210r-31,0r-49,-52r56,0","w":100},"\u00ee":{"d":"-9,-210r37,-52r46,0r36,52r-40,0r-20,-26r-19,26r-40,0xm26,0r0,-187r49,0r0,187r-49,0","w":100},"\u00ef":{"d":"26,0r0,-187r49,0r0,187r-49,0xm-8,-220r0,-42r42,0r0,42r-42,0xm67,-220r0,-42r43,0r0,42r-43,0","w":100},"\u00f1":{"d":"140,-213v-26,2,-62,-33,-68,1r-22,0v-2,-25,9,-44,32,-44v23,0,60,35,67,-1r22,0v1,28,-9,43,-31,44xm71,-159v36,-53,125,-40,125,43r0,116r-50,0v-7,-52,23,-153,-30,-153v-61,0,-36,93,-41,153r-50,0r0,-187r46,0r0,28","w":219},"\u00f3":{"d":"86,-210r24,-52r55,0r-48,52r-31,0xm111,4v-60,-1,-98,-38,-97,-100v1,-55,39,-95,97,-95v55,0,96,42,96,97v0,54,-41,100,-96,98xm111,-151v-29,0,-46,24,-46,58v0,34,17,57,46,57v28,0,45,-25,45,-58v0,-32,-17,-57,-45,-57","w":219},"\u00f2":{"d":"111,4v-60,-1,-98,-38,-97,-100v1,-55,39,-95,97,-95v55,0,96,42,96,97v0,54,-41,100,-96,98xm111,-151v-29,0,-46,24,-46,58v0,34,17,57,46,57v28,0,45,-25,45,-58v0,-32,-17,-57,-45,-57xm136,-210r-31,0r-49,-52r56,0","w":219},"\u00f4":{"d":"51,-210r37,-52r46,0r36,52r-40,0r-20,-26r-19,26r-40,0xm111,4v-60,-1,-98,-38,-97,-100v1,-55,39,-95,97,-95v55,0,96,42,96,97v0,54,-41,100,-96,98xm111,-151v-29,0,-46,24,-46,58v0,34,17,57,46,57v28,0,45,-25,45,-58v0,-32,-17,-57,-45,-57","w":219},"\u00f6":{"d":"50,-220r0,-42r42,0r0,42r-42,0xm125,-220r0,-42r43,0r0,42r-43,0xm111,4v-60,-1,-98,-38,-97,-100v1,-55,39,-95,97,-95v55,0,96,42,96,97v0,54,-41,100,-96,98xm111,-151v-29,0,-46,24,-46,58v0,34,17,57,46,57v28,0,45,-25,45,-58v0,-32,-17,-57,-45,-57","w":219},"\u00f5":{"d":"140,-213v-26,2,-62,-34,-67,1r-23,0v-2,-25,9,-44,32,-44v24,0,60,35,67,-1r23,0v1,27,-10,42,-32,44xm111,4v-60,-1,-98,-38,-97,-100v1,-55,39,-95,97,-95v55,0,96,42,96,97v0,54,-41,100,-96,98xm111,-151v-29,0,-46,24,-46,58v0,34,17,57,46,57v28,0,45,-25,45,-58v0,-32,-17,-57,-45,-57","w":219},"\u00fa":{"d":"85,-210r24,-52r55,0r-48,52r-31,0xm105,-33v61,2,34,-93,40,-154r50,0r0,187r-46,0r0,-28v-29,50,-124,44,-124,-41r0,-118r49,0v7,55,-22,152,31,154","w":219},"\u00f9":{"d":"105,-33v61,2,34,-93,40,-154r50,0r0,187r-46,0r0,-28v-29,50,-124,44,-124,-41r0,-118r49,0v7,55,-22,152,31,154xm135,-210r-31,0r-49,-52r56,0","w":219},"\u00fb":{"d":"50,-210r37,-52r46,0r36,52r-39,0r-21,-26r-19,26r-40,0xm105,-33v61,2,34,-93,40,-154r50,0r0,187r-46,0r0,-28v-29,50,-124,44,-124,-41r0,-118r49,0v7,55,-22,152,31,154","w":219},"\u00fc":{"d":"51,-220r0,-42r42,0r0,42r-42,0xm126,-220r0,-42r43,0r0,42r-43,0xm105,-33v61,2,34,-93,40,-154r50,0r0,187r-46,0r0,-28v-29,50,-124,44,-124,-41r0,-118r49,0v7,55,-22,152,31,154","w":219},"\u00a3":{"d":"195,-8v-52,36,-127,-29,-174,12r-19,-42v23,-16,41,-37,37,-71r-37,0r0,-39r28,0v-23,-61,12,-114,75,-114v47,0,75,26,80,68r-48,7v1,-45,-66,-46,-67,-3v0,12,6,31,9,42r55,0r0,39r-47,0v3,32,-9,42,-26,64v39,-17,78,22,115,-5"},"\u00df":{"d":"101,-223v-28,3,-26,19,-27,56r0,167r-50,0r0,-167v-1,-63,18,-94,77,-95v42,-1,70,18,72,53v1,19,-21,46,-22,61v6,32,56,50,56,92v0,64,-95,80,-119,27r34,-20v6,18,36,18,36,-4v0,-21,-10,-19,-30,-39v-20,-19,-29,-34,-29,-45v0,-16,23,-50,23,-68v0,-10,-10,-19,-21,-18","w":219},"\u2122":{"d":"82,-114r0,-119r-44,0r0,-25r117,0r0,25r-43,0r0,119r-30,0xm172,-114r0,-144r46,0r26,99r26,-99r46,0r0,144r-28,0r0,-115r-31,115r-26,0r-31,-115r0,115r-28,0","w":360},"\u00e6":{"d":"21,-138v6,-56,100,-67,142,-36v40,-34,116,-11,129,30v5,16,11,37,11,65r-124,0v-3,49,62,62,73,19r49,9v-12,58,-110,72,-149,30v-33,34,-141,39,-137,-30v2,-60,63,-54,115,-70v1,-23,-8,-32,-30,-32v-18,0,-31,7,-34,23xm254,-110v5,-44,-52,-57,-69,-24v-4,9,-5,16,-5,24r74,0xm65,-55v1,34,58,28,63,1v2,-6,2,-18,2,-35v-45,15,-53,4,-65,34","w":320},"\u00f8":{"d":"38,-27v-50,-58,-12,-164,73,-164v21,0,39,5,55,15r19,-21r19,16r-19,22v51,57,10,163,-74,163v-20,0,-38,-5,-54,-15r-20,24r-19,-17xm139,-144v-46,-32,-93,26,-70,80xm85,-43v45,32,92,-25,69,-79","w":219},"\u00bf":{"d":"134,-187r0,50r-49,0r0,-50r49,0xm203,-2v-2,101,-185,98,-185,2v0,-48,47,-60,68,-91v3,-5,3,-15,3,-29r45,0v13,70,-68,74,-68,122v0,20,20,35,43,34v30,-1,43,-17,49,-43","w":219},"\u00ab":{"d":"111,-173r-45,79r45,82r-39,0r-55,-82r55,-79r39,0xm180,-173r-45,79r45,82r-39,0r-55,-82r55,-79r39,0"},"\u00bb":{"d":"88,-12r45,-80r-45,-81r38,0r56,81r-56,80r-38,0xm19,-12r45,-80r-45,-81r38,0r56,81r-56,80r-38,0"},"\u2026":{"d":"275,0r0,-49r50,0r0,49r-50,0xm155,0r0,-49r50,0r0,49r-50,0xm35,0r0,-49r50,0r0,49r-50,0","w":360},"\u2013":{"d":"-1,-75r0,-37r201,0r0,37r-201,0"},"\u2014":{"d":"0,-75r0,-37r360,0r0,37r-360,0","w":360},"\u201c":{"d":"73,-153r-50,0v-2,-53,1,-96,44,-107r10,20v-18,6,-28,15,-28,37r24,0r0,50xm155,-153r-49,0v-3,-52,-1,-97,43,-107r10,20v-18,6,-27,16,-28,37r24,0r0,50","w":180},"\u201d":{"d":"105,-258r50,0v3,53,-1,97,-44,107r-10,-20v18,-6,28,-15,28,-37r-24,0r0,-50xm22,-258r50,0v2,53,0,97,-44,107r-10,-20v18,-6,28,-15,28,-37r-24,0r0,-50","w":180},"\u2018":{"d":"76,-153r-49,0v-2,-52,-1,-97,43,-107r10,20v-18,6,-27,16,-28,37r24,0r0,50","w":100,"k":{"\u2018":13}},"\u2019":{"d":"25,-257r49,0v2,53,-1,95,-44,106r-9,-20v19,-5,27,-15,28,-37r-24,0r0,-49","w":100,"k":{"\u2019":13,"s":13," ":20}},"\u00ff":{"d":"40,-220r0,-42r43,0r0,42r-43,0xm116,-220r0,-42r43,0r0,42r-43,0xm2,-187r53,0r45,133r43,-133r51,0r-77,212v-11,40,-47,59,-98,48r-5,-39v33,9,54,-7,59,-33"},"\u20ac":{"d":"21,-168v9,-72,94,-116,168,-83r-10,48v-34,-32,-102,-7,-105,35r97,0r-6,27r-94,0r0,23r89,0r-5,28r-80,0v6,54,80,65,113,29r0,54v-74,33,-158,-12,-168,-83r-26,0r6,-28r17,0r0,-23r-23,0r6,-27r21,0"},"\u0142":{"d":"26,-127r0,-131r49,0r0,89r24,-20r0,33r-24,21r0,135r-49,0r0,-93r-24,20r0,-33","w":100},"\u00d7":{"d":"20,-74r53,-53r-54,-53r33,-33r53,53r53,-53r32,32r-53,53r54,54r-33,33r-54,-54r-53,53","w":210},"\u0107":{"d":"76,-210r24,-52r56,0r-49,52r-31,0xm15,-93v0,-107,150,-136,174,-38r-49,8v-3,-19,-14,-30,-34,-29v-29,1,-40,20,-40,55v0,66,70,83,77,25r48,9v-10,42,-36,66,-86,67v-56,0,-90,-39,-90,-97"},"\u0105":{"d":"213,68v-33,17,-80,8,-79,-33v0,-10,3,-24,7,-40r26,0v-6,21,-6,57,22,54v7,0,15,-2,24,-5r0,24xm95,-153v-20,1,-26,7,-32,23r-45,-8v11,-36,33,-54,81,-53v56,2,78,12,78,72v0,43,-5,93,11,119r-49,0r-6,-20v-30,38,-120,31,-120,-31v0,-60,78,-55,116,-71v1,-24,-8,-31,-34,-31xm90,-31v30,-1,43,-21,39,-59v-18,8,-68,8,-67,34v0,14,12,26,28,25"},"\u0119":{"d":"160,68v-33,16,-80,8,-78,-33v0,-10,2,-24,6,-40r26,0v-6,21,-6,57,22,54v7,0,15,-2,24,-5r0,24xm62,-79v-6,46,63,64,72,20r49,8v-11,34,-38,54,-81,55v-57,1,-91,-38,-91,-96v-1,-56,33,-100,86,-99v61,1,92,43,89,112r-124,0xm137,-109v4,-38,-41,-58,-64,-32v-7,8,-10,19,-10,32r74,0"},"\u0151":{"d":"50,-210r25,-53r51,0r-45,53r-31,0xm116,-210r25,-53r50,0r-43,53r-32,0xm111,4v-60,-1,-98,-38,-97,-100v1,-55,39,-95,97,-95v55,0,96,42,96,97v0,54,-41,100,-96,98xm111,-151v-29,0,-46,24,-46,58v0,34,17,57,46,57v28,0,45,-25,45,-58v0,-32,-17,-57,-45,-57","w":219},"\u015b":{"d":"80,-210r24,-52r55,0r-48,52r-31,0xm167,-95v38,45,-4,99,-69,99v-49,0,-80,-20,-90,-57r50,-8v5,20,16,27,40,30v32,4,51,-29,15,-37v-64,-14,-92,-14,-98,-66v-7,-59,95,-69,136,-44v12,8,20,20,25,36r-46,9v0,-27,-63,-31,-69,-7v2,24,89,25,106,45"},"\u0171":{"d":"56,-210r25,-53r51,0r-45,53r-31,0xm122,-210r25,-53r50,0r-43,53r-32,0xm105,-33v61,2,34,-93,40,-154r50,0r0,187r-46,0r0,-28v-29,50,-124,44,-124,-41r0,-118r49,0v7,55,-22,152,31,154","w":219},"\u017a":{"d":"56,-210r24,-52r56,0r-49,52r-31,0xm6,0r0,-38r95,-109v-26,2,-60,1,-88,1r0,-41r154,0r0,35r-96,110r102,-1r0,43r-167,0","w":180},"\u017c":{"d":"63,-215r0,-47r49,0r0,47r-49,0xm6,0r0,-38r95,-109v-26,2,-60,1,-88,1r0,-41r154,0r0,35r-96,110r102,-1r0,43r-167,0","w":180},"\u2032":{"d":"25,-166v-1,-35,3,-65,10,-92r54,0v-6,34,-16,64,-28,92r-36,0","w":86},"\u2033":{"d":"25,-166v-1,-35,3,-65,10,-92r54,0v-6,34,-16,64,-28,92r-36,0xm104,-166v-1,-35,3,-65,10,-92r54,0v-6,34,-16,64,-28,92r-36,0","w":172}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 *  2008 The Monotype Corporation. All Rights Reserved.
 * 
 * Trademark:
 * Arial is a trademark of The Monotype Corporation in the United States and/or
 * other countries.
 * 
 * Manufacturer:
 * The Monotype Corporation
 * 
 * Designer:
 * Monotype Type Drawing Office - Robin Nicholas, Patricia Saunders 1982
 */
Cufon.registerFont({"w":200,"face":{"font-family":"Arial","font-weight":400,"font-style":"italic","font-stretch":"normal","units-per-em":"360","panose-1":"2 11 6 4 2 2 2 9 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-44 -311 382 77.1171","underline-thickness":"26.3672","underline-position":"-24.9609","slope":"-12","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":100,"k":{"Y":7,"A":13}},"\u00a0":{"w":100},"!":{"d":"40,-65r20,-140r11,-53r38,0v-13,68,-32,129,-49,193r-20,0xm20,0r8,-36r36,0r-8,36r-36,0","w":100},"\"":{"d":"49,-166v0,-34,4,-65,11,-92r36,0v-6,34,-16,64,-28,92r-19,0xm107,-166v0,-34,4,-65,11,-92r36,0v-6,34,-16,64,-28,92r-19,0","w":127},"#":{"d":"31,4r15,-74r-29,0r0,-27r35,0r13,-63r-48,0r0,-27r53,0r15,-75r27,0r-16,75r56,0r15,-75r27,0r-16,75r31,0r0,27r-36,0r-13,63r49,0r0,27r-54,0r-16,74r-26,0r15,-74r-55,0r-16,74r-26,0xm78,-97r55,0r13,-63r-55,0"},"$":{"d":"190,-74v0,48,-40,83,-93,78r-6,30r-18,0r7,-32v-34,-7,-60,-38,-62,-77r32,-1v2,26,14,45,35,52r21,-97v-33,-15,-57,-30,-57,-70v0,-41,39,-74,86,-70r3,-14r17,0r-3,16v32,9,49,29,54,64r-30,1v-4,-20,-12,-33,-30,-39r-18,89v38,17,62,29,62,70xm130,-236v-38,-4,-63,35,-43,66v4,6,13,13,25,19xm102,-21v38,4,71,-39,49,-74v-5,-7,-14,-13,-29,-19"},"%":{"d":"50,9r213,-271r29,0r-212,271r-30,0xm82,-124v-32,0,-49,-19,-47,-54v2,-42,20,-82,64,-82v34,0,51,17,51,50v0,42,-21,87,-68,86xm100,-239v-26,0,-37,39,-38,66v-1,17,6,26,20,27v31,1,38,-40,40,-68v1,-15,-9,-25,-22,-25xm307,-77v0,42,-20,88,-68,86v-32,-1,-49,-19,-47,-54v3,-41,19,-81,65,-81v33,1,50,17,50,49xm258,-105v-28,0,-37,39,-39,66v0,17,7,26,21,27v29,1,38,-40,39,-68v0,-15,-8,-25,-21,-25","w":320},"&":{"d":"202,-213v0,40,-27,50,-64,71v15,28,30,51,44,69v9,-10,17,-23,25,-37r27,14v-8,16,-18,32,-32,48v8,10,18,21,30,35r-24,19v-12,-10,-21,-20,-29,-31v-26,20,-37,29,-73,31v-44,2,-78,-31,-78,-73v0,-50,29,-66,68,-85v-31,-47,-5,-109,51,-110v31,-1,55,21,55,49xm147,-237v-33,0,-41,43,-21,71v24,-14,42,-21,45,-46v2,-13,-12,-25,-24,-25xm61,-71v0,53,69,64,99,21v-22,-29,-39,-54,-51,-77v-28,14,-48,25,-48,56","w":240},"'":{"d":"46,-166v0,-34,4,-65,11,-92r36,0v-6,34,-16,64,-28,92r-19,0","w":68},"(":{"d":"149,-262v-67,69,-116,211,-67,338r-24,0v-18,-40,-28,-82,-28,-125v0,-102,40,-150,94,-213r25,0","w":119},")":{"d":"-19,76v66,-70,117,-211,67,-338r23,0v19,40,28,82,28,124v0,103,-39,151,-93,214r-25,0","w":119},"*":{"d":"41,-210r9,-25v19,7,32,12,40,17v-2,-21,-3,-36,-3,-44r25,0v0,12,-2,27,-4,44v12,-6,26,-12,42,-17r8,25v-15,5,-30,7,-44,9v7,6,17,18,30,34r-21,15v-7,-9,-15,-22,-24,-38v-9,17,-16,29,-23,38r-21,-15v14,-17,24,-29,30,-34v-15,-3,-30,-5,-44,-9","w":140},"+":{"d":"102,-42r0,-70r-70,0r0,-30r70,0r0,-70r30,0r0,70r70,0r0,30r-70,0r0,70r-30,0","w":210},",":{"d":"20,0r7,-36r36,0v-7,40,-15,84,-54,88r3,-14v14,-4,23,-16,27,-38r-19,0","w":100},"-":{"d":"17,-77r6,-32r97,0r-6,32r-97,0","w":119},"\u00ad":{"d":"17,-77r6,-32r97,0r-6,32r-97,0","w":119},".":{"d":"21,0r7,-36r36,0r-7,36r-36,0","w":100},"\/":{"d":"-18,4r138,-266r28,0r-139,266r-27,0","w":100},"0":{"d":"94,4v-44,0,-72,-38,-69,-89v5,-84,29,-174,109,-174v45,0,72,36,70,86v-4,82,-29,177,-110,177xm135,-233v-63,0,-73,96,-79,157v-3,32,12,55,40,55v60,0,73,-102,77,-160v2,-33,-10,-52,-38,-52"},"1":{"d":"87,0r40,-195v-18,14,-42,26,-74,34r6,-29v36,-16,76,-38,95,-69r19,0r-54,259r-32,0","k":{"1":27}},"2":{"d":"202,-190v1,75,-103,101,-136,161r115,0r-6,29r-154,0v13,-85,110,-104,146,-171v16,-30,-9,-63,-40,-62v-31,2,-44,22,-51,53r-31,-5v5,-43,36,-74,82,-74v44,0,73,27,75,69"},"3":{"d":"158,-132v65,36,13,136,-58,136v-47,0,-77,-29,-80,-72r31,-3v3,32,17,49,47,50v30,0,57,-26,58,-55v0,-30,-24,-47,-58,-44r6,-26v35,5,65,-15,65,-45v1,-23,-19,-43,-42,-42v-26,1,-44,21,-48,47r-31,-6v8,-38,39,-66,82,-67v40,-1,71,29,71,67v-1,32,-19,48,-43,60"},"4":{"d":"108,0r13,-66r-105,0r7,-31r144,-161r26,0r-34,164r36,0r-6,28r-36,0r-14,66r-31,0xm127,-94r23,-107r-96,107r73,0"},"5":{"d":"98,4v-46,0,-74,-31,-73,-78r32,-3v-1,31,14,56,43,56v39,0,63,-39,65,-78v3,-55,-75,-60,-96,-21r-28,-2r39,-132r126,0r-6,29r-98,0r-19,66v43,-36,118,-7,113,57v-4,60,-38,106,-98,106"},"6":{"d":"175,-192v-1,-38,-36,-51,-64,-29v-18,13,-32,49,-39,72v40,-43,121,-20,121,51v0,51,-36,102,-88,102v-47,0,-78,-38,-75,-90v5,-80,30,-173,112,-173v38,0,59,27,62,64xm119,-146v-60,-3,-84,119,-14,125v60,1,84,-122,14,-125"},"7":{"d":"52,0v18,-86,66,-172,120,-225r-128,0r6,-29r164,0r-6,29v-56,46,-105,146,-123,225r-33,0"},"8":{"d":"27,-66v0,-39,23,-67,54,-76v-58,-30,-16,-117,49,-117v42,0,73,24,73,63v-1,31,-17,48,-43,58v64,37,16,143,-59,143v-42,0,-74,-29,-74,-71xm133,-233v-28,1,-49,18,-49,46v-1,23,17,37,40,37v54,0,69,-85,9,-83xm116,-127v-33,0,-59,28,-57,64v0,26,19,40,45,42v54,4,81,-107,12,-106"},"9":{"d":"198,-168v-4,83,-31,169,-111,172v-38,1,-61,-25,-63,-63r30,-3v1,41,44,52,69,24v14,-16,26,-38,33,-67v-42,44,-120,17,-120,-52v0,-51,36,-103,88,-102v46,1,76,39,74,91xm124,-233v-63,-2,-80,121,-14,125v61,2,84,-120,14,-125"},":":{"d":"52,-151r8,-36r35,0r-7,36r-36,0xm21,0r7,-36r36,0r-8,36r-35,0","w":100},";":{"d":"51,-151r8,-36r35,0r-7,36r-36,0xm20,0r7,-36r36,0v-7,40,-15,84,-54,88r3,-14v14,-4,23,-16,27,-38r-19,0","w":100},"\u037e":{"d":"51,-151r8,-36r35,0r-7,36r-36,0xm20,0r7,-36r36,0v-7,40,-15,84,-54,88r3,-14v14,-4,23,-16,27,-38r-19,0","w":100},"<":{"d":"32,-113r0,-29r171,-72r0,31r-135,56r135,56r0,31","w":210},"=":{"d":"202,-152r-170,0r0,-29r170,0r0,29xm202,-73r-170,0r0,-30r170,0r0,30","w":210},">":{"d":"203,-113r-171,73r0,-31r136,-56r-136,-56r0,-31r171,72r0,29","w":210},"?":{"d":"202,-199v1,62,-89,74,-97,134r-30,0v1,-66,88,-76,95,-136v3,-20,-20,-37,-42,-36v-31,2,-46,20,-50,55r-32,-5v9,-45,34,-75,82,-75v40,0,73,24,74,63xm60,0r7,-36r36,0r-7,36r-36,0"},"@":{"d":"238,1v-22,0,-33,-7,-34,-30v-13,16,-30,30,-54,30v-108,0,-62,-192,28,-192v25,0,42,14,53,33r6,-27r31,0r-30,145v0,7,5,11,12,11v38,-8,68,-51,68,-97v0,-70,-56,-111,-126,-111v-89,0,-145,64,-146,152v-1,91,61,134,151,135v57,0,101,-22,124,-53r31,0v-26,46,-78,80,-155,79v-107,-1,-177,-53,-177,-158v0,-107,64,-180,174,-180v88,0,146,52,150,137v3,58,-51,127,-106,126xm180,-164v-61,-1,-88,129,-23,139v41,-6,61,-45,64,-89v1,-28,-16,-50,-41,-50","w":365},"A":{"d":"-7,0r146,-258r40,0r43,258r-33,0r-13,-74r-104,0r-41,74r-38,0xm87,-101r85,0r-17,-129v-17,41,-47,89,-68,129","w":240,"k":{"\u2019":13,"y":3,"w":7,"v":7,"Y":27,"W":7,"V":20,"T":27," ":13}},"B":{"d":"230,-82v0,49,-39,82,-90,82r-124,0r54,-258v76,1,166,-13,166,61v-1,33,-20,53,-48,63v25,8,42,23,42,52xm204,-194v0,-46,-60,-32,-106,-34r-17,80v56,0,123,7,123,-46xm195,-81v1,-51,-71,-34,-120,-37r-19,89v0,0,137,9,139,-52","w":240},"C":{"d":"137,-24v43,0,69,-31,80,-67r34,5v-18,52,-55,89,-116,90v-65,1,-102,-41,-102,-110v0,-108,111,-201,201,-134v18,14,26,34,29,59r-32,3v-5,-35,-25,-55,-62,-56v-62,-2,-102,62,-102,128v0,49,25,82,70,82","w":259},"D":{"d":"147,-258v121,-16,131,138,75,207v-27,33,-55,51,-113,51r-93,0r54,-258r77,0xm221,-154v2,-73,-49,-78,-123,-74r-41,199v106,9,161,-30,164,-125","w":259},"E":{"d":"16,0r54,-258r186,0r-6,30r-152,0r-16,80r147,0r-6,29r-148,0r-18,90r162,0r-6,29r-197,0","w":240},"F":{"d":"16,0r54,-258r168,0r-6,30r-134,0r-17,82r136,0r-6,29r-136,0r-24,117r-35,0","w":219,"k":{"A":27,".":46,",":46," ":7}},"G":{"d":"70,-103v-3,84,84,97,144,57r12,-56r-79,0r7,-29r112,0r-21,105v-25,16,-63,30,-103,30v-67,0,-107,-41,-107,-107v0,-107,85,-189,191,-149v31,12,43,34,50,70r-34,3v-8,-34,-28,-54,-67,-54v-69,0,-103,57,-105,130","w":280},"H":{"d":"15,0r54,-258r34,0r-22,107r134,0r22,-107r34,0r-53,258r-35,0r25,-121r-133,0r-25,121r-35,0","w":259},"I":{"d":"21,0r54,-258r34,0r-54,258r-34,0","w":100},"J":{"d":"126,-13v-43,38,-139,12,-111,-62r32,-2v-21,49,44,72,65,32v18,-66,31,-144,47,-213r34,0r-39,189v-6,26,-15,45,-28,56","w":180},"K":{"d":"16,0r54,-258r34,0r-26,124r140,-124r49,0r-120,105r88,153r-39,0r-74,-131r-54,47r-18,84r-34,0","w":240},"L":{"d":"14,0r54,-258r35,0r-48,229r134,0r-6,29r-169,0","k":{"\u2019":20,"y":7,"Y":33,"W":13,"V":20,"T":27," ":7}},"M":{"d":"16,0r54,-258r42,0r26,167v3,22,6,43,7,63v33,-70,88,-159,126,-230r43,0r-54,258r-34,0r27,-125v6,-29,15,-62,27,-98v-36,76,-84,150,-124,223r-33,0r-26,-165v-2,-15,-4,-33,-5,-53v-10,83,-28,142,-43,218r-33,0","w":299},"N":{"d":"18,0r54,-258r33,0v30,75,66,137,90,219r44,-219r33,0r-53,258r-34,0r-91,-218v-10,72,-29,148,-43,218r-33,0","w":259},"O":{"d":"141,4v-67,2,-107,-47,-108,-112v-3,-85,58,-153,136,-154v65,-1,111,48,109,115v-3,86,-51,149,-137,151xm169,-233v-59,1,-104,59,-102,127v1,48,30,82,76,82v66,0,98,-58,101,-125v2,-48,-30,-84,-75,-84","w":280},"P":{"d":"251,-194v-3,87,-85,94,-179,89r-22,105r-35,0r54,-258v80,3,185,-20,182,64xm217,-194v1,-52,-70,-32,-119,-36r-20,96v70,2,138,4,139,-60","w":240,"k":{"A":27,".":46,",":46," ":13}},"Q":{"d":"278,-147v-1,56,-26,101,-60,126v9,10,20,20,35,30r-16,21v-16,-10,-30,-23,-42,-38v-80,38,-166,-14,-162,-104v4,-85,50,-148,137,-150v65,-1,109,48,108,115xm153,-75v20,8,27,17,44,32v26,-20,47,-62,47,-106v0,-48,-30,-84,-74,-84v-64,0,-101,57,-103,123v-2,58,49,102,107,80v-11,-10,-22,-17,-33,-23","w":280},"R":{"d":"263,-195v-2,50,-35,73,-87,79v36,28,48,72,67,116r-39,0v-23,-45,-21,-115,-89,-114r-40,0r-24,114r-34,0r54,-258v81,4,195,-23,192,63xm230,-195v2,-54,-81,-28,-131,-34r-18,87v71,0,147,10,149,-53","w":259,"k":{"Y":13,"W":7,"V":7,"T":7}},"S":{"d":"195,-124v63,46,9,135,-70,128v-60,-5,-101,-23,-100,-87r34,-3v-3,44,25,62,67,62v43,0,82,-34,55,-67v-26,-32,-128,-39,-124,-102v2,-47,39,-69,90,-69v56,0,94,26,95,77r-34,3v0,-38,-25,-47,-62,-51v-49,-5,-77,49,-33,70v8,5,71,31,82,39","w":240},"T":{"d":"82,0r47,-228r-84,0r6,-30r203,0r-6,30r-84,0r-48,228r-34,0","w":219,"k":{"y":27,"w":27,"u":27,"s":33,"r":27,"o":33,"i":3,"e":33,"c":33,"a":33,"O":7,"A":27,";":27,":":27,".":33,"-":33,",":33}},"U":{"d":"219,-45v-31,68,-189,70,-184,-25v3,-58,26,-130,36,-188r35,0r-37,188v0,60,103,56,121,10v21,-52,31,-137,47,-198r35,0v-17,69,-27,155,-53,213","w":259},"V":{"d":"94,0r-49,-258r33,0r30,154v6,28,8,50,10,67r119,-221r35,0r-141,258r-37,0","w":240,"k":{"y":7,"u":7,"r":7,"o":13,"i":7,"e":13,"a":13,"A":20,";":7,":":7,".":27,"-":13,",":27}},"W":{"d":"61,0r-16,-258r35,0r8,211r109,-211r36,0r10,213r104,-213r35,0r-131,258r-37,0r-10,-205v-34,75,-72,134,-108,205r-35,0","w":339,"k":{"i":3,"e":7,"a":7,"A":7,".":13,"-":7,",":13}},"X":{"d":"-11,0r123,-130r-73,-128r38,0r58,106v24,-31,68,-74,97,-106r45,0r-125,133r71,125r-38,0r-56,-104v-28,36,-64,70,-95,104r-45,0","w":240},"Y":{"d":"101,0r20,-100r-79,-158r37,0r62,128v25,-43,65,-88,96,-128r41,0r-123,161r-20,97r-34,0","w":240,"k":{"v":13,"u":13,"q":20,"p":20,"o":20,"i":7,"e":20,"a":27,"A":20,";":13,":":13,".":33,"-":27,",":33," ":7}},"Z":{"d":"9,0r3,-26r172,-204r-139,2r7,-30r177,0r-3,27r-170,203v48,-3,100,0,150,-1r-6,29r-191,0","w":219},"[":{"d":"2,70r68,-328r71,0r-5,25r-39,0r-58,279r39,0r-5,24r-71,0","w":100},"\\":{"d":"74,4r-43,-266r24,0r43,266r-24,0","w":100},"]":{"d":"49,70r-70,0r5,-24r39,0r58,-279r-38,0r5,-25r70,0","w":100},"^":{"d":"58,-121r-33,0r62,-141r26,0r62,141r-32,0r-43,-105","w":168},"_":{"d":"-23,72r0,-23r210,0r0,23r-210,0"},"`":{"d":"87,-209r-35,-49r39,0r20,49r-24,0","w":119},"a":{"d":"119,-191v51,-1,79,29,66,83v-9,35,-22,71,-11,108r-32,0v-2,-6,-3,-14,-4,-23v-31,39,-122,38,-122,-27v0,-67,83,-55,138,-67v12,-30,-4,-49,-36,-48v-28,1,-44,13,-52,34r-32,-3v13,-35,39,-57,85,-57xm47,-51v0,48,79,31,89,-1v6,-10,11,-25,14,-43v-34,13,-103,-1,-103,44"},"b":{"d":"168,-35v-20,43,-106,56,-121,0r-7,35r-28,0r54,-258r32,0r-20,92v39,-46,115,-22,115,51v0,33,-11,62,-25,80xm122,-165v-42,0,-62,50,-63,94v-2,29,15,49,40,49v43,0,59,-53,62,-94v2,-28,-15,-49,-39,-49"},"c":{"d":"52,-68v0,75,80,49,89,0r32,3v-13,40,-39,68,-85,69v-42,1,-68,-29,-68,-74v0,-83,76,-156,146,-104v13,10,18,26,18,45r-31,2v0,-22,-15,-38,-37,-38v-48,0,-64,51,-64,97","w":180},"d":{"d":"19,-72v0,-86,94,-165,144,-85r21,-101r31,0r-53,258r-30,0r6,-27v-41,57,-119,31,-119,-45xm112,-165v-42,0,-57,47,-61,87v-3,35,10,56,39,57v57,2,98,-144,22,-144"},"e":{"d":"92,-22v26,0,48,-19,57,-41r31,3v-9,29,-47,65,-88,64v-47,-1,-73,-31,-73,-79v0,-61,37,-115,99,-116v55,-1,82,47,71,106r-137,0v-5,33,11,63,40,63xm161,-110v11,-50,-46,-72,-79,-42v-11,9,-19,23,-25,42r104,0"},"f":{"d":"16,0r34,-162r-28,0r5,-25r28,0v9,-37,9,-77,57,-75v8,0,20,2,35,5r-6,28v-28,-7,-47,-8,-50,22r-4,20r36,0r-5,25r-36,0r-34,162r-32,0","w":100,"k":{"\u2019":-13}},"g":{"d":"149,40v-22,50,-152,50,-139,-23r32,3v-5,41,61,32,76,14v6,-8,15,-38,19,-59v-45,52,-119,17,-119,-55v0,-84,101,-155,150,-76r6,-31r29,0v-19,74,-27,164,-54,227xm112,-165v-63,0,-91,139,-22,139v41,0,65,-45,66,-89v0,-28,-16,-50,-44,-50"},"h":{"d":"154,-113v21,-49,-20,-62,-53,-43v-43,24,-43,100,-57,156r-32,0r54,-258r32,0r-21,99v20,-18,35,-32,65,-32v90,0,25,129,20,191r-32,0"},"i":{"d":"57,-222r8,-36r31,0r-7,36r-32,0xm11,0r39,-187r32,0r-39,187r-32,0","w":79},"j":{"d":"57,-222r8,-36r31,0r-7,36r-32,0xm-44,70r6,-27v34,8,40,-4,48,-41r39,-189r32,0r-40,195v-8,52,-31,78,-85,62","w":79},"k":{"d":"12,0r54,-258r32,0r-33,160r92,-89r42,0r-79,70r48,117r-35,0r-37,-96r-39,34r-13,62r-32,0","w":180},"l":{"d":"9,0r54,-258r32,0r-54,258r-32,0","w":79},"m":{"d":"148,-126v13,-37,-19,-46,-46,-30v-44,26,-43,100,-58,156r-32,0r39,-187r32,0r-7,31v21,-21,31,-34,62,-35v25,-1,41,14,45,35v19,-37,109,-56,109,7v0,49,-20,101,-29,149r-31,0r29,-145v-7,-40,-67,-9,-75,11v-14,34,-23,92,-33,134r-32,0","w":299},"n":{"d":"155,-118v6,-26,5,-47,-22,-47v-74,0,-72,100,-89,165r-32,0r39,-187r29,0r-7,33v21,-21,37,-37,69,-37v90,0,24,129,20,191r-32,0"},"o":{"d":"94,4v-47,0,-76,-27,-76,-75v0,-62,37,-121,101,-120v45,0,76,31,75,78v-1,65,-38,117,-100,117xm118,-166v-47,0,-67,46,-69,92v-1,32,16,54,45,54v46,0,68,-45,69,-93v1,-31,-17,-53,-45,-53"},"p":{"d":"193,-116v-5,64,-32,120,-92,120v-22,0,-40,-11,-52,-34r-21,102r-32,0r54,-259r30,0r-6,26v36,-52,125,-30,119,45xm121,-165v-43,0,-59,48,-62,89v-3,37,12,52,41,54v56,4,94,-143,21,-143"},"q":{"d":"111,-191v27,0,43,16,53,39r7,-35r28,0r-54,259r-32,0r20,-93v-45,50,-118,19,-115,-51v3,-63,34,-119,93,-119xm112,-165v-42,2,-59,48,-62,89v-2,32,14,54,40,54v41,0,61,-51,62,-94v2,-27,-16,-49,-40,-49"},"r":{"d":"71,-149v19,-27,42,-55,80,-35r-13,29v-74,-24,-80,89,-96,155r-30,0r39,-187r28,0","w":119,"k":{"\u2019":-13,".":13,"-":7,",":20}},"s":{"d":"152,-88v38,40,-4,96,-61,92v-44,-3,-79,-21,-76,-68r32,-2v-2,31,19,45,46,46v23,1,41,-10,42,-29v-8,-45,-94,-32,-94,-88v0,-53,84,-70,120,-38v12,11,20,25,20,43r-32,2v5,-40,-78,-50,-78,-12v0,28,74,39,81,54","w":180},"t":{"d":"58,-59v-11,31,0,39,28,33r-5,26v-40,11,-76,-8,-56,-54r22,-108r-25,0r5,-25r26,0r9,-46r37,-22r-15,68r32,0r-6,25r-31,0","w":100},"u":{"d":"58,-67v-7,25,-4,46,22,45v77,-4,70,-99,89,-165r32,0r-39,187r-30,0r7,-34v-22,25,-45,38,-68,38v-91,0,-26,-128,-20,-191r32,0"},"v":{"d":"59,0r-31,-187r31,0r23,158r86,-158r33,0r-107,187r-35,0","w":180,"k":{".":27,",":27}},"w":{"d":"47,0r-19,-187r31,0r12,153v16,-54,45,-103,66,-153r34,0r8,150v16,-41,49,-106,69,-150r32,0r-92,187r-33,0r-8,-149r-66,149r-34,0","w":259,"k":{".":20,",":20}},"x":{"d":"-1,0r82,-95r-47,-92r35,0r32,69r54,-69r39,0r-79,95r47,92r-35,0r-32,-68r-56,68r-40,0","w":180},"y":{"d":"0,72r2,-30v38,13,49,-17,62,-41r-31,-188r31,0r21,151r84,-151r33,0r-119,212v-20,37,-37,59,-83,47","w":180,"k":{".":27,",":27}},"z":{"d":"7,0r5,-25r100,-113v7,-8,15,-15,24,-24v-38,4,-64,1,-102,2r6,-27r144,0r-4,20r-127,141v43,-3,68,-2,110,-2r-6,28r-150,0","w":180},"{":{"d":"87,76v-85,12,-44,-77,-40,-126v2,-18,-10,-29,-28,-29r6,-29v86,-5,12,-165,135,-154r-6,28v-68,-7,-35,93,-76,124v-7,5,-15,12,-27,17v44,14,16,85,11,124v1,16,10,17,31,17","w":120},"|":{"d":"33,76r0,-338r28,0r0,338r-28,0","w":93},"}":{"d":"79,-93v-44,-16,-14,-84,-11,-125v1,-16,-12,-17,-31,-16r6,-28v36,-3,54,6,55,36v2,38,-43,116,13,118r-6,29v-86,10,-20,171,-135,155r6,-28v55,12,44,-67,58,-95v11,-23,22,-37,45,-46","w":120},"~":{"d":"75,-122v-23,0,-30,10,-46,24r0,-36v34,-41,91,-8,134,3v19,0,36,-14,46,-25r0,38v-14,12,-26,19,-49,20v-28,1,-59,-24,-85,-24","w":210},"\u00c4":{"d":"108,-274r8,-36r33,0r-7,36r-34,0xm173,-274r8,-36r33,0r-7,36r-34,0xm-7,0r146,-258r40,0r43,258r-33,0r-13,-74r-104,0r-41,74r-38,0xm87,-101r85,0r-17,-129v-17,41,-47,89,-68,129","w":240},"\u00c5":{"d":"164,-247v-18,0,-33,-14,-32,-32v0,-18,15,-32,32,-32v17,0,32,14,32,32v1,18,-14,32,-32,32xm164,-298v-9,0,-19,10,-19,19v0,9,9,20,19,19v10,1,19,-10,19,-19v0,-9,-10,-19,-19,-19xm-7,0r146,-258r40,0r43,258r-33,0r-13,-74r-104,0r-41,74r-38,0xm87,-101r85,0r-17,-129v-17,41,-47,89,-68,129","w":240},"\u00d6":{"d":"120,-274r8,-36r33,0r-8,36r-33,0xm185,-274r8,-36r33,0r-8,36r-33,0xm141,4v-67,2,-107,-47,-108,-112v-3,-85,58,-153,136,-154v65,-1,111,48,109,115v-3,86,-51,149,-137,151xm169,-233v-59,1,-104,59,-102,127v1,48,30,82,76,82v66,0,98,-58,101,-125v2,-48,-30,-84,-75,-84","w":280},"\u00dc":{"d":"124,-274r7,-36r33,0r-7,36r-33,0xm188,-274r8,-36r33,0r-7,36r-34,0xm219,-45v-31,68,-189,70,-184,-25v3,-58,26,-130,36,-188r35,0r-37,188v0,60,103,56,121,10v21,-52,31,-137,47,-198r35,0v-17,69,-27,155,-53,213","w":259},"\u00e1":{"d":"98,-209r33,-49r40,0r-47,49r-26,0xm119,-191v51,-1,79,29,66,83v-9,35,-22,71,-11,108r-32,0v-2,-6,-3,-14,-4,-23v-31,39,-122,38,-122,-27v0,-67,83,-55,138,-67v12,-30,-4,-49,-36,-48v-28,1,-44,13,-52,34r-32,-3v13,-35,39,-57,85,-57xm47,-51v0,48,79,31,89,-1v6,-10,11,-25,14,-43v-34,13,-103,-1,-103,44"},"\u00e0":{"d":"119,-191v51,-1,79,29,66,83v-9,35,-22,71,-11,108r-32,0v-2,-6,-3,-14,-4,-23v-31,39,-122,38,-122,-27v0,-67,83,-55,138,-67v12,-30,-4,-49,-36,-48v-28,1,-44,13,-52,34r-32,-3v13,-35,39,-57,85,-57xm47,-51v0,48,79,31,89,-1v6,-10,11,-25,14,-43v-34,13,-103,-1,-103,44xm135,-209r-35,-49r39,0r20,49r-24,0"},"\u00e2":{"d":"76,-209r47,-49r35,0r21,49r-27,0r-14,-32r-29,32r-33,0xm119,-191v51,-1,79,29,66,83v-9,35,-22,71,-11,108r-32,0v-2,-6,-3,-14,-4,-23v-31,39,-122,38,-122,-27v0,-67,83,-55,138,-67v12,-30,-4,-49,-36,-48v-28,1,-44,13,-52,34r-32,-3v13,-35,39,-57,85,-57xm47,-51v0,48,79,31,89,-1v6,-10,11,-25,14,-43v-34,13,-103,-1,-103,44"},"\u00e4":{"d":"78,-216r8,-36r33,0r-7,36r-34,0xm143,-216r8,-36r33,0r-8,36r-33,0xm119,-191v51,-1,79,29,66,83v-9,35,-22,71,-11,108r-32,0v-2,-6,-3,-14,-4,-23v-31,39,-122,38,-122,-27v0,-67,83,-55,138,-67v12,-30,-4,-49,-36,-48v-28,1,-44,13,-52,34r-32,-3v13,-35,39,-57,85,-57xm47,-51v0,48,79,31,89,-1v6,-10,11,-25,14,-43v-34,13,-103,-1,-103,44"},"\u00e3":{"d":"160,-215v-25,0,-56,-33,-62,0r-22,0v7,-26,12,-36,35,-39v22,-3,55,34,62,1r22,0v-1,21,-15,38,-35,38xm119,-191v51,-1,79,29,66,83v-9,35,-22,71,-11,108r-32,0v-2,-6,-3,-14,-4,-23v-31,39,-122,38,-122,-27v0,-67,83,-55,138,-67v12,-30,-4,-49,-36,-48v-28,1,-44,13,-52,34r-32,-3v13,-35,39,-57,85,-57xm47,-51v0,48,79,31,89,-1v6,-10,11,-25,14,-43v-34,13,-103,-1,-103,44"},"\u00e5":{"d":"128,-200v-18,1,-32,-14,-32,-32v0,-18,14,-33,32,-32v18,0,32,15,32,32v0,17,-14,32,-32,32xm128,-251v-9,0,-19,10,-19,19v0,9,10,19,19,19v9,0,19,-10,19,-19v0,-9,-10,-19,-19,-19xm119,-191v51,-1,79,29,66,83v-9,35,-22,71,-11,108r-32,0v-2,-6,-3,-14,-4,-23v-31,39,-122,38,-122,-27v0,-67,83,-55,138,-67v12,-30,-4,-49,-36,-48v-28,1,-44,13,-52,34r-32,-3v13,-35,39,-57,85,-57xm47,-51v0,48,79,31,89,-1v6,-10,11,-25,14,-43v-34,13,-103,-1,-103,44"},"\u00e7":{"d":"91,38v-1,-13,-13,-15,-29,-15r7,-28r25,0r-4,16v18,1,30,13,31,29v0,36,-55,34,-90,29r4,-19v21,-1,53,4,56,-12xm52,-68v0,75,80,49,89,0r32,3v-13,40,-39,68,-85,69v-42,1,-68,-29,-68,-74v0,-83,76,-156,146,-104v13,10,18,26,18,45r-31,2v0,-22,-15,-38,-37,-38v-48,0,-64,51,-64,97","w":180},"\u00e9":{"d":"101,-209r33,-49r40,0r-47,49r-26,0xm92,-22v26,0,48,-19,57,-41r31,3v-9,29,-47,65,-88,64v-47,-1,-73,-31,-73,-79v0,-61,37,-115,99,-116v55,-1,82,47,71,106r-137,0v-5,33,11,63,40,63xm161,-110v11,-50,-46,-72,-79,-42v-11,9,-19,23,-25,42r104,0"},"\u00e8":{"d":"92,-22v26,0,48,-19,57,-41r31,3v-9,29,-47,65,-88,64v-47,-1,-73,-31,-73,-79v0,-61,37,-115,99,-116v55,-1,82,47,71,106r-137,0v-5,33,11,63,40,63xm161,-110v11,-50,-46,-72,-79,-42v-11,9,-19,23,-25,42r104,0xm135,-209r-35,-49r39,0r20,49r-24,0"},"\u00ea":{"d":"78,-209r47,-49r35,0r22,49r-28,0r-14,-32r-29,32r-33,0xm92,-22v26,0,48,-19,57,-41r31,3v-9,29,-47,65,-88,64v-47,-1,-73,-31,-73,-79v0,-61,37,-115,99,-116v55,-1,82,47,71,106r-137,0v-5,33,11,63,40,63xm161,-110v11,-50,-46,-72,-79,-42v-11,9,-19,23,-25,42r104,0"},"\u00ed":{"d":"22,0r39,-187r32,0r-39,187r-32,0xm53,-209r33,-49r40,0r-47,49r-26,0","w":100},"\u00ec":{"d":"22,0r39,-187r32,0r-39,187r-32,0xm87,-209r-35,-49r39,0r20,49r-24,0","w":100},"\u00ee":{"d":"27,-209r46,-49r35,0r22,49r-28,0r-14,-32r-29,32r-32,0xm22,0r39,-187r32,0r-39,187r-32,0","w":100},"\u00ef":{"d":"22,0r39,-187r32,0r-39,187r-32,0xm31,-216r7,-36r33,0r-7,36r-33,0xm95,-216r8,-36r33,0r-7,36r-34,0","w":100},"\u00f1":{"d":"157,-215v-25,0,-56,-33,-62,0r-22,0v7,-26,12,-36,35,-39v22,-3,55,34,62,1r22,0v-1,21,-15,38,-35,38xm155,-118v6,-26,5,-47,-22,-47v-74,0,-72,100,-89,165r-32,0r39,-187r29,0r-7,33v21,-21,37,-37,69,-37v90,0,24,129,20,191r-32,0"},"\u00f3":{"d":"94,-209r33,-49r40,0r-46,49r-27,0xm94,4v-47,0,-76,-27,-76,-75v0,-62,37,-121,101,-120v45,0,76,31,75,78v-1,65,-38,117,-100,117xm118,-166v-47,0,-67,46,-69,92v-1,32,16,54,45,54v46,0,68,-45,69,-93v1,-31,-17,-53,-45,-53"},"\u00f2":{"d":"94,4v-47,0,-76,-27,-76,-75v0,-62,37,-121,101,-120v45,0,76,31,75,78v-1,65,-38,117,-100,117xm118,-166v-47,0,-67,46,-69,92v-1,32,16,54,45,54v46,0,68,-45,69,-93v1,-31,-17,-53,-45,-53xm136,-209r-35,-49r39,0r20,49r-24,0"},"\u00f4":{"d":"73,-209r46,-49r35,0r22,49r-28,0r-14,-32r-29,32r-32,0xm94,4v-47,0,-76,-27,-76,-75v0,-62,37,-121,101,-120v45,0,76,31,75,78v-1,65,-38,117,-100,117xm118,-166v-47,0,-67,46,-69,92v-1,32,16,54,45,54v46,0,68,-45,69,-93v1,-31,-17,-53,-45,-53"},"\u00f6":{"d":"75,-216r8,-36r33,0r-8,36r-33,0xm140,-216r7,-36r34,0r-8,36r-33,0xm94,4v-47,0,-76,-27,-76,-75v0,-62,37,-121,101,-120v45,0,76,31,75,78v-1,65,-38,117,-100,117xm118,-166v-47,0,-67,46,-69,92v-1,32,16,54,45,54v46,0,68,-45,69,-93v1,-31,-17,-53,-45,-53"},"\u00f5":{"d":"152,-215v-25,-1,-55,-33,-62,0r-22,0v7,-25,12,-36,36,-39v22,-3,54,33,62,1r21,0v-1,21,-15,38,-35,38xm94,4v-47,0,-76,-27,-76,-75v0,-62,37,-121,101,-120v45,0,76,31,75,78v-1,65,-38,117,-100,117xm118,-166v-47,0,-67,46,-69,92v-1,32,16,54,45,54v46,0,68,-45,69,-93v1,-31,-17,-53,-45,-53"},"\u00fa":{"d":"103,-209r33,-49r40,0r-47,49r-26,0xm58,-67v-7,25,-4,46,22,45v77,-4,70,-99,89,-165r32,0r-39,187r-30,0r7,-34v-22,25,-45,38,-68,38v-91,0,-26,-128,-20,-191r32,0"},"\u00f9":{"d":"58,-67v-7,25,-4,46,22,45v77,-4,70,-99,89,-165r32,0r-39,187r-30,0r7,-34v-22,25,-45,38,-68,38v-91,0,-26,-128,-20,-191r32,0xm136,-209r-35,-49r39,0r20,49r-24,0"},"\u00fb":{"d":"75,-209r46,-49r36,0r21,49r-27,0r-14,-32r-29,32r-33,0xm58,-67v-7,25,-4,46,22,45v77,-4,70,-99,89,-165r32,0r-39,187r-30,0r7,-34v-22,25,-45,38,-68,38v-91,0,-26,-128,-20,-191r32,0"},"\u00fc":{"d":"79,-216r8,-36r33,0r-7,36r-34,0xm144,-216r8,-36r33,0r-7,36r-34,0xm58,-67v-7,25,-4,46,22,45v77,-4,70,-99,89,-165r32,0r-39,187r-30,0r7,-34v-22,25,-45,38,-68,38v-91,0,-26,-128,-20,-191r32,0"},"\u00a3":{"d":"15,4r-4,-31v27,-18,58,-44,54,-87r-39,0r6,-27r30,0v-27,-91,63,-153,132,-104v15,10,22,28,25,51r-29,3v-3,-27,-19,-46,-46,-46v-44,0,-62,47,-49,96r51,0r-6,27r-44,0v1,37,-13,59,-37,77v49,-8,81,27,122,0r9,28v-60,39,-120,-33,-175,13"},"\u00df":{"d":"166,-218v-11,-40,-73,-11,-79,18r-42,200r-32,0v19,-74,26,-164,55,-227v20,-41,130,-52,130,6v0,33,-39,56,-44,84v5,30,53,45,50,80v-3,35,-31,61,-69,61v-25,0,-46,-13,-63,-41r27,-14v11,41,72,33,73,-7v1,-26,-51,-44,-51,-75v0,-28,42,-59,45,-85","w":219},"\u2122":{"d":"96,-114r0,-122r-47,0r0,-22r117,0r0,22r-46,0r0,122r-24,0xm182,-114r0,-144r35,0r37,115r35,-115r34,0r0,144r-22,0r0,-121r-37,121r-21,0r-39,-122r0,122r-22,0","w":360},"\u00e6":{"d":"34,-134v8,-56,109,-78,143,-31v43,-50,142,-24,134,52v0,7,0,17,-2,28r-136,0v-5,34,10,63,40,63v28,-1,45,-18,56,-41r32,3v-17,36,-42,64,-88,64v-33,0,-54,-17,-67,-41v-21,50,-131,60,-131,-13v0,-66,79,-55,132,-66v11,-27,1,-50,-29,-50v-29,0,-45,13,-53,35xm282,-110v6,-50,-44,-72,-78,-41v-11,11,-20,23,-25,41r103,0xm48,-52v0,35,49,40,69,17v12,-13,21,-32,25,-57v-30,11,-94,-3,-94,40","w":320},"\u00f8":{"d":"47,-20v-56,-77,29,-214,128,-159r19,-25r16,13r-20,26v52,79,-29,209,-127,158r-20,25r-16,-12xm157,-157v-61,-36,-115,48,-90,113xm80,-28v61,31,111,-49,89,-112","w":219},"\u00bf":{"d":"172,-187r-7,36r-36,0r7,-36r36,0xm30,12v-1,-63,89,-72,97,-134r30,0v-2,67,-88,77,-95,137v-2,20,20,36,41,35v32,-2,48,-20,52,-55r31,6v-9,45,-34,73,-82,74v-42,0,-73,-24,-74,-63","w":219},"\u00ab":{"d":"62,-93r27,80r-23,0r-38,-84r71,-75r25,0xm131,-93r27,80r-25,0r-35,-84r68,-75r27,0"},"\u00bb":{"d":"79,-92r-26,-80r25,0r34,85r-69,74r-28,0xm148,-90r-26,-82r24,0r36,85r-72,74r-25,0"},"\u2026":{"d":"52,0r7,-36r36,0r-7,36r-36,0xm172,0r7,-36r37,0r-8,36r-36,0xm292,0r8,-36r36,0r-8,36r-36,0","w":360},"\u2013":{"d":"-1,-81r0,-25r201,0r0,25r-201,0"},"\u2014":{"d":"0,-81r0,-25r360,0r0,25r-360,0","w":360},"\u201c":{"d":"138,-210r-8,36r-36,0v9,-39,15,-85,55,-88r-3,14v-14,4,-23,16,-28,38r20,0xm82,-210r-8,36r-36,0v9,-39,15,-85,55,-88r-3,14v-14,4,-23,16,-28,38r20,0","w":119},"\u201d":{"d":"49,-221r7,-36r36,0v-6,41,-16,84,-54,89r3,-14v14,-4,22,-17,27,-39r-19,0xm107,-221r7,-36r36,0v-6,41,-16,84,-54,89r2,-14v14,-4,23,-17,28,-39r-19,0","w":119},"\u2018":{"d":"90,-210r-7,36r-37,0v9,-39,15,-85,55,-88r-3,14v-14,4,-23,16,-28,38r20,0","w":79,"k":{"\u2018":13}},"\u2019":{"d":"56,-221r7,-36r37,0v-8,40,-15,85,-55,89r3,-14v14,-4,23,-17,28,-39r-20,0","w":79,"k":{"\u2019":13,"s":7," ":20}},"\u00ff":{"d":"72,-216r7,-36r33,0r-7,36r-33,0xm137,-216r7,-36r33,0r-7,36r-33,0xm0,72r2,-30v38,13,49,-17,62,-41r-31,-188r31,0r21,151r84,-151r33,0r-119,212v-20,37,-37,59,-83,47","w":180},"\u20ac":{"d":"68,-94v-1,61,72,91,118,53r-8,37v-73,27,-146,-14,-145,-90r-19,0r5,-24r14,0v0,-8,2,-15,3,-23r-22,0r5,-23r22,0v17,-71,119,-132,191,-77r-14,30v-42,-52,-129,-8,-140,47r110,0r-5,23r-113,0v-2,8,-2,15,-3,23r111,0r-5,24r-105,0"},"\u0142":{"d":"33,-110r-26,15r5,-28r27,-14r25,-121r32,0r-21,102r28,-15r-6,28r-28,15r-27,128r-31,0","w":79},"\u00d7":{"d":"46,-72r55,-55r-55,-55r22,-22r55,55r55,-55r21,22r-55,55r55,55r-21,21r-55,-55r-56,55","w":210},"\u0107":{"d":"103,-209r33,-49r40,0r-47,49r-26,0xm52,-68v0,75,80,49,89,0r32,3v-13,40,-39,68,-85,69v-42,1,-68,-29,-68,-74v0,-83,76,-156,146,-104v13,10,18,26,18,45r-31,2v0,-22,-15,-38,-37,-38v-48,0,-64,51,-64,97","w":180},"\u0105":{"d":"141,76v-54,-5,-22,-63,5,-76r23,0v-18,10,-27,21,-29,38v-2,15,20,16,31,9r-5,22v-9,4,-17,7,-25,7xm119,-191v51,-1,79,29,66,83v-9,35,-22,71,-11,108r-32,0v-2,-6,-3,-14,-4,-23v-31,39,-122,38,-122,-27v0,-67,83,-55,138,-67v12,-30,-4,-49,-36,-48v-28,1,-44,13,-52,34r-32,-3v13,-35,39,-57,85,-57xm47,-51v0,48,79,31,89,-1v6,-10,11,-25,14,-43v-34,13,-103,-1,-103,44"},"\u0119":{"d":"91,76v-53,-5,-22,-62,4,-76r23,0v-17,11,-27,19,-28,38v-1,15,20,16,31,9r-5,22v-9,4,-17,7,-25,7xm92,-22v26,0,48,-19,57,-41r31,3v-9,29,-47,65,-88,64v-47,-1,-73,-31,-73,-79v0,-61,37,-115,99,-116v55,-1,82,47,71,106r-137,0v-5,33,11,63,40,63xm161,-110v11,-50,-46,-72,-79,-42v-11,9,-19,23,-25,42r104,0"},"\u0151":{"d":"77,-209r33,-49r40,0r-47,49r-26,0xm136,-209r32,-49r41,0r-48,49r-25,0xm94,4v-47,0,-76,-27,-76,-75v0,-62,37,-121,101,-120v45,0,76,31,75,78v-1,65,-38,117,-100,117xm118,-166v-47,0,-67,46,-69,92v-1,32,16,54,45,54v46,0,68,-45,69,-93v1,-31,-17,-53,-45,-53"},"\u015b":{"d":"88,-209r33,-49r40,0r-47,49r-26,0xm152,-88v38,40,-4,96,-61,92v-44,-3,-79,-21,-76,-68r32,-2v-2,31,19,45,46,46v23,1,41,-10,42,-29v-8,-45,-94,-32,-94,-88v0,-53,84,-70,120,-38v12,11,20,25,20,43r-32,2v5,-40,-78,-50,-78,-12v0,28,74,39,81,54","w":180},"\u0171":{"d":"72,-209r33,-49r40,0r-47,49r-26,0xm131,-209r32,-49r41,0r-48,49r-25,0xm58,-67v-7,25,-4,46,22,45v77,-4,70,-99,89,-165r32,0r-39,187r-30,0r7,-34v-22,25,-45,38,-68,38v-91,0,-26,-128,-20,-191r32,0"},"\u017a":{"d":"86,-209r33,-49r40,0r-47,49r-26,0xm7,0r5,-25r100,-113v7,-8,15,-15,24,-24v-38,4,-64,1,-102,2r6,-27r144,0r-4,20r-127,141v43,-3,68,-2,110,-2r-6,28r-150,0","w":180},"\u017c":{"d":"91,-213r8,-39r39,0r-8,39r-39,0xm7,0r5,-25r100,-113v7,-8,15,-15,24,-24v-38,4,-64,1,-102,2r6,-27r144,0r-4,20r-127,141v43,-3,68,-2,110,-2r-6,28r-150,0","w":180},"\u2032":{"d":"46,-166v0,-34,4,-65,11,-92r36,0v-6,34,-16,64,-28,92r-19,0","w":67},"\u2033":{"d":"49,-166v0,-34,4,-65,11,-92r36,0v-6,34,-16,64,-28,92r-19,0xm107,-166v0,-34,4,-65,11,-92r36,0v-6,34,-16,64,-28,92r-19,0","w":127}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 *  2008 The Monotype Corporation. All Rights Reserved.
 * 
 * Trademark:
 * Arial is a trademark of The Monotype Corporation in the United States and/or
 * other countries.
 * 
 * Manufacturer:
 * The Monotype Corporation
 * 
 * Designer:
 * Monotype Type Drawing Office - Robin Nicholas, Patricia Saunders 1982
 */
Cufon.registerFont({"w":200,"face":{"font-family":"Arial","font-weight":700,"font-style":"italic","font-stretch":"normal","units-per-em":"360","panose-1":"2 11 7 4 2 2 2 9 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-39 -315 384 77.5779","underline-thickness":"37.793","underline-position":"-19.3359","slope":"-12","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":100,"k":{"Y":7,"A":13}},"\u00a0":{"w":100},"!":{"d":"73,-66r-27,0r16,-131r12,-61r53,0v-11,71,-34,130,-54,192xm32,-49r50,0r-10,49r-50,0","w":119},"\"":{"d":"54,-166v-1,-35,3,-65,11,-92r53,0v-5,34,-15,64,-27,92r-37,0xm118,-166v-1,-35,3,-65,11,-92r53,0v-5,34,-15,64,-27,92r-37,0","w":170},"#":{"d":"41,-64r-24,0r0,-39r32,0r10,-52r-42,0r0,-39r50,0r14,-68r40,0r-14,68r39,0r13,-68r41,0r-14,68r24,0r0,39r-32,0r-11,52r43,0r0,39r-51,0r-13,68r-40,0r14,-68r-39,0r-14,68r-40,0xm99,-155r-10,52r39,0r10,-52r-39,0"},"$":{"d":"191,-76v2,46,-42,83,-91,81r-6,31r-26,0r7,-34v-33,-9,-57,-37,-59,-77r44,-2v2,20,11,33,24,39r16,-77v-31,-13,-54,-37,-54,-73v0,-46,37,-76,85,-74r3,-15r25,0r-4,18v30,8,48,29,52,63r-43,2v-2,-13,-8,-22,-17,-27r-14,70v35,13,57,36,58,75xm123,-225v-38,-1,-48,50,-13,64xm108,-34v29,-1,52,-28,37,-55v-3,-5,-11,-10,-22,-16"},"%":{"d":"81,-127v-30,0,-49,-20,-48,-51v0,-42,24,-86,68,-84v31,0,50,20,49,53v-2,43,-23,82,-69,82xm99,-232v-25,1,-43,69,-15,76v18,-1,30,-38,30,-60v0,-10,-6,-16,-15,-16xm85,11r-40,0r214,-273r41,0xm242,11v-29,0,-49,-20,-48,-51v0,-42,25,-86,68,-85v31,0,50,20,49,53v-2,44,-24,83,-69,83xm260,-95v-22,0,-27,39,-29,59v-1,11,4,17,14,17v18,0,30,-37,30,-59v0,-10,-6,-18,-15,-17","w":320},"&":{"d":"217,-213v0,34,-28,56,-60,72r39,58v6,-6,14,-16,22,-29r36,22v-6,12,-18,31,-28,39v7,7,15,15,25,24r-31,33v-9,-4,-24,-18,-31,-25v-46,41,-165,26,-159,-50v4,-48,28,-67,66,-86v-29,-54,2,-107,61,-107v33,0,60,20,60,49xm156,-229v-26,0,-31,31,-17,53v19,-11,32,-17,35,-37v0,-10,-7,-17,-18,-16xm80,-73v0,41,51,45,81,22v-18,-22,-34,-44,-47,-68v-23,12,-34,27,-34,46","w":259},"'":{"d":"54,-166v-1,-35,3,-65,11,-92r53,0v-5,34,-15,64,-27,92r-37,0","w":85},"(":{"d":"157,-262v-74,73,-111,210,-71,338r-34,0v-16,-37,-28,-84,-28,-131v0,-97,41,-146,94,-207r39,0","w":119},")":{"d":"-28,76v73,-74,112,-211,70,-338r35,0v16,37,28,84,28,131v0,96,-42,146,-95,207r-38,0","w":119},"*":{"d":"73,-139r-26,-21r33,-34r-45,-11r11,-31v15,6,29,13,41,21v-3,-19,-4,-35,-4,-47r31,0v0,9,-2,24,-5,47r44,-19r10,32v-13,3,-28,5,-45,8r31,36r-27,18r-24,-40v-7,13,-16,27,-25,41","w":140},"+":{"d":"97,-37r0,-67r-68,0r0,-46r68,0r0,-67r45,0r0,67r67,0r0,46r-67,0r0,67r-45,0","w":210},",":{"d":"26,-49r50,0v-9,50,-16,106,-72,105r5,-23v16,-5,25,-14,29,-33r-23,0","w":100},"-":{"d":"24,-117r98,0r-10,48r-98,0","w":119},"\u00ad":{"d":"24,-117r98,0r-10,48r-98,0","w":119},".":{"d":"26,-49r50,0r-10,49r-50,0","w":100},"\/":{"d":"-16,4r128,-266r35,0r-127,266r-36,0","w":100},"0":{"d":"95,4v-46,0,-73,-37,-72,-88v4,-82,34,-175,111,-175v47,0,74,37,72,89v-3,78,-33,174,-111,174xm132,-218v-46,0,-56,95,-59,144v-2,23,5,38,24,38v48,0,53,-98,59,-146v3,-22,-6,-36,-24,-36"},"1":{"d":"43,-148r9,-45v43,-19,77,-41,101,-66r31,0r-54,259r-51,0r37,-179v-18,12,-49,27,-73,31","k":{"1":27}},"2":{"d":"130,-219v-22,0,-30,17,-35,42r-49,-8v6,-43,35,-71,82,-74v75,-4,99,85,50,132v-20,20,-59,54,-79,81r89,0r-10,46r-156,0v13,-82,91,-108,130,-172v12,-21,1,-47,-22,-47"},"3":{"d":"158,-132v67,36,11,142,-60,136v-46,-4,-75,-28,-80,-71r49,-6v3,24,9,34,31,36v22,1,40,-18,40,-41v0,-24,-16,-36,-42,-34r9,-42v26,4,50,-12,47,-37v-4,-43,-57,-29,-60,8r-46,-9v12,-40,39,-64,83,-67v80,-6,97,109,29,127"},"4":{"d":"111,-53r-101,0r9,-42r139,-163r44,0r-34,163r31,0r-9,42r-31,0r-11,53r-48,0xm120,-95r17,-81r-68,81r51,0"},"5":{"d":"198,-102v0,81,-93,140,-154,85v-15,-13,-21,-33,-21,-57r49,-4v-1,24,8,39,29,41v44,3,72,-101,17,-101v-17,0,-27,9,-37,19r-42,-4r39,-131r130,0r-10,46r-85,0r-12,40v48,-22,97,13,97,66"},"6":{"d":"29,-93v-4,-97,69,-207,157,-150v11,11,18,26,21,48r-47,4v1,-29,-30,-34,-46,-17v-9,10,-17,25,-23,47v48,-31,106,8,103,65v-3,56,-35,101,-90,101v-52,0,-72,-40,-75,-98xm118,-139v-42,-1,-60,97,-12,103v42,1,58,-97,12,-103"},"7":{"d":"37,-208r10,-46r170,0r-8,36v-52,47,-99,140,-117,218r-48,0v18,-79,56,-153,103,-208r-110,0"},"8":{"d":"24,-67v0,-37,23,-66,53,-75v-55,-34,-15,-117,54,-117v43,0,74,25,73,64v-1,30,-19,47,-44,57v68,37,14,150,-61,143v-43,-4,-75,-29,-75,-72xm130,-220v-18,0,-33,16,-33,35v0,16,10,27,26,27v17,0,34,-17,34,-34v0,-17,-10,-28,-27,-28xm114,-119v-40,-5,-60,82,-12,84v41,5,61,-83,12,-84"},"9":{"d":"201,-161v0,97,-72,208,-158,149v-13,-9,-19,-27,-20,-47r47,-4v-1,29,30,34,46,17v10,-10,17,-25,23,-47v-48,31,-103,-8,-103,-65v0,-51,38,-102,90,-101v51,1,75,43,75,98xm112,-116v42,3,60,-98,12,-102v-41,-2,-58,97,-12,102"},":":{"d":"64,-187r50,0r-10,49r-50,0xm36,-49r49,0r-10,49r-50,0","w":119},";":{"d":"65,-187r50,0r-10,49r-50,0xm37,-49r50,0v-9,50,-16,106,-72,105r5,-23v16,-5,25,-14,29,-33r-23,0","w":119},"\u037e":{"d":"65,-187r50,0r-10,49r-50,0xm37,-49r50,0v-9,50,-16,106,-72,105r5,-23v16,-5,25,-14,29,-33r-23,0","w":119},"<":{"d":"207,-29r-176,-77r0,-43r176,-76r0,50r-123,47r123,49r0,50","w":210},"=":{"d":"29,-143r0,-46r180,0r0,46r-180,0xm29,-65r0,-46r180,0r0,46r-180,0","w":210},">":{"d":"31,-29r0,-50r123,-48r-123,-48r0,-50r177,77r0,42","w":210},"?":{"d":"223,-197v1,57,-89,77,-100,133r-45,0v-1,-63,84,-85,97,-136v0,-17,-15,-26,-35,-25v-30,1,-42,17,-49,45r-47,-8v11,-43,46,-73,97,-74v47,-1,81,26,82,65xm72,-49r50,0r-10,49r-50,0","w":219},"@":{"d":"204,43v56,1,96,-15,121,-46r37,0v-25,51,-80,79,-155,79v-111,0,-184,-56,-184,-161v0,-106,70,-177,181,-177v88,1,147,50,149,135v1,66,-53,129,-116,127v-19,0,-28,-5,-32,-20v-43,44,-116,10,-116,-54v0,-75,87,-160,142,-93r4,-19r47,0r-29,141v0,6,2,9,7,9v35,-9,62,-50,62,-92v0,-62,-51,-102,-119,-102v-93,0,-148,60,-148,148v0,83,62,125,149,125xm189,-159v-37,0,-52,47,-54,83v0,26,10,44,31,44v39,0,53,-45,55,-86v1,-23,-12,-41,-32,-41","w":351},"A":{"d":"184,-57r-103,0r-31,57r-54,0r146,-258r59,0r41,258r-50,0xm177,-100r-15,-104r-62,104r77,0","w":259,"k":{"\u2019":20,"Y":27,"W":20,"V":27,"T":27," ":13}},"B":{"d":"249,-83v0,58,-44,83,-113,83r-122,0r54,-258v82,3,188,-18,188,63v0,33,-20,52,-49,61v24,6,42,24,42,51xm203,-189v0,-37,-53,-23,-91,-26r-13,61v46,-1,103,8,104,-35xm195,-79v0,-41,-63,-28,-105,-30r-14,68v52,-1,119,10,119,-38","w":259},"C":{"d":"138,-40v34,0,54,-24,63,-53r54,8v-17,52,-57,90,-120,90v-66,0,-101,-43,-101,-112v0,-113,112,-198,204,-133v19,13,27,35,30,61r-50,5v-6,-27,-20,-42,-49,-42v-56,0,-80,57,-83,111v-1,38,19,65,52,65","w":259},"D":{"d":"139,-258v149,-25,144,170,66,232v-38,30,-118,25,-189,26r54,-258r69,0xm208,-152v3,-59,-33,-67,-94,-63r-37,174v93,10,127,-33,131,-111","w":259},"E":{"d":"15,0r54,-258r191,0r-9,43r-138,0r-13,59r134,0r-9,43r-134,0r-16,70r150,0r-9,43r-201,0","w":240},"F":{"d":"14,0r54,-258r180,0r-9,43r-127,0r-13,62r125,0r-9,43r-125,0r-23,110r-53,0","w":219,"k":{"A":20,".":40,",":40}},"G":{"d":"83,-104v-5,73,75,73,124,48r8,-39r-66,0r9,-43r116,0r-24,111v-26,17,-68,31,-110,31v-72,0,-108,-41,-108,-107v0,-90,53,-158,143,-159v61,-1,96,30,108,81r-50,6v-7,-27,-25,-44,-57,-44v-62,0,-89,52,-93,115","w":280},"H":{"d":"192,-115r-99,0r-24,115r-53,0r54,-258r53,0r-21,100r99,0r21,-100r53,0r-54,258r-53,0","w":259},"I":{"d":"12,0r54,-258r53,0r-53,258r-54,0","w":100},"J":{"d":"60,-78v-14,39,39,49,57,26v18,-52,32,-145,47,-206r52,0v-19,75,-27,193,-67,240v-37,43,-158,26,-138,-55"},"K":{"d":"14,0r54,-258r53,0r-23,110r119,-110r71,0r-115,101r85,157r-60,0r-64,-123r-50,44r-16,79r-54,0","w":259},"L":{"d":"16,0r54,-258r53,0r-45,215r131,0r-9,43r-184,0","w":219,"k":{"\u2019":27,"Y":27,"W":20,"V":20,"T":27," ":7}},"M":{"d":"163,0r-50,0r-10,-215r-41,215r-47,0r53,-258r76,0r8,181r88,-181r76,0r-54,258r-48,0r51,-214","w":299},"N":{"d":"221,0r-50,0r-69,-173r-36,173r-50,0r54,-258r50,0r69,173r36,-173r50,0","w":259},"O":{"d":"137,5v-66,0,-106,-44,-106,-106v0,-91,50,-159,145,-161v62,-1,108,44,106,108v-3,88,-55,159,-145,159xm171,-218v-53,-1,-87,63,-87,116v0,35,24,63,59,62v54,-2,83,-59,86,-113v1,-37,-23,-64,-58,-65","w":280},"P":{"d":"253,-193v-3,84,-66,101,-165,95r-20,98r-53,0r54,-258v81,2,187,-19,184,65xm200,-189v2,-37,-50,-23,-87,-26r-16,74v60,2,100,-1,103,-48","w":240,"k":{"A":27,".":46,",":46," ":13}},"Q":{"d":"282,-154v-1,54,-25,103,-58,128v11,11,24,20,36,27r-25,33v-16,-8,-32,-21,-46,-39v-77,32,-162,-15,-158,-97v5,-86,54,-160,145,-160v62,-1,108,44,106,108xm162,-42v-2,-12,-20,-19,-29,-23r20,-30v16,8,29,20,41,33v41,-33,57,-159,-23,-156v-59,2,-84,54,-87,113v-2,43,32,74,78,63","w":280},"R":{"d":"267,-190v-2,48,-30,75,-79,80v27,30,36,59,58,110r-57,0v-15,-23,-23,-113,-76,-107r-22,0r-22,107r-53,0r54,-258v86,4,201,-23,197,68xm214,-189v1,-37,-62,-23,-100,-26r-15,70v59,0,113,5,115,-44","w":259,"k":{"Y":7,"W":7,"T":7}},"S":{"d":"208,-123v48,55,-9,132,-84,127v-60,-4,-103,-25,-101,-87r50,-3v2,36,15,43,51,46v38,3,66,-29,40,-51v-32,-27,-110,-33,-110,-96v0,-76,112,-95,162,-54v17,14,25,33,27,57r-50,2v5,-43,-85,-54,-88,-11v4,26,19,25,47,39v29,14,48,23,56,31","w":240},"T":{"d":"127,0r-53,0r45,-215r-76,0r9,-43r203,0r-9,43r-74,0","w":219,"k":{"y":13,"w":13,"u":7,"s":13,"r":7,"o":13,"i":7,"e":13,"c":13,"a":13,"O":7,"A":27,";":27,":":27,".":27,"-":20,",":27}},"U":{"d":"225,-49v-33,80,-215,69,-191,-41r35,-168r53,0r-37,183v-3,34,49,45,75,28v23,-15,25,-32,33,-70r30,-141r52,0v-16,66,-28,154,-50,209","w":259},"V":{"d":"144,0r-57,0r-46,-258r53,0r32,195r107,-195r53,0","w":240,"k":{"y":7,"u":7,"r":7,"o":13,"i":13,"e":13,"a":13,"A":27,";":13,":":13,".":33,"-":13,",":33}},"W":{"d":"260,0r-54,0r-6,-188r-93,188r-55,0r-10,-258r52,0r2,181r89,-181r57,0r6,179r85,-179r51,0","w":339,"k":{"y":7,"u":7,"r":7,"o":7,"i":3,"e":7,"a":7,"A":20,";":13,":":13,".":27,"-":13,",":27}},"X":{"d":"58,0r-69,0r114,-130r-64,-128r55,0r45,89r77,-89r66,0r-118,136r64,122r-60,0r-40,-83v-10,15,-51,62,-70,83","w":240},"Y":{"d":"144,0r-53,0r21,-100r-71,-158r57,0r47,111v23,-38,52,-73,76,-111r61,0r-118,163","w":240,"k":{"v":13,"u":13,"q":13,"p":13,"o":13,"i":13,"e":13,"a":13,"A":27,";":20,":":20,".":33,"-":27,",":33," ":7}},"Z":{"d":"9,0r8,-41r149,-174r-120,0r9,-43r185,0r-7,41r-150,175r135,-1r-9,43r-200,0","w":219},"[":{"d":"97,33r-8,38r-85,0r68,-329r86,0r-8,40r-39,0r-52,251r38,0","w":119},"\\":{"d":"68,4r-40,-266r35,0r40,266r-35,0","w":100},"]":{"d":"41,-220r8,-38r86,0r-69,329r-86,0r8,-39r39,0r53,-252r-39,0","w":119},"^":{"d":"38,-122r66,-140r39,0r64,140r-49,0r-35,-86r-35,86r-50,0","w":210},"_":{"d":"-3,71r0,-32r205,0r0,32r-205,0"},"`":{"d":"48,-263r49,0r22,52r-34,0","w":119},"a":{"d":"143,-136v-2,-28,-55,-24,-57,2r-50,-4v12,-34,39,-52,85,-53v42,-1,70,16,71,50v1,36,-29,100,-15,141r-49,0v-2,-7,-4,-14,-4,-21v-26,39,-112,31,-108,-29v3,-43,27,-59,76,-62v24,-2,40,-4,48,-7v2,-7,3,-13,3,-17xm64,-54v0,33,51,21,59,1v3,-7,8,-22,11,-34v-32,7,-70,4,-70,33"},"b":{"d":"217,-114v-6,63,-31,118,-93,118v-27,0,-46,-12,-59,-35r-6,31r-46,0r54,-258r50,0r-18,86v44,-40,125,-14,118,58xm133,-155v-52,-1,-78,121,-16,121v35,0,49,-41,51,-78v0,-23,-13,-43,-35,-43","w":219},"c":{"d":"72,-70v0,55,62,35,69,0r49,8v-14,39,-44,65,-91,66v-48,1,-77,-31,-77,-79v0,-88,90,-148,159,-99v14,10,20,27,22,46r-48,5v-1,-19,-12,-31,-30,-31v-37,0,-53,44,-53,84"},"d":{"d":"21,-74v0,-56,37,-119,93,-117v25,0,43,10,56,30r20,-97r51,0r-54,258r-48,0r4,-20v-39,46,-122,23,-122,-54xm121,-154v-49,0,-77,116,-16,121v54,1,75,-114,16,-121","w":219},"e":{"d":"125,-191v59,0,86,54,71,113r-126,0v-9,47,58,64,75,20r45,8v-15,32,-42,54,-84,54v-50,1,-85,-35,-85,-86v0,-61,43,-109,104,-109xm154,-108v6,-43,-37,-61,-63,-35v-8,8,-13,20,-16,35r79,0"},"f":{"d":"144,-187r-7,37r-36,0r-31,150r-51,0r32,-150r-29,0r8,-37r28,0v8,-43,15,-75,63,-75v15,0,31,2,48,8r-9,36v-25,-8,-47,-13,-48,18r-3,13r35,0","w":119,"k":{"\u2019":-7,"f":7}},"g":{"d":"166,48v-32,46,-171,42,-154,-38r53,8v0,34,59,24,65,0r9,-39v-46,45,-120,17,-117,-54v3,-63,32,-116,90,-116v28,0,48,17,58,37r7,-33r47,0r-32,156v-9,39,-11,57,-26,79xm120,-155v-47,0,-74,112,-15,118v53,1,74,-112,15,-118","w":219},"h":{"d":"158,-111v16,-38,-16,-54,-42,-35v-36,25,-36,94,-50,146r-51,0r54,-258r51,0r-20,92v30,-32,116,-38,113,22v-3,46,-20,99,-28,144r-51,0","w":219},"i":{"d":"68,-258r51,0r-10,46r-50,0xm53,-187r51,0r-39,187r-51,0","w":100},"j":{"d":"69,-258r50,0r-9,46r-51,0xm54,-187r50,0v-16,69,-33,190,-57,240v-12,26,-56,28,-86,17r8,-42v45,9,41,-8,52,-60","w":100},"k":{"d":"14,0r54,-258r50,0r-28,134r66,-63r65,0r-75,68r40,119r-50,0r-26,-86r-34,30r-12,56r-50,0"},"l":{"d":"14,0r54,-258r50,0r-53,258r-51,0","w":100},"m":{"d":"147,-113v21,-46,-30,-52,-48,-24v-21,32,-25,93,-36,137r-50,0r39,-187r47,0r-4,23v30,-35,93,-39,105,6v18,-37,117,-51,113,11v-3,47,-20,101,-29,147r-51,0r29,-138v-4,-28,-39,-17,-52,3v-18,28,-27,94,-37,135r-50,0","w":320},"n":{"d":"157,-106v18,-44,-12,-60,-42,-40v-36,24,-34,96,-49,146r-51,0r39,-187r48,0r-5,25v29,-35,119,-45,116,19v-2,43,-20,99,-28,143r-50,0","w":219},"o":{"d":"109,4v-53,0,-86,-31,-87,-82v-2,-66,42,-114,106,-113v54,0,87,32,88,84v0,60,-44,111,-107,111xm111,-35v55,0,82,-116,17,-118v-38,-1,-54,39,-56,75v0,24,15,43,39,43","w":219},"p":{"d":"218,-111v10,82,-96,159,-149,85r-20,97r-51,0r54,-258r48,0r-4,19v43,-44,132,-21,122,57xm133,-155v-54,-1,-74,116,-15,121v51,1,77,-118,15,-121","w":219},"q":{"d":"21,-73v6,-60,32,-117,93,-118v27,0,46,12,58,34r7,-30r46,0r-54,258r-50,0r18,-87v-41,41,-125,15,-118,-57xm121,-154v-51,-1,-76,116,-16,121v54,1,76,-115,16,-121","w":219},"r":{"d":"51,-187r47,0r-8,37v25,-34,43,-50,81,-36r-20,42v-72,-15,-74,81,-89,144r-50,0","w":140,"k":{"\u2019":-13,".":20,",":20}},"s":{"d":"168,-96v46,42,-6,100,-68,100v-52,0,-81,-19,-92,-56r49,-8v8,19,17,27,42,28v20,1,44,-12,31,-29v-37,-23,-94,-21,-94,-70v0,-76,153,-82,163,-11r-47,8v-4,-25,-69,-32,-69,-5v0,25,76,26,85,43"},"t":{"d":"107,2v-38,6,-81,1,-78,-36v2,-28,17,-83,23,-115r-25,0r8,-38r24,0r7,-30r57,-34r-13,64r31,0r-8,38r-31,0r-21,102v3,15,15,14,34,11","w":119},"u":{"d":"142,-25v-35,40,-117,44,-117,-19v0,-43,20,-100,28,-143r51,0r-28,136v11,41,65,4,71,-20v8,-33,17,-80,25,-116r51,0r-39,187r-47,0","w":219},"v":{"d":"108,0r-44,0r-37,-187r49,0r20,126r72,-126r55,0","k":{".":20,",":20}},"w":{"d":"210,0r-48,0r-9,-119r-57,119r-47,0r-23,-187r45,0r13,125r58,-125r46,0r6,125r58,-125r51,0","w":280,"k":{".":13,",":13}},"x":{"d":"100,-52r-46,52r-62,0r86,-96r-47,-91r54,0r27,54r47,-54r61,0r-86,97r47,90r-54,0"},"y":{"d":"30,-187r50,0r18,144v18,-49,48,-99,72,-144r53,0r-137,241v-15,22,-52,28,-84,16r5,-37v29,7,42,-4,56,-33","k":{".":13,",":13}},"z":{"d":"6,0r7,-34r102,-113r-83,0r8,-40r147,0r-6,30r-104,116r90,0r-8,41r-153,0","w":180},"{":{"d":"33,35v0,-32,37,-109,-18,-107r9,-42v91,-6,13,-166,152,-148r-8,42v-38,0,-37,2,-45,36v-14,56,-15,66,-52,91v34,14,13,86,9,112v3,14,11,15,32,15r-9,42v-41,1,-70,-3,-70,-41","w":140},"|":{"d":"31,76r0,-338r39,0r0,338r-39,0","w":100},"}":{"d":"113,-222v1,32,-38,110,18,108r-9,42v-90,5,-13,166,-153,148r10,-42v35,-2,36,-4,44,-36v12,-57,16,-68,52,-91v-35,-20,-14,-74,-10,-113v-2,-16,-10,-14,-32,-14r10,-42v40,-1,69,3,70,40","w":140},"~":{"d":"159,-91v-27,0,-64,-26,-87,-25v-16,0,-32,9,-48,25r0,-46v14,-15,27,-24,53,-24v46,0,98,49,134,-1r0,47v-10,10,-33,24,-52,24","w":210},"\u00c4":{"d":"128,-315r43,0r-9,43r-43,0xm202,-315r43,0r-9,43r-43,0xm184,-57r-103,0r-31,57r-54,0r146,-258r59,0r41,258r-50,0xm177,-100r-15,-104r-62,104r77,0","w":259},"\u00c5":{"d":"171,-240v-17,0,-34,-17,-34,-34v0,-17,16,-33,34,-33v18,0,34,16,34,33v0,17,-17,34,-34,34xm171,-288v-8,0,-15,7,-15,14v0,7,7,15,15,15v8,0,15,-7,15,-15v0,-8,-7,-14,-15,-14xm184,-54r-103,0r-31,57r-54,0r146,-258r59,0r41,258r-50,0xm177,-97r-15,-104r-62,104r77,0","w":259},"\u00d6":{"d":"125,-315r43,0r-9,43r-43,0xm199,-315r43,0r-9,43r-43,0xm137,5v-66,0,-106,-44,-106,-106v0,-91,50,-159,145,-161v62,-1,108,44,106,108v-3,88,-55,159,-145,159xm171,-218v-53,-1,-87,63,-87,116v0,35,24,63,59,62v54,-2,83,-59,86,-113v1,-37,-23,-64,-58,-65","w":280},"\u00dc":{"d":"122,-315r43,0r-9,43r-43,0xm196,-315r43,0r-9,43r-43,0xm225,-49v-33,80,-215,69,-191,-41r35,-168r53,0r-37,183v-3,34,49,45,75,28v23,-15,25,-32,33,-70r30,-141r52,0v-16,66,-28,154,-50,209","w":259},"\u00e1":{"d":"150,-263r54,0r-57,53r-33,0xm143,-136v-2,-28,-55,-24,-57,2r-50,-4v12,-34,39,-52,85,-53v42,-1,70,16,71,50v1,36,-29,100,-15,141r-49,0v-2,-7,-4,-14,-4,-21v-26,39,-112,31,-108,-29v3,-43,27,-59,76,-62v24,-2,40,-4,48,-7v2,-7,3,-13,3,-17xm64,-54v0,33,51,21,59,1v3,-7,8,-22,11,-34v-32,7,-70,4,-70,33"},"\u00e0":{"d":"143,-136v-2,-28,-55,-24,-57,2r-50,-4v12,-34,39,-52,85,-53v42,-1,70,16,71,50v1,36,-29,100,-15,141r-49,0v-2,-7,-4,-14,-4,-21v-26,39,-112,31,-108,-29v3,-43,27,-59,76,-62v24,-2,40,-4,48,-7v2,-7,3,-13,3,-17xm64,-54v0,33,51,21,59,1v3,-7,8,-22,11,-34v-32,7,-70,4,-70,33xm91,-263r49,0r22,52r-34,0"},"\u00e2":{"d":"139,-242r-31,32r-42,0r52,-53r48,0r21,53r-35,0xm143,-136v-2,-28,-55,-24,-57,2r-50,-4v12,-34,39,-52,85,-53v42,-1,70,16,71,50v1,36,-29,100,-15,141r-49,0v-2,-7,-4,-14,-4,-21v-26,39,-112,31,-108,-29v3,-43,27,-59,76,-62v24,-2,40,-4,48,-7v2,-7,3,-13,3,-17xm64,-54v0,33,51,21,59,1v3,-7,8,-22,11,-34v-32,7,-70,4,-70,33"},"\u00e4":{"d":"82,-258r43,0r-9,43r-43,0xm156,-258r43,0r-9,43r-43,0xm143,-136v-2,-28,-55,-24,-57,2r-50,-4v12,-34,39,-52,85,-53v42,-1,70,16,71,50v1,36,-29,100,-15,141r-49,0v-2,-7,-4,-14,-4,-21v-26,39,-112,31,-108,-29v3,-43,27,-59,76,-62v24,-2,40,-4,48,-7v2,-7,3,-13,3,-17xm64,-54v0,33,51,21,59,1v3,-7,8,-22,11,-34v-32,7,-70,4,-70,33"},"\u00e3":{"d":"162,-214v-17,1,-58,-32,-63,1r-22,0v5,-25,13,-40,35,-43v6,-1,41,14,51,14v8,0,9,-5,12,-14r23,0v-2,23,-15,41,-36,42xm143,-136v-2,-28,-55,-24,-57,2r-50,-4v12,-34,39,-52,85,-53v42,-1,70,16,71,50v1,36,-29,100,-15,141r-49,0v-2,-7,-4,-14,-4,-21v-26,39,-112,31,-108,-29v3,-43,27,-59,76,-62v24,-2,40,-4,48,-7v2,-7,3,-13,3,-17xm64,-54v0,33,51,21,59,1v3,-7,8,-22,11,-34v-32,7,-70,4,-70,33"},"\u00e5":{"d":"128,-204v-18,0,-33,-16,-33,-33v0,-17,16,-34,33,-34v17,0,34,17,34,34v0,17,-16,33,-34,33xm128,-252v-8,0,-14,7,-14,15v0,7,7,14,14,14v8,0,15,-6,15,-14v0,-8,-7,-15,-15,-15xm143,-136v-2,-28,-55,-24,-57,2r-50,-4v12,-34,39,-52,85,-53v42,-1,70,16,71,50v1,36,-29,100,-15,141r-49,0v-2,-7,-4,-14,-4,-21v-26,39,-112,31,-108,-29v3,-43,27,-59,76,-62v24,-2,40,-4,48,-7v2,-7,3,-13,3,-17xm64,-54v0,33,51,21,59,1v3,-7,8,-22,11,-34v-32,7,-70,4,-70,33"},"\u00e7":{"d":"142,32v0,36,-49,42,-94,41v6,-8,3,-24,19,-21v17,-1,41,-2,43,-18v-2,-13,-20,-14,-36,-10r6,-18v28,-8,62,0,62,26xm72,-70v0,55,62,35,69,0r49,8v-14,39,-44,65,-91,66v-48,1,-77,-31,-77,-79v0,-88,90,-148,159,-99v14,10,20,27,22,46r-48,5v-1,-19,-12,-31,-30,-31v-37,0,-53,44,-53,84"},"\u00e9":{"d":"149,-263r53,0r-57,53r-33,0xm125,-191v59,0,86,54,71,113r-126,0v-9,47,58,64,75,20r45,8v-15,32,-42,54,-84,54v-50,1,-85,-35,-85,-86v0,-61,43,-109,104,-109xm154,-108v6,-43,-37,-61,-63,-35v-8,8,-13,20,-16,35r79,0"},"\u00e8":{"d":"125,-191v59,0,86,54,71,113r-126,0v-9,47,58,64,75,20r45,8v-15,32,-42,54,-84,54v-50,1,-85,-35,-85,-86v0,-61,43,-109,104,-109xm154,-108v6,-43,-37,-61,-63,-35v-8,8,-13,20,-16,35r79,0xm89,-263r49,0r22,52r-34,0"},"\u00ea":{"d":"139,-242r-31,32r-42,0r53,-53r47,0r21,53r-35,0xm125,-191v59,0,86,54,71,113r-126,0v-9,47,58,64,75,20r45,8v-15,32,-42,54,-84,54v-50,1,-85,-35,-85,-86v0,-61,43,-109,104,-109xm154,-108v6,-43,-37,-61,-63,-35v-8,8,-13,20,-16,35r79,0"},"\u00ed":{"d":"53,-187r51,0r-39,187r-51,0xm95,-263r54,0r-57,53r-34,0","w":100},"\u00ec":{"d":"53,-187r51,0r-39,187r-51,0xm54,-263r49,0r22,52r-34,0","w":100},"\u00ee":{"d":"92,-242r-31,32r-41,0r52,-53r47,0r21,53r-35,0xm53,-187r51,0r-39,187r-51,0","w":100},"\u00ef":{"d":"53,-187r51,0r-39,187r-51,0xm33,-258r43,0r-9,43r-43,0xm107,-258r43,0r-9,43r-43,0","w":100},"\u00f1":{"d":"170,-214v-17,2,-59,-33,-63,1r-22,0v5,-25,13,-40,34,-43v6,-1,41,14,52,14v8,0,9,-5,12,-14r22,0v-2,23,-14,41,-35,42xm157,-106v18,-44,-12,-60,-42,-40v-36,24,-34,96,-49,146r-51,0r39,-187r48,0r-5,25v29,-35,119,-45,116,19v-2,43,-20,99,-28,143r-50,0","w":219},"\u00f3":{"d":"139,-263r54,0r-57,53r-34,0xm109,4v-53,0,-86,-31,-87,-82v-2,-66,42,-114,106,-113v54,0,87,32,88,84v0,60,-44,111,-107,111xm111,-35v55,0,82,-116,17,-118v-38,-1,-54,39,-56,75v0,24,15,43,39,43","w":219},"\u00f2":{"d":"109,4v-53,0,-86,-31,-87,-82v-2,-66,42,-114,106,-113v54,0,87,32,88,84v0,60,-44,111,-107,111xm111,-35v55,0,82,-116,17,-118v-38,-1,-54,39,-56,75v0,24,15,43,39,43xm97,-263r49,0r22,52r-34,0","w":219},"\u00f4":{"d":"147,-242r-31,32r-41,0r52,-53r47,0r21,53r-34,0xm109,4v-53,0,-86,-31,-87,-82v-2,-66,42,-114,106,-113v54,0,87,32,88,84v0,60,-44,111,-107,111xm111,-35v55,0,82,-116,17,-118v-38,-1,-54,39,-56,75v0,24,15,43,39,43","w":219},"\u00f6":{"d":"84,-258r43,0r-9,43r-43,0xm158,-258r43,0r-9,43r-43,0xm109,4v-53,0,-86,-31,-87,-82v-2,-66,42,-114,106,-113v54,0,87,32,88,84v0,60,-44,111,-107,111xm111,-35v55,0,82,-116,17,-118v-38,-1,-54,39,-56,75v0,24,15,43,39,43","w":219},"\u00f5":{"d":"163,-214v-17,2,-59,-32,-64,1r-22,0v6,-24,14,-39,35,-43v6,-1,41,14,52,14v8,0,9,-5,12,-14r22,0v-2,23,-14,41,-35,42xm109,4v-53,0,-86,-31,-87,-82v-2,-66,42,-114,106,-113v54,0,87,32,88,84v0,60,-44,111,-107,111xm111,-35v55,0,82,-116,17,-118v-38,-1,-54,39,-56,75v0,24,15,43,39,43","w":219},"\u00fa":{"d":"147,-263r54,0r-57,53r-33,0xm142,-25v-35,40,-117,44,-117,-19v0,-43,20,-100,28,-143r51,0r-28,136v11,41,65,4,71,-20v8,-33,17,-80,25,-116r51,0r-39,187r-47,0","w":219},"\u00f9":{"d":"142,-25v-35,40,-117,44,-117,-19v0,-43,20,-100,28,-143r51,0r-28,136v11,41,65,4,71,-20v8,-33,17,-80,25,-116r51,0r-39,187r-47,0xm104,-263r49,0r22,52r-34,0","w":219},"\u00fb":{"d":"149,-242r-31,32r-41,0r52,-53r47,0r21,53r-34,0xm142,-25v-35,40,-117,44,-117,-19v0,-43,20,-100,28,-143r51,0r-28,136v11,41,65,4,71,-20v8,-33,17,-80,25,-116r51,0r-39,187r-47,0","w":219},"\u00fc":{"d":"94,-258r44,0r-9,43r-44,0xm168,-258r44,0r-9,43r-44,0xm142,-25v-35,40,-117,44,-117,-19v0,-43,20,-100,28,-143r51,0r-28,136v11,41,65,4,71,-20v8,-33,17,-80,25,-116r51,0r-39,187r-47,0","w":219},"\u00a3":{"d":"192,-6v-57,32,-127,-28,-179,13r-6,-46v28,-13,51,-34,56,-69r-41,0r8,-40r29,0v-27,-87,73,-148,138,-95v15,12,21,30,23,51r-45,4v-3,-22,-12,-35,-33,-35v-33,0,-47,37,-37,75r44,0r-8,40r-34,0v-4,34,-15,47,-38,69v34,-16,74,11,107,-10"},"\u00df":{"d":"156,-208v-2,-23,-36,-20,-44,-1v-23,53,-33,145,-49,209r-50,0v17,-71,30,-158,51,-220v17,-48,144,-64,145,7v1,32,-35,48,-39,74v4,26,39,47,39,80v0,70,-100,81,-129,29r36,-20v8,19,45,16,43,-8v-3,-30,-40,-47,-40,-77v0,-28,32,-45,37,-73","w":219},"\u2122":{"d":"97,-114r0,-119r-45,0r0,-25r117,0r0,25r-43,0r0,119r-29,0xm186,-114r0,-144r46,0r26,99r26,-99r46,0r0,144r-28,0r0,-115r-31,115r-26,0r-31,-115r0,115r-28,0","w":360},"\u00e6":{"d":"174,-168v47,-47,138,-20,138,57v0,11,-2,23,-4,34r-128,0v-2,47,60,59,77,19r46,8v-29,65,-126,75,-156,11v-22,29,-47,43,-77,43v-65,0,-79,-89,-23,-108v17,-6,81,-9,92,-16v4,-22,-5,-36,-27,-35v-19,1,-27,6,-32,22r-48,-5v6,-52,110,-74,142,-30xm266,-108v6,-43,-37,-60,-64,-35v-9,8,-15,20,-18,35r82,0xm57,-55v0,26,38,25,53,9v10,-11,19,-25,22,-42v-45,8,-68,3,-75,33","w":320},"\u00f8":{"d":"40,-23v-61,-82,31,-211,136,-157r22,-26r19,17r-21,25v60,80,-31,211,-136,157r-22,26r-19,-17xm149,-149v-52,-24,-90,39,-78,91xm87,-38v53,23,91,-38,78,-90","w":219},"\u00bf":{"d":"160,-138r-50,0r10,-49r50,0xm10,11v-3,-59,90,-76,99,-133r46,0v-1,62,-84,85,-98,135v0,17,15,26,35,25v31,0,43,-17,50,-45r46,9v-11,43,-46,73,-97,73v-46,0,-79,-25,-81,-64","w":219},"\u00ab":{"d":"101,-97r69,-75r43,0r-63,79r23,81r-36,0xm30,-97r72,-75r42,0r-63,78r23,82r-35,0"},"\u00bb":{"d":"119,-87r-68,75r-43,0r62,-79r-22,-81r36,0xm191,-87r-72,75r-43,0r64,-79r-23,-81r35,0"},"\u2026":{"d":"44,-49r50,0r-11,49r-50,0xm160,-49r50,0r-10,49r-50,0xm277,-49r50,0r-11,49r-49,0","w":360},"\u2013":{"d":"-1,-75r0,-37r201,0r0,37r-201,0"},"\u2014":{"d":"0,-75r0,-37r360,0r0,37r-360,0","w":360},"\u201c":{"d":"181,-156r-51,0v10,-50,16,-107,73,-105r-5,24v-17,4,-27,13,-30,32r23,0xm96,-156r-51,0v10,-50,17,-106,73,-105r-5,24v-17,4,-27,13,-30,32r23,0","w":180},"\u201d":{"d":"68,-258r51,0v-9,51,-17,106,-73,105r5,-23v18,-4,27,-13,30,-33r-23,0xm153,-258r51,0v-11,49,-16,106,-73,105r5,-23v17,-4,26,-14,30,-33r-23,0","w":180},"\u2018":{"d":"90,-156r-51,0v11,-49,16,-106,73,-105r-5,24v-17,4,-26,14,-30,32r23,0","w":100,"k":{"\u2018":13}},"\u2019":{"d":"66,-258r51,0v-9,50,-16,106,-73,105r5,-23v18,-4,27,-13,30,-33r-23,0","w":100,"k":{"\u2019":13,"t":-7,"s":7," ":13}},"\u00ff":{"d":"79,-258r43,0r-9,43r-43,0xm153,-258r43,0r-9,43r-43,0xm30,-187r50,0r18,144v18,-49,48,-99,72,-144r53,0r-137,241v-15,22,-52,28,-84,16r5,-37v29,7,42,-4,56,-33"},"\u20ac":{"d":"44,-168v16,-68,112,-122,186,-78r-19,48v-32,-35,-95,-17,-111,30r87,0r-5,27r-91,0v-1,4,-1,11,-3,23r90,0r-6,28r-86,0v2,49,71,65,106,33r-11,53v-73,28,-145,-13,-147,-86r-24,0r5,-28r20,0v0,-6,1,-13,2,-23r-27,0r5,-27r29,0"},"\u0142":{"d":"43,-135r26,-123r50,0r-19,94r19,-10r-7,34r-20,10r-27,130r-50,0r21,-102r-25,14r7,-34","w":100},"\u00d7":{"d":"34,-74r53,-53r-54,-53r33,-33r53,53r53,-53r32,32r-53,53r54,54r-33,33r-54,-54r-53,53","w":210},"\u0107":{"d":"134,-263r54,0r-57,53r-34,0xm72,-70v0,55,62,35,69,0r49,8v-14,39,-44,65,-91,66v-48,1,-77,-31,-77,-79v0,-88,90,-148,159,-99v14,10,20,27,22,46r-48,5v-1,-19,-12,-31,-30,-31v-37,0,-53,44,-53,84"},"\u0105":{"d":"166,0v-10,6,-35,37,-10,41r15,-3r-6,29v-25,13,-61,9,-61,-19v0,-19,19,-38,33,-48r29,0xm143,-136v-2,-28,-55,-24,-57,2r-50,-4v12,-34,39,-52,85,-53v42,-1,70,16,71,50v1,36,-29,100,-15,141r-49,0v-2,-7,-4,-14,-4,-21v-26,39,-112,31,-108,-29v3,-43,27,-59,76,-62v24,-2,40,-4,48,-7v2,-7,3,-13,3,-17xm64,-54v0,33,51,21,59,1v3,-7,8,-22,11,-34v-32,7,-70,4,-70,33"},"\u0119":{"d":"133,0v-10,6,-35,37,-10,41r15,-3r-6,29v-24,12,-59,10,-60,-19v0,-19,18,-38,32,-48r29,0xm125,-191v59,0,86,54,71,113r-126,0v-9,47,58,64,75,20r45,8v-15,32,-42,54,-84,54v-50,1,-85,-35,-85,-86v0,-61,43,-109,104,-109xm154,-108v6,-43,-37,-61,-63,-35v-8,8,-13,20,-16,35r79,0"},"\u0151":{"d":"173,-262r51,0r-58,52r-28,0xm103,-262r52,0r-59,52r-28,0xm109,4v-53,0,-86,-31,-87,-82v-2,-66,42,-114,106,-113v54,0,87,32,88,84v0,60,-44,111,-107,111xm111,-35v55,0,82,-116,17,-118v-38,-1,-54,39,-56,75v0,24,15,43,39,43","w":219},"\u015b":{"d":"129,-263r54,0r-57,53r-34,0xm168,-96v46,42,-6,100,-68,100v-52,0,-81,-19,-92,-56r49,-8v8,19,17,27,42,28v20,1,44,-12,31,-29v-37,-23,-94,-21,-94,-70v0,-76,153,-82,163,-11r-47,8v-4,-25,-69,-32,-69,-5v0,25,76,26,85,43"},"\u0171":{"d":"184,-262r51,0r-58,52r-29,0xm114,-262r52,0r-59,52r-28,0xm142,-25v-35,40,-117,44,-117,-19v0,-43,20,-100,28,-143r51,0r-28,136v11,41,65,4,71,-20v8,-33,17,-80,25,-116r51,0r-39,187r-47,0","w":219},"\u017a":{"d":"118,-263r54,0r-57,53r-34,0xm6,0r7,-34r102,-113r-83,0r8,-40r147,0r-6,30r-104,116r90,0r-8,41r-153,0","w":180},"\u017c":{"d":"96,-262r51,0r-10,46r-51,0xm6,0r7,-34r102,-113r-83,0r8,-40r147,0r-6,30r-104,116r90,0r-8,41r-153,0","w":180},"\u2032":{"d":"54,-166v-1,-35,3,-65,11,-92r53,0v-5,34,-15,64,-27,92r-37,0","w":86},"\u2033":{"d":"54,-166v-1,-35,3,-65,11,-92r53,0v-5,34,-15,64,-27,92r-37,0xm118,-166v-1,-35,3,-65,11,-92r53,0v-5,34,-15,64,-27,92r-37,0","w":172}}});
