/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 *  2007 The Monotype Corporation. All Rights Reserved.
 * 
 * Trademark:
 * Arial is a trademark of The Monotype Corporation in the United States and/or
 * other countries.
 * 
 * Description:
 * Monotype Drawing Office 1982. A contemporary sans serif design, Arial contains
 * more humanist characteristics than many of its predecessors and as such is more
 * in tune with the mood of the last decades of the twentieth century. The overall
 * treatment of curves is softer and fuller than in most industrial-style sans
 * serif faces. Terminal strokes are cut on the diagonal which helps to give the
 * face a less mechanical appearance. Arial is an extremely versatile family of
 * typefaces which can be used with equal success for text setting in reports,
 * presentations, magazines etc, and for display use in newspapers, advertising and
 * promotions.
 * 
 * Manufacturer:
 * The Monotype Corporation
 * 
 * Designer:
 * Robin Nicholas, Patricia Saunders
 */
Cufon.registerFont({"w":164,"face":{"font-family":"Arial Narrow","font-weight":400,"font-stretch":"condensed","units-per-em":"360","panose-1":"2 11 6 6 2 2 2 3 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-14 -332 295 76.2352","underline-thickness":"26.3672","underline-position":"-24.9609","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":82,"k":{"Y":5,"T":5,"A":16}},"\u00a0":{"w":82},"!":{"d":"34,-64r-8,-137r0,-57r32,0v1,68,-4,130,-7,194r-17,0xm27,0r0,-36r30,0r0,36r-30,0","w":82},"\"":{"d":"21,-166v-5,-28,-10,-57,-8,-92r30,0v1,34,-2,64,-7,92r-15,0xm68,-166v-4,-29,-9,-57,-7,-92r30,0v1,34,-2,64,-7,92r-16,0","w":104},"#":{"d":"14,4r13,-74r-24,0r0,-27r28,0r11,-63r-39,0r0,-27r43,0r13,-75r22,0r-13,75r45,0r13,-75r22,0r-13,75r25,0r0,27r-29,0r-11,63r40,0r0,27r-44,0r-13,74r-22,0r13,-74r-45,0r-13,74r-22,0xm53,-97r45,0r11,-63r-45,0"},"$":{"d":"150,-73v1,42,-26,75,-62,78r0,32r-15,0r0,-32v-44,-5,-58,-33,-63,-77r26,-6v3,30,14,52,37,57r0,-101v-31,-8,-60,-30,-58,-73v1,-41,19,-67,58,-71r0,-15r15,0r0,15v36,4,51,28,57,63r-27,5v-3,-24,-13,-38,-30,-42r0,92v41,10,59,29,62,75xm73,-240v-42,6,-45,78,0,88r0,-88xm88,-21v29,-2,45,-51,28,-78v-5,-7,-15,-14,-28,-19r0,97"},"%":{"d":"61,-126v-30,0,-44,-31,-44,-70v0,-37,15,-66,44,-66v31,0,46,29,46,68v0,37,-15,68,-46,68xm62,-148v31,0,32,-91,0,-92v-32,0,-32,92,0,92xm62,9r115,-271r21,0r-115,271r-21,0xm198,9v-30,0,-45,-31,-45,-69v0,-36,15,-67,44,-67v31,0,47,29,47,68v0,36,-15,68,-46,68xm199,-12v31,0,32,-95,-1,-93v-19,1,-22,20,-22,46v0,27,3,47,23,47","w":262},"&":{"d":"92,-262v29,0,50,25,49,55v0,24,-13,46,-40,63r38,59v4,-10,7,-22,10,-36r27,7v-5,22,-11,40,-19,55v9,15,21,29,33,40r-17,25v-10,-8,-22,-20,-33,-36v-17,23,-37,34,-60,34v-40,0,-67,-38,-67,-75v0,-32,16,-58,50,-77v-14,-21,-23,-31,-24,-57v-1,-30,23,-57,53,-57xm91,-236v-39,3,-23,56,-3,71v29,-11,38,-64,3,-71xm41,-73v-2,32,32,66,63,41v8,-6,15,-13,20,-23r-47,-72v-21,15,-35,27,-36,54","w":196},"'":{"d":"19,-166v-5,-28,-8,-58,-7,-92r30,0v1,34,-2,64,-7,92r-16,0","w":56},"(":{"d":"88,-262v-56,100,-59,230,0,338r-19,0v-59,-87,-73,-238,0,-338r19,0","w":98},")":{"d":"29,-262v73,101,62,248,0,338r-18,0v59,-108,54,-238,0,-338r18,0","w":98},"*":{"d":"9,-210r6,-25v15,7,27,12,34,17v-2,-22,-3,-36,-3,-44r21,0v0,11,-2,26,-4,44v10,-6,21,-12,34,-17r7,25v-12,5,-24,7,-36,9v6,6,14,18,25,34r-17,15v-5,-9,-12,-22,-20,-38v-7,17,-14,29,-19,38r-17,-15v11,-16,19,-28,24,-34v-13,-3,-24,-5,-35,-9","w":114},"+":{"d":"74,-42r0,-70r-58,0r0,-30r58,0r0,-70r24,0r0,70r58,0r0,30r-58,0r0,70r-24,0","w":172},",":{"d":"27,0r0,-36r29,0v0,37,3,76,-24,87r-7,-14v12,-6,17,-17,16,-37r-14,0","w":82},"-":{"d":"9,-77r0,-32r80,0r0,32r-80,0","w":98},"\u00ad":{"d":"9,-77r0,-32r80,0r0,32r-80,0","w":98},".":{"d":"27,0r0,-36r30,0r0,36r-30,0","w":82},"\/":{"d":"0,4r61,-266r21,0r-61,266r-21,0","w":82},"0":{"d":"81,4v-56,0,-70,-56,-69,-131v0,-71,12,-132,69,-132v57,0,69,60,69,132v0,70,-12,131,-69,131xm80,-233v-38,9,-42,45,-42,106v0,63,3,97,43,105v38,-8,42,-44,42,-105v0,-63,-3,-97,-43,-106"},"1":{"d":"32,-194v25,-13,51,-40,61,-65r17,0r0,259r-27,0r0,-202v-11,14,-35,31,-51,39r0,-31","k":{"1":22}},"2":{"d":"148,-187v0,70,-77,106,-103,157r104,0r0,30r-140,0v2,-80,108,-114,113,-188v1,-24,-18,-45,-40,-45v-26,0,-43,22,-42,52r-26,-3v3,-46,25,-73,69,-75v42,-2,65,34,65,72"},"3":{"d":"150,-76v4,64,-73,108,-117,61v-13,-13,-19,-31,-21,-53r26,-4v4,74,85,57,85,-4v0,-34,-27,-60,-60,-46r3,-28v27,5,47,-17,47,-43v0,-22,-14,-40,-34,-40v-24,0,-36,21,-39,47r-25,-6v5,-38,25,-64,63,-67v61,-4,84,94,33,119v26,7,37,31,39,64"},"4":{"d":"95,0r0,-62r-92,0r0,-29r97,-167r21,0r0,167r29,0r0,29r-29,0r0,62r-26,0xm95,-91r0,-116r-66,116r66,0"},"5":{"d":"152,-87v0,67,-68,121,-119,72v-13,-13,-19,-31,-21,-53r27,-2v3,27,15,48,40,48v28,0,47,-29,45,-63v9,-56,-63,-77,-83,-33r-25,-4r21,-132r105,0r0,30r-84,0r-12,69v48,-42,106,6,106,68"},"6":{"d":"11,-121v0,-80,16,-138,75,-138v35,0,58,27,60,64r-25,3v-3,-45,-55,-56,-73,-13v-7,16,-12,40,-12,72v10,-18,28,-34,52,-34v83,0,83,174,-4,171v-56,-2,-73,-52,-73,-125xm82,-139v-59,1,-52,117,2,117v54,-1,53,-119,-2,-117"},"7":{"d":"43,0v3,-85,36,-172,74,-224r-103,0r0,-30r136,0r0,24v-38,50,-76,147,-80,230r-27,0"},"8":{"d":"81,4v-74,8,-95,-126,-29,-144v-55,-20,-33,-126,29,-119v61,-7,84,98,30,119v65,20,46,152,-30,144xm81,-233v-18,0,-34,20,-34,40v0,22,13,41,34,41v19,0,35,-17,35,-40v0,-21,-16,-41,-35,-41xm81,-126v-26,0,-43,25,-43,52v0,28,17,52,43,52v26,-1,43,-22,43,-51v0,-28,-17,-53,-43,-53"},"9":{"d":"151,-134v-1,76,-12,138,-76,138v-36,0,-57,-27,-59,-64r25,-2v4,27,16,40,35,40v42,0,47,-53,49,-99v-8,17,-28,34,-50,34v-39,0,-63,-39,-63,-85v0,-47,25,-87,66,-87v58,0,74,54,73,125xm81,-115v26,0,41,-26,41,-58v0,-31,-15,-60,-41,-60v-53,1,-60,118,0,118"},":":{"d":"27,-151r0,-36r30,0r0,36r-30,0xm27,0r0,-36r30,0r0,36r-30,0","w":82},";":{"d":"27,-151r0,-36r29,0r0,36r-29,0xm27,0r0,-36r29,0v0,37,3,76,-24,87r-7,-14v12,-6,17,-17,16,-37r-14,0","w":82},"\u037e":{"d":"27,-151r0,-36r29,0r0,36r-29,0xm27,0r0,-36r29,0v0,37,3,76,-24,87r-7,-14v12,-6,17,-17,16,-37r-14,0","w":82},"<":{"d":"16,-113r0,-29r140,-72r0,31r-111,56r111,56r0,31","w":172},"=":{"d":"156,-152r-140,0r0,-29r140,0r0,29xm156,-73r-140,0r0,-30r140,0r0,30","w":172},">":{"d":"156,-113r-140,73r0,-31r111,-56r-111,-56r0,-31r140,72r0,29","w":172},"?":{"d":"149,-192v0,59,-62,64,-57,129r-24,0v-12,-65,49,-76,54,-127v2,-24,-17,-47,-40,-46v-27,1,-40,22,-43,52r-27,-4v5,-44,25,-74,69,-74v38,0,68,31,68,70xm66,0r0,-36r29,0r0,36r-29,0"},"@":{"d":"195,1v-21,0,-26,-10,-28,-30v-11,15,-25,28,-44,30v-87,-15,-56,-192,23,-192v20,0,34,15,43,33r5,-27r26,0r-25,145v0,6,4,11,10,11v33,-8,55,-55,55,-97v0,-65,-40,-111,-102,-111v-80,0,-121,69,-121,152v0,85,43,133,125,135v46,0,84,-23,101,-53r26,0v-22,43,-62,79,-127,79v-96,-2,-146,-61,-146,-158v0,-98,45,-180,143,-180v78,0,120,59,123,136v2,55,-37,124,-87,127xm147,-164v-50,0,-73,125,-19,139v34,-5,52,-49,53,-89v1,-27,-12,-50,-34,-50","w":299},"A":{"d":"0,0r81,-258r30,0r86,258r-32,0r-24,-78r-88,0r-24,78r-29,0xm61,-106r71,0r-37,-125v-7,45,-22,84,-34,125","w":196,"k":{"\u2019":22,"y":5,"w":5,"v":5,"Y":22,"W":11,"V":22,"T":22," ":16}},"B":{"d":"181,-75v-2,50,-26,75,-79,75r-80,0r0,-258r79,0v73,-9,90,92,41,121v23,8,40,30,39,62xm144,-188v0,-46,-47,-39,-94,-39r0,78v45,-1,94,8,94,-39xm152,-75v0,-51,-52,-44,-102,-44r0,89v50,0,102,7,102,-45","w":196},"C":{"d":"111,-25v37,0,56,-28,62,-65r28,8v-10,50,-37,86,-89,86v-73,0,-93,-61,-98,-135v-6,-95,78,-167,152,-112v16,12,25,31,31,56r-27,8v-9,-36,-29,-54,-57,-54v-52,0,-69,45,-70,102v0,59,18,106,68,106","w":213},"D":{"d":"197,-130v0,75,-24,130,-99,130r-76,0r0,-258r73,0v80,-2,102,53,102,128xm168,-131v0,-59,-13,-98,-74,-96r-44,0r0,197r45,0v61,2,73,-44,73,-101","w":213},"E":{"d":"23,0r0,-258r153,0r0,31r-125,0r0,79r117,0r0,30r-117,0r0,88r130,0r0,30r-158,0","w":196},"F":{"d":"25,0r0,-258r142,0r0,31r-114,0r0,80r99,0r0,30r-99,0r0,117r-28,0","w":180,"k":{"A":16,".":33,",":33}},"G":{"d":"123,-26v23,0,50,-14,61,-27r0,-48r-62,0r0,-30r90,0r0,95v-23,21,-50,40,-88,40v-73,0,-107,-55,-108,-132v-2,-89,59,-160,147,-125v26,11,39,33,45,67r-25,9v-7,-37,-23,-56,-61,-56v-55,0,-76,44,-77,103v0,60,25,102,78,104","w":229},"H":{"d":"23,0r0,-258r28,0r0,106r109,0r0,-106r28,0r0,258r-28,0r0,-121r-109,0r0,121r-28,0","w":213},"I":{"d":"28,0r0,-258r28,0r0,258r-28,0","w":82},"J":{"d":"124,-82v0,55,-13,86,-59,86v-43,0,-56,-31,-57,-77r25,-4v2,33,6,48,32,51v26,-3,31,-23,31,-54r0,-178r28,0r0,176","w":147},"K":{"d":"22,0r0,-258r28,0r0,128r105,-128r38,0r-89,105r93,153r-37,0r-76,-130r-34,41r0,89r-28,0","w":196},"L":{"d":"21,0r0,-258r28,0r0,228r104,0r0,30r-132,0","k":{"\u2019":16,"y":11,"Y":22,"W":22,"V":22,"T":22," ":11}},"M":{"d":"22,0r0,-258r42,0r60,221r62,-221r38,0r0,258r-27,0r0,-216r-62,216r-25,0r-61,-219r0,219r-27,0","w":245},"N":{"d":"22,0r0,-258r29,0r111,203r0,-203r26,0r0,258r-28,0r-111,-202r0,202r-27,0","w":213},"O":{"d":"116,4v-63,0,-101,-64,-101,-130v0,-76,35,-136,101,-136v68,0,100,58,101,133v1,71,-36,133,-101,133xm116,-233v-51,0,-72,46,-72,108v0,54,26,100,72,100v49,0,72,-47,72,-104v0,-56,-20,-104,-72,-104","w":229},"P":{"d":"184,-184v0,49,-24,81,-79,79r-54,0r0,105r-28,0r0,-258r79,0v58,-2,82,23,82,74xm155,-182v0,-53,-51,-46,-104,-45r0,92v51,1,104,7,104,-47","w":196,"k":{"A":22,".":38,",":38," ":5}},"Q":{"d":"115,-262v108,-4,126,167,69,234v13,11,25,19,36,24r-9,24v-15,-7,-30,-18,-45,-32v-79,51,-157,-26,-153,-117v4,-74,32,-130,102,-133xm42,-129v0,68,39,123,101,97v-9,-7,-18,-11,-28,-14r7,-25v16,5,29,13,40,24v42,-48,33,-188,-47,-186v-49,1,-73,46,-73,104","w":229},"R":{"d":"192,-188v0,40,-23,66,-60,71v40,26,52,77,77,117r-35,0r-28,-54v-23,-45,-29,-65,-95,-60r0,114r-28,0r0,-258r93,0v53,-1,76,23,76,70xm163,-187v0,-52,-62,-41,-112,-42r0,85v51,0,112,10,112,-43","w":213,"k":{"Y":5,"W":5,"V":5,"T":5}},"S":{"d":"143,-137v67,33,39,142,-43,142v-52,0,-86,-36,-87,-88r27,-3v-9,69,115,83,115,16v0,-71,-134,-27,-134,-121v0,-75,113,-95,144,-35v7,12,10,25,10,41r-27,2v-2,-32,-19,-47,-51,-49v-39,-2,-63,35,-40,62v9,12,73,26,86,33","w":196},"T":{"d":"77,0r0,-227r-70,0r0,-31r168,0r0,31r-70,0r0,227r-28,0","w":180,"k":{"\u0119":33,"\u0105":33,"y":16,"w":16,"u":11,"s":25,"r":11,"o":33,"i":7,"e":33,"c":33,"a":33,"O":5,"A":22,";":33,":":33,".":33,"-":16,",":33," ":5}},"U":{"d":"104,-26v48,0,57,-26,57,-83r0,-149r28,0v-7,109,33,262,-83,262v-115,0,-76,-155,-83,-262r28,0r0,149v-2,54,9,83,53,83","w":213},"V":{"d":"83,0r-82,-258r31,0r66,230r68,-230r29,0r-83,258r-29,0","w":196,"k":{"\u0119":16,"\u0105":22,"y":11,"u":11,"r":11,"o":16,"i":5,"e":16,"a":22,"A":22,";":11,":":11,".":27,"-":16,",":27}},"W":{"d":"60,0r-56,-258r29,0r41,222r50,-222r33,0r31,131v7,32,12,62,16,91r44,-222r28,0r-58,258r-27,0r-51,-227r-51,227r-29,0","w":278,"k":{"\u0119":5,"\u0105":11,"y":2,"u":5,"r":5,"o":5,"e":5,"a":11,"A":11,";":5,":":5,".":16,"-":5,",":16}},"X":{"d":"1,0r82,-134r-72,-124r33,0r56,98v17,-34,40,-66,59,-98r30,0r-74,122r80,136r-34,0r-63,-109r-63,109r-34,0","w":196},"Y":{"d":"82,0r0,-109r-81,-149r34,0r63,122r64,-122r33,0r-85,149r0,109r-28,0","w":196,"k":{"\u0119":27,"\u0105":22,"v":16,"u":16,"q":27,"p":22,"o":27,"i":11,"e":27,"a":22,"A":22,";":19,":":16,".":38,"-":27,",":38," ":5}},"Z":{"d":"6,0r0,-32r131,-195r-119,0r0,-31r152,0r0,31r-132,197r135,0r0,30r-167,0","w":180},"[":{"d":"21,72r0,-330r57,0r0,26r-32,0r0,277r32,0r0,27r-57,0","w":82},"\\":{"d":"61,4r-61,-266r21,0r61,266r-21,0","w":82},"]":{"d":"64,72r-58,0r0,-27r32,0r0,-277r-32,0r0,-26r58,0r0,330","w":82},"^":{"d":"34,-121r-26,0r51,-141r21,0r51,141r-26,0r-36,-105","w":138},"_":{"d":"-2,27r168,0r0,18r-168,0r0,-18"},"`":{"d":"67,-210r-21,0r-33,-49r35,0","w":98},"a":{"d":"84,-191v96,-8,41,142,67,191r-27,0v-3,-6,-4,-14,-5,-23v-27,39,-109,37,-109,-26v0,-59,67,-57,107,-69v2,-32,-10,-47,-37,-47v-27,0,-34,10,-40,36r-25,-4v8,-38,25,-54,69,-58xm69,-21v37,0,51,-29,48,-73v-20,15,-79,4,-79,44v0,19,13,29,31,29"},"b":{"d":"152,-95v6,75,-71,134,-109,72r0,23r-24,0r0,-258r26,0r0,92v10,-15,20,-25,42,-25v46,0,61,44,65,96xm84,-165v-54,1,-60,143,0,143v55,-1,57,-142,0,-143"},"c":{"d":"81,-22v24,0,35,-20,38,-46r26,4v-4,38,-26,68,-65,68v-47,0,-69,-43,-69,-98v0,-98,114,-137,131,-38r-25,5v-4,-22,-14,-38,-35,-38v-32,0,-44,30,-44,71v0,42,10,72,43,72","w":147},"d":{"d":"75,-191v20,0,33,13,42,26r0,-93r26,0r0,258r-25,0r0,-24v-9,15,-20,28,-42,28v-43,-1,-66,-45,-66,-97v0,-54,18,-98,65,-98xm76,-165v-56,0,-54,143,2,143v28,0,41,-30,41,-68v0,-42,-11,-75,-43,-75"},"e":{"d":"37,-85v-4,62,71,90,87,25r26,4v-7,36,-29,60,-67,60v-50,0,-73,-40,-73,-96v0,-56,25,-99,72,-99v49,0,72,47,69,106r-114,0xm124,-111v3,-46,-45,-72,-72,-39v-8,10,-13,23,-14,39r86,0"},"f":{"d":"89,-231v-30,-9,-41,10,-37,44r30,0r0,25r-30,0r0,162r-26,0r0,-162r-23,0r0,-25r23,0v-6,-54,15,-86,67,-72","w":82,"k":{"\u2019":-5,"f":5}},"g":{"d":"144,-25v2,67,-14,97,-69,101v-39,3,-61,-23,-61,-61r25,5v0,31,43,38,63,21v16,-14,15,-28,16,-65v-10,14,-22,24,-43,24v-88,-1,-90,-191,0,-191v22,0,34,11,45,27r0,-23r24,0r0,162xm76,-165v-55,2,-55,140,2,139v58,-1,57,-140,-2,-139"},"h":{"d":"85,-164v-59,0,-35,103,-40,164r-26,0r0,-258r26,0r0,93v10,-16,25,-26,46,-26v77,-1,47,117,53,191r-26,0r0,-118v0,-28,-9,-46,-33,-46"},"i":{"d":"19,-221r0,-37r26,0r0,37r-26,0xm19,0r0,-187r26,0r0,187r-26,0","w":65},"j":{"d":"19,-221r0,-37r26,0r0,37r-26,0xm45,10v3,50,-17,75,-59,62r5,-26v25,6,29,-6,28,-37r0,-196r26,0r0,197","w":65},"k":{"d":"20,0r0,-258r26,0r0,147r61,-76r34,0r-59,70r64,117r-31,0r-51,-95r-18,21r0,74r-26,0","w":147},"l":{"d":"18,0r0,-258r26,0r0,258r-26,0","w":65},"m":{"d":"83,-163v-59,0,-32,104,-38,163r-26,0r0,-187r24,0r0,27v8,-18,23,-30,46,-31v24,0,37,14,43,33v10,-19,23,-33,47,-33v75,0,41,120,48,191r-26,0r0,-118v0,-28,-4,-45,-27,-45v-59,0,-32,104,-38,163r-26,0r0,-121v1,-26,-6,-42,-27,-42","w":245},"n":{"d":"86,-163v-63,0,-35,103,-41,163r-26,0r0,-187r23,0r0,27v11,-18,24,-31,49,-31v78,0,45,116,52,191r-26,0r0,-114v1,-32,-5,-49,-31,-49"},"o":{"d":"81,4v-48,0,-72,-41,-72,-97v0,-56,25,-98,72,-98v46,0,72,42,72,96v0,59,-22,99,-72,99xm80,-165v-30,0,-44,33,-44,72v0,40,14,71,46,71v30,0,44,-32,44,-71v0,-40,-14,-72,-46,-72"},"p":{"d":"152,-95v5,73,-64,131,-107,76r0,91r-26,0r0,-259r24,0r0,25v10,-18,21,-29,44,-29v47,0,61,44,65,96xm84,-166v-54,2,-60,143,0,144v55,0,57,-143,0,-144"},"q":{"d":"75,-191v22,0,35,12,44,29r0,-25r23,0r0,259r-25,0r0,-92v-45,57,-111,-2,-107,-75v3,-48,19,-96,65,-96xm76,-166v-55,0,-55,144,3,144v27,0,41,-31,40,-68v-1,-42,-12,-76,-43,-76"},"r":{"d":"93,-151v-32,-24,-48,18,-48,53r0,98r-26,0r0,-187r23,0r0,29v11,-29,33,-43,60,-23","w":98,"k":{"\u2019":-11,".":16,",":16}},"s":{"d":"116,-97v41,31,14,101,-43,101v-37,0,-58,-20,-64,-60r26,-5v-4,47,73,53,75,10v3,-32,-63,-30,-75,-44v-40,-23,-20,-102,36,-96v35,4,56,17,59,52r-25,5v3,-39,-64,-41,-67,-7v-3,30,66,30,78,44","w":147},"t":{"d":"51,-53v-2,24,6,28,26,25r3,28v-41,7,-55,-6,-55,-55r0,-107r-19,0r0,-25r19,0r0,-46r26,-19r0,65r26,0r0,25r-26,0r0,109","w":82},"u":{"d":"76,-23v60,0,36,-102,41,-164r26,0r0,187r-24,0r0,-27v-10,18,-24,31,-48,31v-78,0,-47,-116,-53,-191r26,0v7,57,-23,164,32,164"},"v":{"d":"62,0r-58,-187r27,0r43,150v11,-50,29,-102,43,-150r27,0r-58,187r-24,0","w":147,"k":{".":22,",":22}},"w":{"d":"47,0r-47,-187r27,0r33,148r33,-148r27,0r30,144r35,-144r25,0r-48,187r-26,0r-31,-144r-31,144r-27,0","w":213,"k":{".":16,",":16}},"x":{"d":"2,0r56,-97r-52,-90r33,0r34,65r37,-65r31,0r-53,88r57,99r-31,0r-40,-74r-40,74r-32,0","w":147},"y":{"d":"18,72r-3,-30v37,7,38,-4,48,-42r-58,-187r28,0r43,152v11,-54,29,-101,43,-152r26,0r-58,190v-16,46,-19,80,-69,69","w":147,"k":{".":22,",":22}},"z":{"d":"6,0r0,-26r97,-136v-31,2,-59,0,-91,1r0,-26r125,0r0,21r-99,140v35,-2,68,-1,103,-1r0,27r-135,0","w":147},"{":{"d":"38,-11v-1,-42,1,-63,-30,-68r0,-29v31,-5,30,-26,30,-68v0,-57,1,-87,54,-86r0,28v-27,-1,-30,7,-30,36v-1,64,2,83,-30,105v25,14,30,34,30,79v0,48,-8,59,30,62r0,28v-54,1,-54,-29,-54,-87","w":98},"|":{"d":"27,76r0,-338r23,0r0,338r-23,0","w":76},"}":{"d":"60,-176v1,42,-1,63,30,68r0,29v-31,5,-30,26,-30,68v0,57,0,88,-53,87r0,-28v27,0,29,-7,29,-36v0,-63,-2,-84,30,-105v-25,-16,-29,-34,-30,-79v-1,-48,9,-60,-29,-62r0,-28v53,-1,53,29,53,86","w":98},"~":{"d":"50,-122v-18,2,-25,9,-37,24r0,-36v26,-42,77,-7,110,3v18,-1,28,-13,37,-25r0,38v-29,41,-76,4,-110,-4","w":172},"\u00c4":{"d":"54,-289r0,-36r28,0r0,36r-28,0xm108,-289r0,-36r27,0r0,36r-27,0xm0,0r81,-258r30,0r86,258r-32,0r-24,-78r-88,0r-24,78r-29,0xm61,-106r71,0r-37,-125v-7,45,-22,84,-34,125","w":196},"\u00c5":{"d":"99,-268v-15,0,-26,-15,-26,-32v0,-16,11,-32,26,-32v15,0,26,16,26,32v0,16,-11,32,-26,32xm99,-319v-9,0,-15,10,-15,19v0,10,6,19,15,19v9,0,15,-9,15,-19v0,-10,-6,-19,-15,-19xm0,0r81,-258r30,0r86,258r-32,0r-24,-78r-88,0r-24,78r-29,0xm61,-106r71,0r-37,-125v-7,45,-22,84,-34,125","w":196},"\u00d6":{"d":"72,-289r0,-36r27,0r0,36r-27,0xm126,-289r0,-36r27,0r0,36r-27,0xm116,4v-63,0,-101,-64,-101,-130v0,-76,35,-136,101,-136v68,0,100,58,101,133v1,71,-36,133,-101,133xm116,-233v-51,0,-72,46,-72,108v0,54,26,100,72,100v49,0,72,-47,72,-104v0,-56,-20,-104,-72,-104","w":229},"\u00dc":{"d":"64,-289r0,-36r27,0r0,36r-27,0xm117,-289r0,-36r27,0r0,36r-27,0xm104,-26v48,0,57,-26,57,-83r0,-149r28,0v-7,109,33,262,-83,262v-115,0,-76,-155,-83,-262r28,0r0,149v-2,54,9,83,53,83","w":213},"\u00e1":{"d":"62,-210r19,-49r34,0r-32,49r-21,0xm84,-191v96,-8,41,142,67,191r-27,0v-3,-6,-4,-14,-5,-23v-27,39,-109,37,-109,-26v0,-59,67,-57,107,-69v2,-32,-10,-47,-37,-47v-27,0,-34,10,-40,36r-25,-4v8,-38,25,-54,69,-58xm69,-21v37,0,51,-29,48,-73v-20,15,-79,4,-79,44v0,19,13,29,31,29"},"\u00e0":{"d":"84,-191v96,-8,41,142,67,191r-27,0v-3,-6,-4,-14,-5,-23v-27,39,-109,37,-109,-26v0,-59,67,-57,107,-69v2,-32,-10,-47,-37,-47v-27,0,-34,10,-40,36r-25,-4v8,-38,25,-54,69,-58xm69,-21v37,0,51,-29,48,-73v-20,15,-79,4,-79,44v0,19,13,29,31,29xm100,-210r-21,0r-33,-49r35,0"},"\u00e2":{"d":"83,-240r-16,30r-30,0r31,-49r28,0r32,49r-29,0xm84,-191v96,-8,41,142,67,191r-27,0v-3,-6,-4,-14,-5,-23v-27,39,-109,37,-109,-26v0,-59,67,-57,107,-69v2,-32,-10,-47,-37,-47v-27,0,-34,10,-40,36r-25,-4v8,-38,25,-54,69,-58xm69,-21v37,0,51,-29,48,-73v-20,15,-79,4,-79,44v0,19,13,29,31,29"},"\u00e4":{"d":"39,-223r0,-36r27,0r0,36r-27,0xm93,-223r0,-36r27,0r0,36r-27,0xm84,-191v96,-8,41,142,67,191r-27,0v-3,-6,-4,-14,-5,-23v-27,39,-109,37,-109,-26v0,-59,67,-57,107,-69v2,-32,-10,-47,-37,-47v-27,0,-34,10,-40,36r-25,-4v8,-38,25,-54,69,-58xm69,-21v37,0,51,-29,48,-73v-20,15,-79,4,-79,44v0,19,13,29,31,29"},"\u00e3":{"d":"100,-211v-14,3,-49,-36,-49,1r-19,0v-1,-23,10,-40,29,-40v8,-2,30,13,38,15v8,-1,9,-6,11,-16r18,0v0,22,-9,40,-28,40xm84,-191v96,-8,41,142,67,191r-27,0v-3,-6,-4,-14,-5,-23v-27,39,-109,37,-109,-26v0,-59,67,-57,107,-69v2,-32,-10,-47,-37,-47v-27,0,-34,10,-40,36r-25,-4v8,-38,25,-54,69,-58xm69,-21v37,0,51,-29,48,-73v-20,15,-79,4,-79,44v0,19,13,29,31,29"},"\u00e5":{"d":"79,-210v-16,0,-26,-16,-26,-33v0,-16,11,-31,26,-31v15,0,26,16,26,32v0,16,-11,32,-26,32xm80,-262v-20,0,-21,38,-1,39v20,0,21,-38,1,-39xm84,-191v96,-8,41,142,67,191r-27,0v-3,-6,-4,-14,-5,-23v-27,39,-109,37,-109,-26v0,-59,67,-57,107,-69v2,-32,-10,-47,-37,-47v-27,0,-34,10,-40,36r-25,-4v8,-38,25,-54,69,-58xm69,-21v37,0,51,-29,48,-73v-20,15,-79,4,-79,44v0,19,13,29,31,29"},"\u00e7":{"d":"88,39v-1,-11,-8,-12,-23,-12r7,-31r20,0r-5,19v15,2,25,12,25,26v1,28,-34,38,-63,31r2,-21v17,2,35,2,37,-12xm81,-22v24,0,35,-20,38,-46r26,4v-4,38,-26,68,-65,68v-47,0,-69,-43,-69,-98v0,-98,114,-137,131,-38r-25,5v-4,-22,-14,-38,-35,-38v-32,0,-44,30,-44,71v0,42,10,72,43,72","w":147},"\u00e9":{"d":"62,-210r20,-49r33,0r-31,49r-22,0xm37,-85v-4,62,71,90,87,25r26,4v-7,36,-29,60,-67,60v-50,0,-73,-40,-73,-96v0,-56,25,-99,72,-99v49,0,72,47,69,106r-114,0xm124,-111v3,-46,-45,-72,-72,-39v-8,10,-13,23,-14,39r86,0"},"\u00e8":{"d":"37,-85v-4,62,71,90,87,25r26,4v-7,36,-29,60,-67,60v-50,0,-73,-40,-73,-96v0,-56,25,-99,72,-99v49,0,72,47,69,106r-114,0xm124,-111v3,-46,-45,-72,-72,-39v-8,10,-13,23,-14,39r86,0xm103,-210r-21,0r-33,-49r35,0"},"\u00ea":{"d":"86,-240r-16,30r-30,0r31,-49r28,0r32,49r-29,0xm37,-85v-4,62,71,90,87,25r26,4v-7,36,-29,60,-67,60v-50,0,-73,-40,-73,-96v0,-56,25,-99,72,-99v49,0,72,47,69,106r-114,0xm124,-111v3,-46,-45,-72,-72,-39v-8,10,-13,23,-14,39r86,0"},"\u00ed":{"d":"29,0r0,-187r26,0r0,187r-26,0xm23,-210r19,-49r34,0r-32,49r-21,0","w":82},"\u00ec":{"d":"29,0r0,-187r26,0r0,187r-26,0xm58,-210r-21,0r-33,-49r35,0","w":82},"\u00ee":{"d":"43,-240r-16,30r-29,0r31,-49r27,0r33,49r-30,0xm29,0r0,-187r26,0r0,187r-26,0","w":82},"\u00ef":{"d":"29,0r0,-187r26,0r0,187r-26,0xm1,-223r0,-36r27,0r0,36r-27,0xm54,-223r0,-36r28,0r0,36r-28,0","w":82},"\u00f1":{"d":"105,-211v-14,3,-49,-36,-49,1r-19,0v-1,-23,10,-40,29,-40v13,-3,48,35,48,-1r19,0v0,22,-9,40,-28,40xm86,-163v-63,0,-35,103,-41,163r-26,0r0,-187r23,0r0,27v11,-18,24,-31,49,-31v78,0,45,116,52,191r-26,0r0,-114v1,-32,-5,-49,-31,-49"},"\u00f3":{"d":"62,-210r19,-49r34,0r-32,49r-21,0xm81,4v-48,0,-72,-41,-72,-97v0,-56,25,-98,72,-98v46,0,72,42,72,96v0,59,-22,99,-72,99xm80,-165v-30,0,-44,33,-44,72v0,40,14,71,46,71v30,0,44,-32,44,-71v0,-40,-14,-72,-46,-72"},"\u00f2":{"d":"81,4v-48,0,-72,-41,-72,-97v0,-56,25,-98,72,-98v46,0,72,42,72,96v0,59,-22,99,-72,99xm80,-165v-30,0,-44,33,-44,72v0,40,14,71,46,71v30,0,44,-32,44,-71v0,-40,-14,-72,-46,-72xm101,-210r-21,0r-33,-49r35,0"},"\u00f4":{"d":"81,-240r-16,30r-30,0r31,-49r28,0r32,49r-29,0xm81,4v-48,0,-72,-41,-72,-97v0,-56,25,-98,72,-98v46,0,72,42,72,96v0,59,-22,99,-72,99xm80,-165v-30,0,-44,33,-44,72v0,40,14,71,46,71v30,0,44,-32,44,-71v0,-40,-14,-72,-46,-72"},"\u00f6":{"d":"39,-223r0,-36r27,0r0,36r-27,0xm93,-223r0,-36r27,0r0,36r-27,0xm81,4v-48,0,-72,-41,-72,-97v0,-56,25,-98,72,-98v46,0,72,42,72,96v0,59,-22,99,-72,99xm80,-165v-30,0,-44,33,-44,72v0,40,14,71,46,71v30,0,44,-32,44,-71v0,-40,-14,-72,-46,-72"},"\u00f5":{"d":"99,-211v-14,3,-49,-36,-49,1r-19,0v-1,-22,11,-39,29,-40v8,-2,30,13,38,15v8,-1,9,-6,11,-16r19,0v0,22,-10,39,-29,40xm81,4v-48,0,-72,-41,-72,-97v0,-56,25,-98,72,-98v46,0,72,42,72,96v0,59,-22,99,-72,99xm80,-165v-30,0,-44,33,-44,72v0,40,14,71,46,71v30,0,44,-32,44,-71v0,-40,-14,-72,-46,-72"},"\u00fa":{"d":"62,-210r19,-49r34,0r-32,49r-21,0xm76,-23v60,0,36,-102,41,-164r26,0r0,187r-24,0r0,-27v-10,18,-24,31,-48,31v-78,0,-47,-116,-53,-191r26,0v7,57,-23,164,32,164"},"\u00f9":{"d":"76,-23v60,0,36,-102,41,-164r26,0r0,187r-24,0r0,-27v-10,18,-24,31,-48,31v-78,0,-47,-116,-53,-191r26,0v7,57,-23,164,32,164xm92,-210r-21,0r-33,-49r35,0"},"\u00fb":{"d":"82,-240r-16,30r-30,0r31,-49r28,0r32,49r-29,0xm76,-23v60,0,36,-102,41,-164r26,0r0,187r-24,0r0,-27v-10,18,-24,31,-48,31v-78,0,-47,-116,-53,-191r26,0v7,57,-23,164,32,164"},"\u00fc":{"d":"41,-223r0,-36r27,0r0,36r-27,0xm95,-223r0,-36r27,0r0,36r-27,0xm76,-23v60,0,36,-102,41,-164r26,0r0,187r-24,0r0,-27v-10,18,-24,31,-48,31v-78,0,-47,-116,-53,-191r26,0v7,57,-23,164,32,164"},"\u00a3":{"d":"86,-236v-42,0,-43,51,-29,94r45,0r0,26r-41,0v9,32,-6,60,-23,82v41,-15,77,26,109,-2r9,29v-48,37,-97,-34,-142,12r-10,-30v24,-15,40,-52,30,-91r-28,0r0,-26r22,0v-19,-63,0,-120,58,-120v38,0,60,28,64,67r-26,4v-2,-24,-16,-45,-38,-45"},"\u00df":{"d":"83,-236v-30,0,-35,22,-35,62r0,174r-26,0r0,-176v-1,-54,16,-83,62,-86v30,-2,53,21,53,50v0,24,-21,56,-21,72v8,35,56,41,56,85v0,44,-48,77,-84,48v-9,-7,-16,-18,-21,-31r22,-13v9,19,18,29,29,29v16,1,27,-14,27,-30v-2,-39,-56,-44,-56,-83v0,-22,23,-57,23,-74v0,-16,-13,-27,-29,-27","w":180},"\u2122":{"d":"71,-114r0,-122r-38,0r0,-22r95,0r0,22r-38,0r0,122r-19,0xm142,-114r0,-144r29,0r29,115r29,-115r28,0r0,144r-18,0r0,-121r-30,121r-18,0r-31,-122r0,122r-18,0","w":295},"\u00e6":{"d":"249,-57v-3,65,-99,82,-124,26v-32,49,-114,47,-116,-18v-2,-57,59,-56,104,-69v3,-28,-4,-48,-33,-47v-28,1,-35,10,-41,36r-25,-4v7,-38,25,-56,66,-58v28,0,44,8,53,25v13,-17,29,-25,49,-25v52,2,68,51,68,106r-111,0v-12,68,75,84,83,24xm223,-111v3,-47,-43,-70,-71,-40v-8,9,-12,23,-13,40r84,0xm37,-50v6,50,71,27,75,-6v1,-6,2,-19,2,-38v-14,12,-81,7,-77,44","w":262},"\u00f8":{"d":"20,-91v0,-77,57,-125,114,-85r14,-22r14,12r-16,24v35,55,18,166,-56,166v-15,0,-27,-5,-39,-14r-15,24r-14,-13r16,-24v-14,-18,-18,-39,-18,-68xm119,-152v-36,-35,-73,8,-73,58v0,18,3,33,8,45xm65,-33v44,35,85,-22,70,-82v-1,-6,-2,-12,-5,-20","w":180},"\u00bf":{"d":"106,-187r0,36r-29,0r0,-36r29,0xm23,5v0,-58,62,-63,57,-128r25,0v10,67,-49,74,-55,126v-3,24,18,47,41,46v27,-2,39,-22,42,-52r27,4v-4,45,-26,73,-69,74v-39,1,-68,-30,-68,-70","w":180},"\u00ab":{"d":"49,-93r37,80r-21,0r-46,-80r46,-80r21,0xm104,-93r38,80r-22,0r-45,-80r45,-80r22,0"},"\u00bb":{"d":"114,-93r-38,-80r21,0r46,80r-46,80r-21,0xm58,-93r-38,-80r21,0r46,80r-46,80r-21,0"},"\u2026":{"d":"34,0r0,-36r30,0r0,36r-30,0xm133,0r0,-36r29,0r0,36r-29,0xm231,0r0,-36r30,0r0,36r-30,0","w":295},"\u2013":{"d":"-1,-81r0,-25r164,0r0,25r-164,0"},"\u2014":{"d":"0,-81r0,-25r295,0r0,25r-295,0","w":295},"\u201c":{"d":"85,-210r0,37r-28,0v0,-38,-2,-73,23,-85r7,13v-12,6,-17,15,-16,35r14,0xm40,-210r0,37r-28,0v-1,-38,-1,-74,24,-85r6,13v-11,6,-16,16,-16,35r14,0","w":98},"\u201d":{"d":"12,-221r0,-37r28,0v0,38,2,73,-23,85r-7,-13v10,-5,16,-17,16,-35r-14,0xm57,-221r0,-37r28,0v1,38,1,74,-24,85r-6,-13v11,-6,16,-17,16,-35r-14,0","w":98},"\u2018":{"d":"46,-210r0,37r-28,0v-1,-38,-1,-74,24,-85r6,13v-11,6,-16,16,-16,35r14,0","w":65,"k":{"\u2018":5}},"\u2019":{"d":"17,-221r0,-37r28,0v1,38,1,74,-24,85r-6,-13v10,-5,16,-17,16,-35r-14,0","w":65,"k":{"\u2019":5,"s":5," ":11}},"\u00ff":{"d":"33,-223r0,-36r27,0r0,36r-27,0xm86,-223r0,-36r28,0r0,36r-28,0xm18,72r-3,-30v37,7,38,-4,48,-42r-58,-187r28,0r43,152v11,-54,29,-101,43,-152r26,0r-58,190v-16,46,-19,80,-69,69","w":147},"\u20ac":{"d":"17,-165v4,-70,79,-123,143,-83r-6,33v-44,-43,-108,1,-108,50r98,0r-4,24r-96,0r0,23r92,0r-3,24r-86,0v0,56,67,92,107,52r0,36v-68,29,-125,-6,-136,-88r-22,0r4,-24r15,0r0,-23r-19,0r4,-24r17,0"},"\u0142":{"d":"18,-101r-18,19r0,-27r18,-20r0,-129r26,0r0,103r20,-21r0,28r-20,20r0,128r-26,0r0,-101","w":65},"\u00d7":{"d":"23,-72r45,-55r-45,-55r18,-22r45,55r45,-55r17,22r-45,55r46,55r-18,21r-45,-55r-46,55","w":172},"\u0107":{"d":"57,-210r19,-49r34,0r-32,49r-21,0xm81,-22v24,0,35,-20,38,-46r26,4v-4,38,-26,68,-65,68v-47,0,-69,-43,-69,-98v0,-98,114,-137,131,-38r-25,5v-4,-22,-14,-38,-35,-38v-32,0,-44,30,-44,71v0,42,10,72,43,72","w":147},"\u0105":{"d":"187,64v-27,20,-66,12,-63,-28v0,-10,2,-23,6,-40r17,0v-9,22,-8,54,16,55v7,0,15,-3,24,-8r0,21xm84,-191v96,-8,41,142,67,191r-27,0v-3,-6,-4,-14,-5,-23v-27,39,-109,37,-109,-26v0,-59,67,-57,107,-69v2,-32,-10,-47,-37,-47v-27,0,-34,10,-40,36r-25,-4v8,-38,25,-54,69,-58xm69,-21v37,0,51,-29,48,-73v-20,15,-79,4,-79,44v0,19,13,29,31,29"},"\u0119":{"d":"130,64v-27,21,-66,11,-64,-28v0,-10,2,-23,6,-40r18,0v-9,21,-8,53,15,55v7,0,16,-3,25,-8r0,21xm37,-85v-4,62,71,90,87,25r26,4v-7,36,-29,60,-67,60v-50,0,-73,-40,-73,-96v0,-56,25,-99,72,-99v49,0,72,47,69,106r-114,0xm124,-111v3,-46,-45,-72,-72,-39v-8,10,-13,23,-14,39r86,0"},"\u0151":{"d":"39,-210r17,-49r34,0r-31,49r-20,0xm89,-210r18,-49r33,0r-30,49r-21,0xm81,4v-48,0,-72,-41,-72,-97v0,-56,25,-98,72,-98v46,0,72,42,72,96v0,59,-22,99,-72,99xm80,-165v-30,0,-44,33,-44,72v0,40,14,71,46,71v30,0,44,-32,44,-71v0,-40,-14,-72,-46,-72"},"\u015b":{"d":"52,-210r19,-49r34,0r-32,49r-21,0xm116,-97v41,31,14,101,-43,101v-37,0,-58,-20,-64,-60r26,-5v-4,47,73,53,75,10v3,-32,-63,-30,-75,-44v-40,-23,-20,-102,36,-96v35,4,56,17,59,52r-25,5v3,-39,-64,-41,-67,-7v-3,30,66,30,78,44","w":147},"\u0171":{"d":"39,-210r18,-49r33,0r-30,49r-21,0xm89,-210r18,-49r34,0r-30,49r-22,0xm76,-23v60,0,36,-102,41,-164r26,0r0,187r-24,0r0,-27v-10,18,-24,31,-48,31v-78,0,-47,-116,-53,-191r26,0v7,57,-23,164,32,164"},"\u017a":{"d":"50,-210r19,-49r34,0r-32,49r-21,0xm6,0r0,-26r97,-136v-31,2,-59,0,-91,1r0,-26r125,0r0,21r-99,140v35,-2,68,-1,103,-1r0,27r-135,0","w":147},"\u017c":{"d":"55,-210r0,-39r33,0r0,39r-33,0xm6,0r0,-26r97,-136v-31,2,-59,0,-91,1r0,-26r125,0r0,21r-99,140v35,-2,68,-1,103,-1r0,27r-135,0","w":147},"\u2032":{"d":"19,-166v-5,-28,-8,-58,-7,-92r30,0v1,34,-2,64,-7,92r-16,0","w":56},"\u2033":{"d":"21,-166v-5,-28,-10,-57,-8,-92r30,0v1,34,-2,64,-7,92r-15,0xm68,-166v-4,-29,-9,-57,-7,-92r30,0v1,34,-2,64,-7,92r-16,0","w":104}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 *  2007 The Monotype Corporation. All Rights Reserved.
 * 
 * Trademark:
 * Arial is a trademark of The Monotype Corporation in the United States and/or
 * other countries.
 * 
 * Description:
 * Monotype Drawing Office 1982. A contemporary sans serif design, Arial contains
 * more humanist characteristics than many of its predecessors and as such is more
 * in tune with the mood of the last decades of the twentieth century. The overall
 * treatment of curves is softer and fuller than in most industrial-style sans
 * serif faces. Terminal strokes are cut on the diagonal which helps to give the
 * face a less mechanical appearance. Arial is an extremely versatile family of
 * typefaces which can be used with equal success for text setting in reports,
 * presentations, magazines etc, and for display use in newspapers, advertising and
 * promotions.
 * 
 * Manufacturer:
 * The Monotype Corporation
 * 
 * Designer:
 * Robin Nicholas, Patricia Saunders
 */
Cufon.registerFont({"w":164,"face":{"font-family":"Arial Narrow","font-weight":700,"font-stretch":"condensed","units-per-em":"360","panose-1":"2 11 7 6 2 2 2 3 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-13 -336 295 76.1149","underline-thickness":"26.3672","underline-position":"-24.9609","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":82,"k":{"Y":5,"A":11}},"!":{"d":"37,-66r-11,-131r0,-61r44,0v2,69,-6,129,-10,192r-23,0xm28,0r0,-49r41,0r0,49r-41,0","w":98},"\"":{"d":"24,-166v-5,-28,-10,-57,-8,-92r44,0v1,34,-2,64,-6,92r-30,0xm89,-166v-5,-28,-10,-57,-8,-92r44,0v1,34,-2,64,-6,92r-30,0","w":140},"#":{"d":"22,-64r-19,0r0,-39r26,0r8,-52r-34,0r0,-39r41,0r11,-68r32,0r-11,68r32,0r11,-68r33,0r-11,68r20,0r0,39r-27,0r-8,52r35,0r0,39r-42,0r-11,68r-32,0r11,-68r-32,0r-12,68r-32,0xm70,-155r-9,52r32,0r9,-52r-32,0"},"$":{"d":"151,-77v1,43,-24,74,-60,80r0,33r-20,0r0,-32v-35,-5,-55,-30,-61,-76r38,-5v3,17,11,33,23,39r0,-74v-72,-14,-73,-142,0,-149r0,-17r20,0r0,17v32,5,50,27,54,61r-36,6v-2,-14,-9,-23,-18,-28r0,69v41,13,58,30,60,76xm71,-223v-23,8,-26,51,0,61r0,-61xm91,-36v30,-6,35,-61,0,-68r0,68"},"%":{"d":"60,-126v-34,0,-47,-28,-47,-68v0,-41,12,-68,46,-68v34,0,47,28,47,68v0,40,-12,68,-46,68xm59,-234v-22,2,-21,78,0,80v22,-1,22,-80,0,-80xm90,10r-30,0r113,-272r29,0xm202,10v-34,0,-47,-28,-47,-68v0,-41,12,-68,47,-68v34,0,47,28,47,68v0,41,-12,68,-47,68xm202,-98v-23,1,-21,79,0,80v21,-2,20,-78,0,-80","w":262},"&":{"d":"175,-61v6,8,26,24,33,30r-24,38v-12,-7,-24,-17,-35,-30v-16,18,-31,27,-61,28v-88,2,-99,-123,-27,-155v-37,-45,-24,-112,38,-112v33,0,59,25,58,58v-2,32,-15,43,-39,62r30,47v3,-7,6,-17,9,-29r36,10v-6,25,-11,43,-18,53xm100,-227v-35,1,-16,42,-2,55v20,-10,36,-51,2,-55xm82,-118v-31,13,-41,80,4,82v12,0,25,-7,38,-20","w":213},"'":{"d":"21,-166v-5,-28,-10,-57,-8,-92r44,0v1,34,-2,64,-6,92r-30,0","w":70},"(":{"d":"89,-262v-46,105,-45,232,-1,338r-28,0v-56,-89,-59,-251,1,-338r28,0","w":98},")":{"d":"37,-262v59,87,59,249,1,338r-28,0v44,-104,45,-234,0,-338r27,0","w":98},"*":{"d":"35,-139r-21,-21r27,-34r-37,-11r8,-31v12,6,24,13,34,21v-2,-19,-3,-35,-3,-47r25,0v0,8,0,24,-3,47v11,-7,26,-15,36,-19r8,32v-11,3,-23,5,-37,8r25,36r-22,18r-20,-40v-5,12,-12,26,-20,41","w":114},"+":{"d":"68,-37r0,-67r-56,0r0,-46r56,0r0,-67r36,0r0,67r56,0r0,46r-56,0r0,67r-36,0","w":172},",":{"d":"20,-49r41,0v1,50,1,94,-36,106r-8,-20v15,-6,23,-17,23,-37r-20,0r0,-49","w":82},"-":{"d":"9,-69r0,-49r80,0r0,49r-80,0","w":98},"\u00ad":{"d":"9,-69r0,-49r80,0r0,49r-80,0","w":98},".":{"d":"21,0r0,-49r41,0r0,49r-41,0","w":82},"\/":{"d":"0,4r52,-266r30,0r-52,266r-30,0","w":82},"0":{"d":"81,4v-57,-6,-69,-54,-69,-132v-1,-76,14,-124,69,-131v56,7,69,55,69,132v0,77,-13,125,-69,131xm81,-37v41,3,25,-134,19,-165v-5,-11,-11,-16,-19,-16v-29,9,-26,37,-26,91v0,55,-3,81,26,90"},"1":{"d":"23,-194v24,-9,53,-37,60,-65r33,0r0,259r-40,0r0,-186v-15,17,-33,29,-53,37r0,-45","k":{"1":16}},"2":{"d":"149,-188v0,68,-58,98,-80,142r80,0r0,46r-142,0v1,-79,94,-112,102,-184v2,-20,-10,-34,-28,-34v-18,0,-28,13,-29,40r-40,-4v4,-47,25,-75,70,-77v42,-1,67,31,67,71"},"3":{"d":"152,-77v4,65,-73,107,-119,62v-13,-13,-20,-31,-22,-53r39,-6v1,21,11,36,30,37v39,1,40,-83,2,-83v-5,0,-12,2,-19,4r5,-40v20,0,33,-13,33,-34v0,-17,-7,-28,-23,-28v-16,1,-25,15,-26,34r-38,-7v7,-41,24,-66,65,-68v63,-3,85,95,32,120v25,6,39,31,41,62"},"4":{"d":"92,0r0,-52r-87,0r0,-43r92,-164r34,0r0,164r26,0r0,43r-26,0r0,52r-39,0xm92,-95r0,-88r-49,88r49,0"},"5":{"d":"155,-86v-2,43,-26,92,-72,90v-41,-1,-66,-29,-70,-70r41,-5v1,19,13,35,29,36v21,-2,31,-23,31,-51v0,-45,-42,-63,-63,-28r-33,-6r21,-134r107,0r0,46r-76,0r-7,44v51,-29,94,25,92,78"},"6":{"d":"13,-126v0,-77,17,-133,77,-133v36,0,55,27,60,64r-39,6v-1,-32,-31,-39,-45,-15v-6,10,-9,29,-11,58v35,-49,99,0,99,63v0,48,-26,87,-68,87v-56,0,-73,-54,-73,-130xm86,-131v-39,0,-37,95,2,94v21,-1,26,-19,26,-45v0,-27,-7,-49,-28,-49"},"7":{"d":"41,0v2,-81,29,-156,64,-208r-93,0r0,-46r139,0r0,36v-38,47,-71,134,-71,218r-39,0"},"8":{"d":"83,5v-74,0,-96,-117,-36,-144v-51,-23,-32,-128,34,-120v67,-8,83,96,34,120v59,24,42,144,-32,144xm81,-220v-16,0,-25,13,-25,31v0,18,9,31,25,31v15,0,25,-13,25,-31v0,-18,-10,-31,-25,-31xm81,-118v-39,0,-38,84,1,83v19,-1,29,-19,29,-43v0,-21,-12,-40,-30,-40"},"9":{"d":"150,-129v0,77,-17,134,-77,134v-38,0,-55,-26,-60,-65r40,-5v1,34,31,38,45,14v6,-10,9,-29,11,-58v-34,51,-100,1,-100,-62v0,-47,26,-88,68,-88v56,0,73,54,73,130xm77,-123v41,-1,36,-95,-2,-95v-37,1,-35,96,2,95"},":":{"d":"29,-137r0,-50r40,0r0,50r-40,0xm29,0r0,-49r40,0r0,49r-40,0","w":98},";":{"d":"28,-137r0,-50r40,0r0,50r-40,0xm28,-49r40,0v1,50,1,94,-36,106r-8,-20v15,-5,24,-16,23,-37r-19,0r0,-49","w":98},"\u037e":{"d":"28,-137r0,-50r40,0r0,50r-40,0xm28,-49r40,0v1,50,1,94,-36,106r-8,-20v15,-5,24,-16,23,-37r-19,0r0,-49","w":98},"<":{"d":"159,-29r-145,-77r0,-43r145,-76r0,50r-101,47r101,49r0,50","w":172},"=":{"d":"12,-143r0,-46r148,0r0,46r-148,0xm12,-65r0,-46r148,0r0,46r-148,0","w":172},">":{"d":"14,-29r0,-50r101,-48r-101,-48r0,-50r145,77r0,42","w":172},"?":{"d":"91,-260v54,0,93,55,68,105v-7,25,-58,42,-51,89r-36,0v-15,-65,51,-76,55,-122v2,-20,-16,-36,-35,-35v-22,0,-35,15,-40,44r-37,-6v1,-42,33,-75,76,-75xm72,0r0,-49r40,0r0,49r-40,0","w":180},"@":{"d":"157,43v48,0,80,-16,99,-46r31,0v-19,47,-63,79,-127,79v-100,-1,-151,-61,-151,-161v0,-99,49,-177,147,-177v79,0,121,56,123,135v2,60,-39,129,-95,127v-16,-1,-23,-6,-26,-20v-37,45,-99,6,-95,-53v4,-58,24,-118,78,-118v20,0,30,10,38,24r4,-19r38,0r-24,142v0,5,1,7,5,8v31,-9,51,-51,51,-92v0,-62,-34,-102,-97,-102v-82,0,-121,64,-121,148v0,77,42,126,122,125xm145,-159v-32,0,-44,50,-45,83v0,25,8,42,27,44v33,-4,42,-50,44,-86v1,-21,-9,-41,-26,-41","w":287},"A":{"d":"212,0r-46,0r-19,-59r-84,0r-18,59r-45,0r82,-258r45,0xm133,-102r-29,-96r-28,96r57,0","w":213,"k":{"\u2019":16,"y":11,"w":5,"v":11,"Y":27,"W":16,"V":22,"T":22," ":11}},"B":{"d":"198,-75v-4,60,-27,81,-105,75r-72,0r0,-258r85,0v86,-16,104,89,52,121v25,7,42,31,40,62xm147,-186v0,-39,-40,-27,-83,-29r0,60v41,-1,83,8,83,-31xm154,-77v0,-44,-46,-34,-90,-35r0,69v43,-1,90,10,90,-34","w":213},"C":{"d":"110,-40v29,0,41,-25,47,-55r41,16v-10,50,-35,83,-87,83v-66,0,-97,-60,-97,-131v0,-74,30,-135,99,-135v47,0,76,29,85,75r-43,13v-5,-25,-19,-44,-44,-44v-40,0,-53,38,-53,88v0,53,12,90,52,90","w":213},"D":{"d":"198,-126v0,74,-22,127,-97,126r-80,0r0,-258r78,0v81,0,99,53,99,132xm154,-128v2,-66,-17,-94,-90,-86r0,171r32,0v55,3,56,-34,58,-85","w":213},"E":{"d":"22,0r0,-258r156,0r0,44r-114,0r0,57r106,0r0,43r-106,0r0,71r118,0r0,43r-160,0","w":196},"F":{"d":"22,0r0,-258r145,0r0,44r-103,0r0,61r89,0r0,43r-89,0r0,110r-42,0","w":180,"k":{"A":16,".":33,",":33}},"G":{"d":"119,-40v20,0,39,-11,50,-22r0,-33r-49,0r0,-43r92,0r0,102v-16,20,-55,41,-91,40v-74,-2,-107,-57,-107,-133v0,-76,32,-132,105,-133v53,-1,83,29,90,76r-42,9v-6,-23,-22,-41,-48,-41v-42,0,-62,36,-61,86v0,51,16,92,61,92","w":229},"H":{"d":"22,0r0,-258r42,0r0,102r84,0r0,-102r43,0r0,258r-43,0r0,-113r-84,0r0,113r-42,0","w":213},"I":{"d":"20,0r0,-258r43,0r0,258r-43,0","w":82},"J":{"d":"72,-40v25,0,26,-17,26,-51r0,-167r42,0r0,163v1,63,-15,99,-70,99v-45,0,-65,-33,-65,-84r40,-5v0,27,7,45,27,45"},"K":{"d":"22,0r0,-258r43,0r0,115r86,-115r57,0r-79,101r84,157r-56,0r-58,-121r-34,43r0,78r-43,0","w":213},"L":{"d":"23,0r0,-256r42,0r0,213r106,0r0,43r-148,0","w":180,"k":{"\u2019":16,"y":11,"Y":27,"W":16,"V":22,"T":22," ":5}},"M":{"d":"21,0r0,-258r64,0r38,176r38,-176r64,0r0,258r-40,0r0,-203r-42,203r-41,0r-41,-203r0,203r-40,0","w":245},"N":{"d":"22,0r0,-258r41,0r87,172r0,-172r40,0r0,258r-43,0r-85,-168r0,168r-40,0","w":213},"O":{"d":"116,4v-71,0,-104,-58,-103,-131v1,-78,27,-135,102,-135v67,0,103,57,103,133v0,75,-33,132,-102,133xm116,-218v-42,0,-59,37,-59,89v0,50,18,89,59,89v41,0,58,-41,58,-90v0,-51,-17,-88,-58,-88","w":229},"P":{"d":"183,-178v3,69,-42,86,-119,81r0,97r-43,0r0,-258r69,0v72,-4,90,21,93,80xm139,-178v0,-39,-33,-37,-75,-36r0,73v42,1,75,3,75,-37","w":196,"k":{"A":22,".":38,",":38," ":5}},"Q":{"d":"116,-262v104,-5,127,157,76,229v10,9,22,16,34,22r-16,37v-23,-10,-17,-9,-47,-33v-83,37,-150,-26,-150,-122v0,-77,34,-130,103,-133xm57,-129v0,57,24,101,74,86v-9,-7,-17,-12,-26,-16r12,-29v14,6,27,14,40,26v30,-43,23,-160,-42,-156v-41,2,-58,39,-58,89","w":229},"R":{"d":"194,-186v2,41,-20,66,-55,72v34,24,50,73,72,114r-50,0r-54,-94v-9,-13,-20,-15,-43,-14r0,108r-42,0r0,-258r89,0v60,-3,81,20,83,72xm150,-182v4,-43,-45,-30,-86,-32r0,65v42,-2,91,11,86,-33","w":213,"k":{"Y":11,"W":5,"V":5}},"S":{"d":"153,-141v54,45,29,146,-56,146v-52,0,-80,-30,-86,-89r41,-5v-1,61,88,67,88,14v0,-40,-69,-36,-94,-56v-47,-38,-28,-137,50,-131v50,4,79,28,80,78r-42,2v4,-45,-75,-49,-75,-12v0,36,73,35,94,53","w":196},"T":{"d":"69,0r0,-214r-63,0r0,-44r168,0r0,44r-62,0r0,214r-43,0","w":180,"k":{"\u0119":22,"\u0105":22,"y":22,"w":22,"u":22,"s":22,"r":16,"o":22,"i":5,"e":22,"c":22,"a":22,"O":5,"A":22,";":33,":":33,".":33,"-":16,",":33}},"U":{"d":"108,4v-76,-3,-87,-37,-87,-124r0,-138r43,0r0,140v-2,53,2,73,43,78v39,-5,41,-23,40,-75r0,-143r43,0v-8,109,35,267,-82,262","w":213},"V":{"d":"75,0r-75,-258r46,0r54,191r51,-191r46,0r-76,258r-46,0","w":196,"k":{"\u0119":16,"\u0105":16,"y":11,"u":11,"r":16,"o":22,"i":5,"e":16,"a":16,"A":22,";":16,":":16,".":27,"-":16,",":27}},"W":{"d":"51,0r-50,-258r44,0r31,177r39,-177r51,0r37,180r32,-180r43,0r-51,258r-45,0r-43,-193r-41,193r-47,0","w":278,"k":{"\u0119":5,"\u0105":11,"y":5,"u":5,"r":5,"o":5,"i":2,"e":5,"a":11,"A":16,";":5,":":5,".":16,"-":6,",":16}},"X":{"d":"0,0r72,-134r-65,-124r50,0r42,83r42,-83r49,0r-66,125r73,133r-52,0r-47,-89r-47,89r-51,0","w":196},"Y":{"d":"77,0r0,-108r-77,-150r50,0r49,102r49,-102r49,0r-77,150r0,108r-43,0","w":196,"k":{"\u0119":16,"\u0105":16,"v":16,"u":16,"q":22,"p":16,"o":22,"i":11,"e":16,"a":16,"A":27,";":22,":":22,".":33,"-":16,",":33," ":5}},"Z":{"d":"3,0r0,-47r111,-167r-98,0r0,-44r154,0r0,41r-115,174r120,0r0,43r-172,0","w":180},"[":{"d":"21,73r0,-331r72,0r0,39r-34,0r0,253r34,0r0,39r-72,0","w":98},"\\":{"d":"0,-262r30,0r52,266r-30,0","w":82},"]":{"d":"77,-258r0,331r-72,0r0,-39r34,0r0,-253r-34,0r0,-39r72,0","w":98},"^":{"d":"17,-122r54,-140r32,0r53,140r-41,0r-29,-86r-28,86r-41,0","w":172},"_":{"d":"-2,27r168,0r0,18r-168,0r0,-18"},"`":{"d":"72,-210r-26,0r-40,-52r46,0","w":98},"a":{"d":"79,-153v-17,0,-22,7,-27,23r-37,-8v8,-36,25,-49,66,-53v100,-10,46,123,73,191r-40,0r-5,-20v-25,39,-104,27,-98,-31v-6,-56,62,-56,95,-71v0,-24,-6,-31,-27,-31xm74,-31v28,-2,33,-24,32,-59v-16,9,-57,9,-55,34v1,13,10,26,23,25"},"b":{"d":"105,4v-22,0,-39,-14,-48,-31r0,27r-38,0r0,-258r41,0r0,93v40,-57,109,-7,109,71v0,53,-22,98,-64,98xm93,-153v-23,0,-33,25,-33,56v0,36,7,58,35,62v24,-3,33,-26,32,-58v0,-35,-7,-60,-34,-60","w":180},"c":{"d":"12,-93v0,-101,123,-138,143,-38r-40,8v-3,-20,-13,-29,-28,-29v-25,0,-33,22,-33,55v0,63,58,84,63,25r40,9v-8,45,-32,67,-71,67v-52,0,-74,-46,-74,-97"},"d":{"d":"12,-94v-10,-78,68,-129,109,-71r0,-93r41,0r0,258r-38,0r0,-27v-42,67,-121,12,-112,-67xm87,-153v-23,1,-34,25,-33,56v1,36,5,62,34,62v45,0,47,-120,-1,-118","w":180},"e":{"d":"51,-79v-5,43,50,67,59,20r40,8v-9,33,-28,54,-66,55v-53,0,-75,-41,-75,-96v-1,-52,23,-99,71,-99v55,0,75,52,72,112r-101,0xm112,-109v4,-36,-31,-58,-52,-33v-6,8,-8,19,-8,33r60,0"},"f":{"d":"102,-221v-26,-9,-41,2,-36,34r31,0r0,39r-31,0r0,148r-40,0r0,-148r-22,0r0,-39r22,0v-2,-46,5,-76,47,-75v11,0,23,2,34,6","w":98,"k":{"\u2019":-5}},"g":{"d":"89,76v-46,0,-73,-18,-72,-64r47,7v1,14,7,19,23,19v38,0,35,-31,34,-68v-10,16,-24,30,-46,30v-42,0,-63,-46,-63,-94v0,-82,75,-130,112,-66r0,-27r38,0r0,168v0,64,-14,95,-73,95xm87,-153v-42,0,-47,112,-1,113v48,0,49,-113,1,-113","w":180},"h":{"d":"95,-153v-54,0,-26,99,-33,153r-41,0r0,-258r41,0r0,95v10,-15,24,-28,46,-28v77,0,46,115,52,191r-40,0r0,-99v-1,-38,2,-54,-25,-54","w":180},"i":{"d":"21,-212r0,-46r41,0r0,46r-41,0xm21,0r0,-187r41,0r0,187r-41,0","w":82},"j":{"d":"20,-212r0,-46r41,0r0,46r-41,0xm-6,28v24,5,27,-4,26,-37r0,-178r41,0r0,181v6,66,-20,94,-74,76","w":82},"k":{"d":"20,0r0,-258r40,0r0,137r48,-66r50,0r-53,69r56,118r-43,0r-39,-84r-19,24r0,60r-40,0"},"l":{"d":"21,0r0,-258r41,0r0,258r-41,0","w":82},"m":{"d":"55,-161v15,-36,79,-42,91,0v25,-50,97,-33,97,42r0,119r-40,0r0,-107v-1,-30,0,-43,-22,-46v-48,6,-24,100,-30,153r-40,0r0,-102v-2,-33,2,-49,-22,-51v-50,7,-23,99,-30,153r-41,0r0,-187r37,0r0,26","w":262},"n":{"d":"109,-191v78,0,44,117,51,191r-40,0r0,-95v1,-37,0,-53,-25,-58v-55,4,-26,98,-33,153r-41,0r0,-187r38,0r0,28v12,-19,25,-32,50,-32","w":180},"o":{"d":"91,4v-51,0,-81,-42,-79,-100v2,-52,27,-95,79,-95v50,-1,79,47,79,97v-1,54,-27,98,-79,98xm91,-151v-25,0,-38,26,-38,58v0,32,13,57,38,57v49,0,50,-115,0,-115","w":180},"p":{"d":"169,-95v10,76,-67,133,-108,72r0,94r-41,0r0,-258r38,0r0,28v42,-69,120,-13,111,64xm95,-152v-24,0,-35,24,-35,55v0,34,9,62,35,62v44,0,46,-117,0,-117","w":180},"q":{"d":"78,-191v24,0,36,13,46,32r0,-28r38,0r0,258r-41,0r0,-94v-45,62,-108,4,-108,-72v0,-51,23,-96,65,-96xm88,-35v45,0,50,-117,1,-117v-25,0,-34,25,-34,59v0,34,7,58,33,58","w":180},"r":{"d":"106,-139v-44,-24,-46,26,-46,81r0,58r-40,0r0,-187r37,0r0,27v10,-29,35,-40,62,-22","w":114,"k":{"\u2019":-11,".":16,",":16}},"s":{"d":"138,-94v31,41,-1,98,-58,98v-41,0,-66,-22,-73,-57r41,-8v0,36,57,41,61,9v-1,-11,-5,-12,-16,-16v-54,-17,-74,-18,-80,-66v-6,-55,73,-71,110,-45v10,7,18,20,22,37r-38,9v0,-27,-53,-30,-57,-7v3,24,78,24,88,46"},"t":{"d":"95,-3v-44,18,-72,0,-72,-63r0,-81r-19,0r0,-40r19,0r0,-37r41,-29r0,66r27,0r0,40r-27,0r0,75v-2,33,2,40,27,31","w":98},"u":{"d":"86,-33v53,-5,27,-97,33,-154r40,0r0,187r-37,0r0,-28v-10,17,-27,32,-51,32v-76,-2,-45,-117,-51,-191r41,0v7,54,-20,148,25,154","w":180},"v":{"d":"63,0r-61,-187r42,0r37,127r38,-127r41,0r-60,187r-37,0","k":{".":22,",":22}},"w":{"d":"50,0r-49,-187r40,0r28,123r27,-123r39,0r25,123r30,-123r40,0r-50,187r-38,0r-27,-120r-26,120r-39,0","w":229,"k":{".":11,",":11}},"x":{"d":"2,0r55,-96r-53,-91r50,0r27,52r28,-52r48,0r-52,89r57,98r-50,0r-31,-58r-32,58r-47,0"},"y":{"d":"2,-187r43,0r37,133r35,-133r42,0v-27,80,-42,173,-78,244v-9,18,-40,23,-66,16r-3,-39v30,7,44,-5,48,-33","k":{".":22,",":22}},"z":{"d":"5,0r0,-38r78,-109v-21,2,-49,1,-72,1r0,-41r126,0r0,35r-79,110v31,-2,53,0,84,-1r0,43r-137,0","w":147},"{":{"d":"40,-4v0,-42,2,-64,-31,-68r0,-42v31,-4,31,-25,31,-63v0,-62,8,-87,67,-85r0,42v-24,0,-29,2,-29,25v0,39,1,87,-27,102v26,15,27,61,27,101v-1,24,7,24,29,26r0,42v-57,2,-67,-22,-67,-80","w":114},"|":{"d":"25,76r0,-338r33,0r0,338r-33,0","w":82},"}":{"d":"73,-183v0,42,-2,65,32,69r0,42v-31,4,-32,24,-32,62v0,64,-8,86,-66,86r0,-42v23,-1,28,-4,29,-26v1,-36,1,-88,27,-101v-28,-17,-27,-60,-27,-102v0,-23,-5,-25,-29,-25r0,-42v55,-1,66,20,66,79","w":114},"~":{"d":"120,-92v-23,1,-52,-25,-71,-24v-13,0,-26,9,-39,25r0,-46v27,-46,82,-11,113,0v17,-2,30,-12,40,-25r0,47v-9,10,-23,22,-43,23","w":172},"\u00c4":{"d":"58,-285r0,-42r34,0r0,42r-34,0xm120,-285r0,-42r35,0r0,42r-35,0xm212,0r-46,0r-19,-59r-84,0r-18,59r-45,0r82,-258r45,0xm133,-102r-29,-96r-28,96r57,0","w":213},"\u00c5":{"d":"106,-336v16,0,28,17,28,35v0,18,-12,34,-28,34v-16,0,-28,-17,-28,-34v0,-18,12,-35,28,-35xm106,-286v7,0,14,-8,13,-15v1,-9,-6,-16,-13,-16v-7,0,-14,7,-13,16v-1,7,6,15,13,15xm212,0r-46,0r-19,-59r-84,0r-18,59r-45,0r82,-258r45,0xm133,-102r-29,-96r-28,96r57,0","w":213},"\u00d6":{"d":"67,-285r0,-42r35,0r0,42r-35,0xm129,-285r0,-42r35,0r0,42r-35,0xm116,4v-71,0,-104,-58,-103,-131v1,-78,27,-135,102,-135v67,0,103,57,103,133v0,75,-33,132,-102,133xm116,-218v-42,0,-59,37,-59,89v0,50,18,89,59,89v41,0,58,-41,58,-90v0,-51,-17,-88,-58,-88","w":229},"\u00dc":{"d":"57,-285r0,-42r35,0r0,42r-35,0xm120,-285r0,-42r34,0r0,42r-34,0xm108,4v-76,-3,-87,-37,-87,-124r0,-138r43,0r0,140v-2,53,2,73,43,78v39,-5,41,-23,40,-75r0,-143r43,0v-8,109,35,267,-82,262","w":213},"\u00e1":{"d":"62,-210r20,-52r45,0r-39,52r-26,0xm79,-153v-17,0,-22,7,-27,23r-37,-8v8,-36,25,-49,66,-53v100,-10,46,123,73,191r-40,0r-5,-20v-25,39,-104,27,-98,-31v-6,-56,62,-56,95,-71v0,-24,-6,-31,-27,-31xm74,-31v28,-2,33,-24,32,-59v-16,9,-57,9,-55,34v1,13,10,26,23,25"},"\u00e0":{"d":"79,-153v-17,0,-22,7,-27,23r-37,-8v8,-36,25,-49,66,-53v100,-10,46,123,73,191r-40,0r-5,-20v-25,39,-104,27,-98,-31v-6,-56,62,-56,95,-71v0,-24,-6,-31,-27,-31xm74,-31v28,-2,33,-24,32,-59v-16,9,-57,9,-55,34v1,13,10,26,23,25xm103,-210r-26,0r-40,-52r46,0"},"\u00e2":{"d":"34,-210r30,-52r37,0r30,52r-32,0r-17,-26r-16,26r-32,0xm79,-153v-17,0,-22,7,-27,23r-37,-8v8,-36,25,-49,66,-53v100,-10,46,123,73,191r-40,0r-5,-20v-25,39,-104,27,-98,-31v-6,-56,62,-56,95,-71v0,-24,-6,-31,-27,-31xm74,-31v28,-2,33,-24,32,-59v-16,9,-57,9,-55,34v1,13,10,26,23,25"},"\u00e4":{"d":"34,-220r0,-42r35,0r0,42r-35,0xm96,-220r0,-42r35,0r0,42r-35,0xm79,-153v-17,0,-22,7,-27,23r-37,-8v8,-36,25,-49,66,-53v100,-10,46,123,73,191r-40,0r-5,-20v-25,39,-104,27,-98,-31v-6,-56,62,-56,95,-71v0,-24,-6,-31,-27,-31xm74,-31v28,-2,33,-24,32,-59v-16,9,-57,9,-55,34v1,13,10,26,23,25"},"\u00e3":{"d":"61,-227v-8,1,-10,5,-10,15r-18,0v-1,-24,5,-44,26,-44v20,0,50,35,55,-1r18,0v0,26,-5,42,-25,44v-14,2,-35,-15,-46,-14xm79,-153v-17,0,-22,7,-27,23r-37,-8v8,-36,25,-49,66,-53v100,-10,46,123,73,191r-40,0r-5,-20v-25,39,-104,27,-98,-31v-6,-56,62,-56,95,-71v0,-24,-6,-31,-27,-31xm74,-31v28,-2,33,-24,32,-59v-16,9,-57,9,-55,34v1,13,10,26,23,25"},"\u00e5":{"d":"82,-270v17,0,29,17,29,34v0,17,-13,35,-29,35v-36,0,-37,-69,0,-69xm82,-220v16,-1,17,-32,0,-32v-6,0,-14,7,-12,16v-2,8,6,16,12,16xm79,-153v-17,0,-22,7,-27,23r-37,-8v8,-36,25,-49,66,-53v100,-10,46,123,73,191r-40,0r-5,-20v-25,39,-104,27,-98,-31v-6,-56,62,-56,95,-71v0,-24,-6,-31,-27,-31xm74,-31v28,-2,33,-24,32,-59v-16,9,-57,9,-55,34v1,13,10,26,23,25"},"\u00e7":{"d":"123,35v0,35,-46,45,-79,36r0,-21v21,2,50,6,51,-14v1,-16,-22,-18,-37,-12r4,-17v26,-12,61,-2,61,28xm12,-93v0,-101,123,-138,143,-38r-40,8v-3,-20,-13,-29,-28,-29v-25,0,-33,22,-33,55v0,63,58,84,63,25r40,9v-8,45,-32,67,-71,67v-52,0,-74,-46,-74,-97"},"\u00e9":{"d":"60,-210r20,-52r46,0r-40,52r-26,0xm51,-79v-5,43,50,67,59,20r40,8v-9,33,-28,54,-66,55v-53,0,-75,-41,-75,-96v-1,-52,23,-99,71,-99v55,0,75,52,72,112r-101,0xm112,-109v4,-36,-31,-58,-52,-33v-6,8,-8,19,-8,33r60,0"},"\u00e8":{"d":"51,-79v-5,43,50,67,59,20r40,8v-9,33,-28,54,-66,55v-53,0,-75,-41,-75,-96v-1,-52,23,-99,71,-99v55,0,75,52,72,112r-101,0xm112,-109v4,-36,-31,-58,-52,-33v-6,8,-8,19,-8,33r60,0xm102,-210r-26,0r-40,-52r46,0"},"\u00ea":{"d":"32,-210r30,-52r38,0r30,52r-33,0r-16,-26r-16,26r-33,0xm51,-79v-5,43,50,67,59,20r40,8v-9,33,-28,54,-66,55v-53,0,-75,-41,-75,-96v-1,-52,23,-99,71,-99v55,0,75,52,72,112r-101,0xm112,-109v4,-36,-31,-58,-52,-33v-6,8,-8,19,-8,33r60,0"},"\u00ed":{"d":"21,0r0,-187r41,0r0,187r-41,0xm21,-210r20,-52r45,0r-39,52r-26,0","w":82},"\u00ec":{"d":"21,0r0,-187r41,0r0,187r-41,0xm63,-210r-26,0r-40,-52r46,0","w":82},"\u00ee":{"d":"-7,-210r30,-52r37,0r30,52r-32,0r-17,-26r-15,26r-33,0xm21,0r0,-187r41,0r0,187r-41,0","w":82},"\u00ef":{"d":"21,0r0,-187r41,0r0,187r-41,0xm-7,-220r0,-42r35,0r0,42r-35,0xm55,-220r0,-42r35,0r0,42r-35,0","w":82},"\u00f1":{"d":"69,-227v-8,1,-10,5,-10,15r-18,0v-1,-24,5,-44,26,-44v20,0,50,35,55,-1r18,0v0,26,-5,42,-25,44v-14,2,-35,-15,-46,-14xm109,-191v78,0,44,117,51,191r-40,0r0,-95v1,-37,0,-53,-25,-58v-55,4,-26,98,-33,153r-41,0r0,-187r38,0r0,28v12,-19,25,-32,50,-32","w":180},"\u00f3":{"d":"70,-210r20,-52r46,0r-40,52r-26,0xm91,4v-51,0,-81,-42,-79,-100v2,-52,27,-95,79,-95v50,-1,79,47,79,97v-1,54,-27,98,-79,98xm91,-151v-25,0,-38,26,-38,58v0,32,13,57,38,57v49,0,50,-115,0,-115","w":180},"\u00f2":{"d":"91,4v-51,0,-81,-42,-79,-100v2,-52,27,-95,79,-95v50,-1,79,47,79,97v-1,54,-27,98,-79,98xm91,-151v-25,0,-38,26,-38,58v0,32,13,57,38,57v49,0,50,-115,0,-115xm112,-210r-26,0r-40,-52r46,0","w":180},"\u00f4":{"d":"42,-210r30,-52r38,0r30,52r-33,0r-17,-26r-15,26r-33,0xm91,4v-51,0,-81,-42,-79,-100v2,-52,27,-95,79,-95v50,-1,79,47,79,97v-1,54,-27,98,-79,98xm91,-151v-25,0,-38,26,-38,58v0,32,13,57,38,57v49,0,50,-115,0,-115","w":180},"\u00f6":{"d":"42,-220r0,-42r35,0r0,42r-35,0xm104,-220r0,-42r35,0r0,42r-35,0xm91,4v-51,0,-81,-42,-79,-100v2,-52,27,-95,79,-95v50,-1,79,47,79,97v-1,54,-27,98,-79,98xm91,-151v-25,0,-38,26,-38,58v0,32,13,57,38,57v49,0,50,-115,0,-115","w":180},"\u00f5":{"d":"69,-227v-8,1,-10,5,-10,15r-18,0v-1,-24,5,-44,26,-44v21,0,49,35,55,-1r19,0v0,25,-6,42,-26,44v-13,2,-36,-15,-46,-14xm91,4v-51,0,-81,-42,-79,-100v2,-52,27,-95,79,-95v50,-1,79,47,79,97v-1,54,-27,98,-79,98xm91,-151v-25,0,-38,26,-38,58v0,32,13,57,38,57v49,0,50,-115,0,-115","w":180},"\u00fa":{"d":"69,-210r20,-52r46,0r-40,52r-26,0xm86,-33v53,-5,27,-97,33,-154r40,0r0,187r-37,0r0,-28v-10,17,-27,32,-51,32v-76,-2,-45,-117,-51,-191r41,0v7,54,-20,148,25,154","w":180},"\u00f9":{"d":"86,-33v53,-5,27,-97,33,-154r40,0r0,187r-37,0r0,-28v-10,17,-27,32,-51,32v-76,-2,-45,-117,-51,-191r41,0v7,54,-20,148,25,154xm111,-210r-26,0r-40,-52r46,0","w":180},"\u00fb":{"d":"41,-210r30,-52r38,0r30,52r-33,0r-17,-26r-15,26r-33,0xm86,-33v53,-5,27,-97,33,-154r40,0r0,187r-37,0r0,-28v-10,17,-27,32,-51,32v-76,-2,-45,-117,-51,-191r41,0v7,54,-20,148,25,154","w":180},"\u00fc":{"d":"41,-220r0,-42r35,0r0,42r-35,0xm104,-220r0,-42r34,0r0,42r-34,0xm86,-33v53,-5,27,-97,33,-154r40,0r0,187r-37,0r0,-28v-10,17,-27,32,-51,32v-76,-2,-45,-117,-51,-191r41,0v7,54,-20,148,25,154","w":180},"\u00a3":{"d":"50,-45v31,-18,62,22,94,-5r16,42v-44,37,-104,-29,-143,12r-15,-42v19,-16,32,-38,30,-71r-30,0r0,-39r23,0v-19,-55,6,-115,61,-114v40,1,62,27,66,68r-39,7v-1,-49,-55,-44,-55,-3v0,12,2,26,7,42r45,0r0,39r-38,0v1,32,-7,41,-22,64"},"\u00df":{"d":"83,-223v-25,4,-22,22,-22,56r0,167r-41,0r0,-167v-2,-61,12,-92,63,-95v36,-2,57,21,59,53v1,15,-18,51,-18,61v0,30,50,52,46,92v7,61,-77,82,-98,27r28,-20v6,21,30,16,29,-4v1,-25,-52,-61,-48,-84v-2,-15,20,-51,19,-68v0,-9,-7,-19,-17,-18","w":180},"\u2122":{"d":"68,-114r0,-119r-37,0r0,-25r96,0r0,25r-35,0r0,119r-24,0xm141,-114r0,-144r38,0r21,99r22,-99r37,0r0,144r-23,0r0,-115r-25,115r-22,0r-25,-115r0,115r-23,0","w":295},"\u00e6":{"d":"17,-138v3,-54,80,-68,117,-36v35,-35,95,-9,105,30v4,17,10,37,10,65r-102,0v1,51,48,62,60,19r40,9v-13,60,-86,72,-123,30v-28,36,-111,35,-111,-30v0,-55,49,-55,94,-70v1,-23,-6,-31,-25,-32v-16,-1,-25,9,-28,23xm209,-110v4,-37,-36,-58,-54,-29v-5,9,-8,18,-8,29r62,0xm53,-55v0,31,46,29,51,3v2,-6,3,-18,3,-37v-39,16,-45,5,-54,34","w":262},"\u00f8":{"d":"31,-27v-37,-57,-16,-167,61,-164v17,0,32,5,45,15r15,-21r16,16r-16,22v38,55,16,166,-61,163v-16,0,-31,-5,-44,-15r-17,24r-15,-17xm114,-144v-30,-25,-61,8,-61,49v0,12,1,22,4,31xm70,-43v30,25,60,-8,60,-49v0,-10,-1,-20,-4,-30","w":180},"\u00bf":{"d":"110,-187r0,50r-41,0r0,-50r41,0xm15,0v0,-57,62,-58,58,-120r37,0v11,66,-49,77,-56,122v8,48,71,45,75,-9r37,5v-4,45,-31,75,-76,76v-43,1,-75,-32,-75,-74","w":180},"\u00ab":{"d":"91,-173r-37,79r37,82r-32,0r-45,-82r45,-79r32,0xm148,-173r-38,79r38,82r-32,0r-46,-82r46,-79r32,0"},"\u00bb":{"d":"72,-12r37,-80r-37,-81r32,0r45,81r-45,80r-32,0xm15,-12r38,-80r-38,-81r32,0r46,81r-46,80r-32,0"},"\u2026":{"d":"226,0r0,-49r40,0r0,49r-40,0xm127,0r0,-49r41,0r0,49r-41,0xm29,0r0,-49r41,0r0,49r-41,0","w":295},"\u2013":{"d":"-1,-75r0,-37r165,0r0,37r-165,0"},"\u2014":{"d":"0,-75r0,-37r295,0r0,37r-295,0","w":295},"\u201c":{"d":"127,-151r-40,0v-1,-51,-2,-95,36,-107r7,21v-15,6,-23,16,-22,37r19,0r0,49xm60,-151r-41,0v-1,-50,-2,-95,36,-107r8,21v-15,6,-23,17,-23,37r20,0r0,49","w":147},"\u201d":{"d":"86,-258r41,0v1,51,2,94,-36,107r-8,-20v15,-6,23,-17,23,-37r-20,0r0,-50xm18,-258r41,0v1,51,1,94,-36,107r-8,-20v15,-6,23,-17,23,-37r-20,0r0,-50","w":147},"\u2018":{"d":"63,-151r-41,0v-1,-50,-2,-95,36,-107r8,21v-15,6,-23,17,-23,37r20,0r0,49","w":82,"k":{"\u2018":11}},"\u2019":{"d":"20,-258r40,0v1,51,1,94,-36,107r-8,-20v15,-6,24,-16,23,-37r-19,0r0,-50","w":82,"k":{"\u2019":11,"s":11," ":16}},"\u00ff":{"d":"33,-220r0,-42r35,0r0,42r-35,0xm95,-220r0,-42r35,0r0,42r-35,0xm2,-187r43,0r37,133r35,-133r42,0v-27,80,-42,173,-78,244v-9,18,-40,23,-66,16r-3,-39v30,7,44,-5,48,-33"},"\u20ac":{"d":"17,-168v7,-67,71,-116,138,-83r-8,48v-30,-28,-81,-13,-86,35r79,0r-5,27r-77,0r0,23r74,0r-5,28r-65,0v6,56,62,64,92,29r0,54v-67,33,-131,-15,-137,-83r-22,0r5,-28r14,0r0,-23r-19,0r5,-27r17,0"},"\u0142":{"d":"21,-127r0,-131r41,0r0,89r20,-20r0,33r-20,21r0,135r-41,0r0,-93r-19,20r0,-33","w":82},"\u00d7":{"d":"16,-74r43,-53r-43,-53r26,-33r44,53r44,-53r26,32r-44,53r44,54r-26,33r-44,-54r-44,53","w":172},"\u0107":{"d":"68,-210r20,-52r45,0r-39,52r-26,0xm12,-93v0,-101,123,-138,143,-38r-40,8v-3,-20,-13,-29,-28,-29v-25,0,-33,22,-33,55v0,63,58,84,63,25r40,9v-8,45,-32,67,-71,67v-52,0,-74,-46,-74,-97"},"\u0105":{"d":"172,68v-29,18,-66,4,-64,-33v0,-10,2,-24,6,-40r21,0v-5,20,-6,55,18,54v6,0,12,-2,19,-5r0,24xm79,-153v-17,0,-22,7,-27,23r-37,-8v8,-36,25,-49,66,-53v100,-10,46,123,73,191r-40,0r-5,-20v-25,39,-104,27,-98,-31v-6,-56,62,-56,95,-71v0,-24,-6,-31,-27,-31xm74,-31v28,-2,33,-24,32,-59v-16,9,-57,9,-55,34v1,13,10,26,23,25"},"\u0119":{"d":"134,68v-29,18,-66,4,-64,-33v0,-10,2,-24,6,-40r21,0v-5,20,-6,55,18,54v6,0,12,-2,19,-5r0,24xm51,-79v-5,43,50,67,59,20r40,8v-9,33,-28,54,-66,55v-53,0,-75,-41,-75,-96v-1,-52,23,-99,71,-99v55,0,75,52,72,112r-101,0xm112,-109v4,-36,-31,-58,-52,-33v-6,8,-8,19,-8,33r60,0"},"\u0151":{"d":"47,-210r21,-53r42,0r-37,53r-26,0xm102,-210r20,-53r41,0r-35,53r-26,0xm91,4v-51,0,-81,-42,-79,-100v2,-52,27,-95,79,-95v50,-1,79,47,79,97v-1,54,-27,98,-79,98xm91,-151v-25,0,-38,26,-38,58v0,32,13,57,38,57v49,0,50,-115,0,-115","w":180},"\u015b":{"d":"55,-210r20,-52r46,0r-40,52r-26,0xm138,-94v31,41,-1,98,-58,98v-41,0,-66,-22,-73,-57r41,-8v0,36,57,41,61,9v-1,-11,-5,-12,-16,-16v-54,-17,-74,-18,-80,-66v-6,-55,73,-71,110,-45v10,7,18,20,22,37r-38,9v0,-27,-53,-30,-57,-7v3,24,78,24,88,46"},"\u0171":{"d":"51,-210r20,-53r42,0r-37,53r-25,0xm105,-210r20,-53r42,0r-36,53r-26,0xm86,-33v53,-5,27,-97,33,-154r40,0r0,187r-37,0r0,-28v-10,17,-27,32,-51,32v-76,-2,-45,-117,-51,-191r41,0v7,54,-20,148,25,154","w":180},"\u017a":{"d":"50,-210r20,-52r45,0r-39,52r-26,0xm5,0r0,-38r78,-109v-21,2,-49,1,-72,1r0,-41r126,0r0,35r-79,110v31,-2,53,0,84,-1r0,43r-137,0","w":147},"\u017c":{"d":"56,-220r0,-46r40,0r0,46r-40,0xm5,0r0,-38r78,-109v-21,2,-49,1,-72,1r0,-41r126,0r0,35r-79,110v31,-2,53,0,84,-1r0,43r-137,0","w":147},"\u2032":{"d":"21,-166v-5,-28,-10,-57,-8,-92r44,0v1,34,-2,64,-6,92r-30,0","w":70},"\u2033":{"d":"24,-166v-5,-28,-10,-57,-8,-92r44,0v1,34,-2,64,-6,92r-30,0xm89,-166v-5,-28,-10,-57,-8,-92r44,0v1,34,-2,64,-6,92r-30,0","w":140},"\u00a0":{"w":82,"k":{"Y":5,"A":11}}}});
