/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 *  2006 The Monotype Corporation. All Rights Reserved.
 * 
 * Trademark:
 * Impact is a trademark of Stephenson Blake (Holdings) Ltd.
 * 
 * Description:
 * 1965. Designed for the Stephenson Blake type foundry. A very heavy, narrow,
 * sans serif face intended for use in newspapers, for headlines and in
 * advertisements. Aptly named, this face has a very large "x" height with short
 * ascenders and descenders.
 * 
 * Manufacturer:
 * The Monotype Corporation
 * 
 * Designer:
 * Geoffrey Lee
 * 
 * License information:
 * http://www.microsoft.com/typography/fonts/
 */
Cufon.registerFont({"w":184,"face":{"font-family":"Impact","font-weight":400,"font-stretch":"condensed","units-per-em":"360","panose-1":"2 11 8 6 3 9 2 5 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-19 -363.042 362 64.3894","underline-thickness":"17.9297","underline-position":"-27.0703","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":63},"!":{"d":"91,-285r-12,215r-55,0r-11,-215r78,0xm85,-57r0,57r-67,0r0,-57r67,0","w":97},"\"":{"d":"16,-193v-7,-27,-12,-56,-10,-92r54,0v2,35,-2,64,-8,92r-36,0xm82,-193v-6,-28,-11,-56,-9,-92r54,0v2,35,-3,65,-9,92r-36,0","w":133},"#":{"d":"6,-187r54,0r15,-67r33,0r-14,67r62,0r15,-67r33,0r-15,67r30,0r0,34r-36,0r-11,53r47,0r0,33r-53,0r-15,67r-33,0r14,-67r-63,0r-13,67r-34,0r14,-67r-30,0r0,-33r37,0r11,-53r-48,0r0,-34xm87,-153r-11,53r63,0r11,-53r-63,0","w":225},"$":{"d":"114,-286v45,5,71,33,65,84r-71,0v-1,-20,5,-42,-13,-42v-19,0,-14,37,-6,44v28,28,98,44,98,115v0,52,-25,80,-73,86r0,27r-32,0r0,-28v-48,-6,-76,-38,-71,-102r71,0v3,28,-8,59,12,60v23,2,14,-42,11,-53v-30,-43,-99,-48,-96,-119v1,-45,28,-67,73,-72r0,-23r32,0r0,23","w":197},"%":{"d":"194,-290r-111,295r-27,0r111,-295r27,0xm58,-290v57,-3,53,46,53,103v0,38,-15,49,-50,52v-60,5,-55,-45,-55,-101v0,-39,16,-52,52,-54xm59,-160v9,0,6,-5,7,-16r0,-73v0,-12,1,-15,-7,-16v-8,1,-7,5,-8,16r0,72v1,12,-3,17,8,17xm190,-153v57,0,53,46,53,103v0,39,-15,53,-50,53v-37,0,-55,-12,-55,-50v0,-56,-5,-106,52,-106xm191,-22v8,-1,7,-5,7,-16r0,-73v0,-12,1,-16,-7,-17v-8,1,-7,6,-8,17r0,72v1,12,0,16,8,17","w":249},"&":{"d":"93,-243v64,0,90,75,46,115r25,45r38,-25r0,48r-20,13r25,47r-65,0r-9,-16v-51,43,-127,20,-127,-48v0,-33,15,-48,40,-58v-54,-35,-24,-121,47,-121xm92,-204v-21,4,-11,35,1,46v13,-15,19,-40,-1,-46xm86,-86v-16,12,-20,44,3,46v6,0,12,-3,20,-8","w":207},"'":{"d":"16,-193v-7,-27,-12,-56,-10,-92r54,0v2,35,-2,64,-8,92r-36,0","w":66},"(":{"d":"15,-215v-8,-71,28,-70,91,-70r0,37v-28,1,-27,3,-27,33r0,146v1,29,0,31,27,32r0,37v-62,-1,-91,3,-91,-70r0,-145","w":112,"k":{"\u00c5":-9,"\u00c4":-9,"A":-9}},")":{"d":"34,-215v0,-31,0,-32,-28,-33r0,-37v62,0,92,-1,92,70r0,145v7,72,-28,70,-92,70r0,-37v28,0,28,-3,28,-32r0,-146","w":112},"*":{"d":"62,-285r0,29r26,-9r8,20r-26,11r16,24r-17,13r-18,-24r-18,24r-18,-13r16,-24r-26,-11r8,-20r27,9r0,-29r22,0","w":101},"+":{"d":"11,-163r63,0r0,-64r43,0r0,64r64,0r0,42r-64,0r0,63r-43,0r0,-63r-63,0r0,-42","w":191},",":{"d":"54,-56v4,50,-8,86,-48,92r0,-20v7,-4,11,-9,12,-16r-12,0r0,-56r48,0","w":60},"-":{"d":"100,-141r0,49r-94,0r0,-49r94,0","w":105},"\u00ad":{"d":"100,-141r0,49r-94,0r0,-49r94,0","w":105},".":{"d":"60,-58r0,58r-54,0r0,-58r54,0","w":66},"\/":{"d":"140,-290r-84,295r-54,0r85,-295r53,0","w":142},"0":{"d":"95,-290v62,0,85,30,85,102r0,95v4,68,-21,98,-80,98v-64,0,-87,-27,-87,-94r0,-99v-4,-71,21,-102,82,-102xm96,-38v15,-2,13,-11,13,-33r0,-141v-2,-22,4,-33,-12,-34v-15,2,-13,11,-13,34r0,139v1,25,-4,32,12,35","w":193},"1":{"d":"51,-153v4,-54,-4,-51,-49,-53r0,-33v34,-7,60,-23,78,-46r42,0r0,285r-71,0r0,-153","w":137},"2":{"d":"172,-216v0,77,-30,78,-84,167r78,0r0,49r-157,0r0,-41v59,-106,80,-112,96,-182v0,-14,-4,-23,-16,-23v-22,-1,-15,35,-16,58r-64,0v-3,-65,18,-101,77,-102v52,-1,86,28,86,74","w":180,"k":{"4":7}},"3":{"d":"175,-215v0,34,-7,41,-29,54v30,13,31,25,32,76v1,63,-23,91,-83,91v-72,0,-90,-38,-84,-119r71,0v4,26,-10,75,12,75v20,0,13,-32,13,-59v0,-31,-8,-38,-42,-37r0,-41v44,4,42,-11,42,-47v0,-16,0,-24,-13,-24v-19,-1,-10,30,-12,49r-71,0v-4,-65,12,-95,77,-93v62,2,87,20,87,75","w":190,"k":{"7":4}},"4":{"d":"158,-285r0,186r20,0r0,49r-20,0r0,50r-72,0r0,-50r-84,0r0,-49r61,-186r95,0xm86,-99r0,-121r-31,121r31,0","w":179,"k":{"7":7,"1":8}},"5":{"d":"96,-166v-12,2,-14,8,-13,25r-71,0r3,-144r153,0r0,46r-88,0r0,48v11,-13,25,-19,42,-19v63,0,60,56,60,120v0,68,-22,94,-84,95v-67,0,-92,-36,-86,-112r71,0v3,31,-8,66,15,69v26,-4,8,-65,13,-101v-1,-17,-1,-26,-15,-27","w":193,"k":{"7":11,"2":7,"1":11}},"6":{"d":"13,-120v0,-99,-7,-170,85,-170v56,0,86,24,85,81r-71,0v0,-17,3,-39,-15,-37v-25,2,-8,50,-13,78v30,-47,115,-15,99,53v7,78,-12,122,-82,120v-77,-2,-88,-36,-88,-125xm98,-38v23,-4,14,-55,14,-82v0,-17,-1,-26,-14,-27v-25,4,-14,52,-14,78v0,20,-1,29,14,31","w":194,"k":{"7":5,"2":4}},"7":{"d":"138,-285r0,62r-46,223r-70,0r50,-233r-70,0r0,-52r136,0","w":140,"k":{"7":-7,"4":7,"3":-4,"1":-8}},"8":{"d":"178,-215v0,34,-7,40,-30,54v28,14,32,25,33,78v1,65,-23,88,-85,88v-62,0,-86,-23,-84,-91v1,-37,1,-61,28,-75v-19,-9,-25,-29,-26,-56v-1,-51,29,-73,81,-73v59,0,83,22,83,75xm96,-178v18,2,12,-27,12,-45v0,-16,1,-22,-12,-23v-19,-1,-12,27,-12,45v0,15,1,22,12,23xm97,-38v21,0,13,-42,13,-66v0,-17,-1,-27,-14,-27v-22,0,-13,41,-13,64v0,19,0,29,14,29","w":192},"9":{"d":"183,-125v19,114,-49,150,-135,121v-26,-9,-35,-36,-35,-72r71,0v0,18,-2,38,15,38v25,-5,9,-51,13,-79v-30,47,-115,15,-99,-53v-7,-78,12,-120,82,-120v92,0,92,66,88,165xm98,-246v-24,3,-12,55,-14,82v-2,18,2,25,14,26v26,-3,9,-53,14,-78v-1,-20,0,-28,-14,-30","w":194},":":{"d":"66,-185r0,58r-53,0r0,-58r53,0xm66,-58r0,58r-53,0r0,-58r53,0","w":72},";":{"d":"66,-185r0,58r-53,0r0,-58r53,0xm63,-56v4,49,-6,85,-47,92r0,-20v7,-4,11,-9,12,-16r-12,0r0,-56r47,0","w":72},"\u037e":{"d":"66,-185r0,58r-53,0r0,-58r53,0xm63,-56v4,49,-6,85,-47,92r0,-20v7,-4,11,-9,12,-16r-12,0r0,-56r47,0","w":72},"<":{"d":"181,-57r-170,-70r0,-36r170,-71r0,47r-105,42r105,41r0,47","w":191},"=":{"d":"11,-197r170,0r0,43r-170,0r0,-43xm11,-130r170,0r0,43r-170,0r0,-43","w":191},">":{"d":"11,-234r170,71r0,35r-170,71r0,-46r105,-42r-105,-42r0,-47","w":191},"?":{"d":"98,-249v-19,1,-10,31,-12,56r-71,0v-3,-70,22,-98,83,-98v74,0,90,53,84,135v12,64,-62,97,-96,54r0,30r-66,0r0,-78r64,0v0,11,4,16,12,16v25,-1,8,-57,13,-89v-1,-15,2,-26,-11,-26xm86,-57r0,57r-66,0r0,-57r66,0","w":188},"@":{"d":"56,-123v-9,-69,70,-154,116,-87r3,-20r35,0r-23,145v0,5,2,7,6,7v34,-6,54,-43,54,-86v1,-59,-40,-101,-98,-100v-70,0,-117,54,-117,128v0,72,47,123,115,123v38,0,67,-14,89,-33r36,0v-25,34,-72,58,-125,59v-81,1,-141,-63,-141,-147v0,-87,55,-159,143,-157v80,2,119,49,124,127v4,60,-42,114,-90,116v-15,0,-25,-7,-28,-21v-35,46,-108,8,-99,-54xm137,-208v-32,1,-45,58,-45,95v-1,19,9,40,26,40v37,-2,44,-62,44,-99v0,-19,-7,-36,-25,-36","w":278},"A":{"d":"143,-285r42,285r-76,0r-4,-51r-26,0r-4,51r-77,0r38,-285r107,0xm103,-102v-4,-32,-7,-72,-11,-119v-8,54,-12,94,-14,119r25,0","w":182,"k":{"\u2026":-9,"\u00c5":-9,"\u00c4":-9,"}":-9,"z":-9,"x":-9,"]":-9,"Z":-9,"Y":22,"X":-9,"W":7,"V":8,"T":20,"J":-9,"A":-9,"\/":-9,".":-9,",":-9,")":-9}},"B":{"d":"187,-93v2,71,-6,93,-87,93r-85,0r0,-285v85,1,174,-15,167,81v-3,36,-9,42,-39,50v33,9,43,21,44,61xm89,-173v33,8,24,-30,22,-55v-5,-8,-8,-7,-22,-8r0,63xm89,-49v37,7,24,-48,20,-75v-3,-3,-9,-4,-20,-4r0,79","w":198},"C":{"d":"99,-291v76,0,95,47,89,131r-74,0v-4,-28,11,-82,-13,-82v-17,0,-13,11,-14,34r0,132v1,22,-2,31,13,34v23,-1,11,-45,14,-72r74,0v4,81,-17,120,-87,120v-67,0,-88,-32,-88,-107r0,-83v-6,-74,23,-107,86,-107","w":199},"D":{"d":"186,-85v4,72,-14,85,-78,85r-93,0r0,-285r55,0v93,0,116,8,116,101r0,99xm89,-49v28,-1,23,-9,23,-41r-1,-135v-3,-9,-8,-11,-22,-11r0,187","w":198},"E":{"d":"15,-285r123,0r0,57r-49,0r0,54r46,0r0,54r-46,0r0,63r54,0r0,57r-128,0r0,-285","w":149,"k":{"T":5}},"F":{"d":"15,-285r125,0r0,57r-51,0r0,54r45,0r0,54r-45,0r0,120r-74,0r0,-285","w":143,"k":{"\u2026":19,"\u00c5":7,"\u00c4":7,"Y":-8,"W":-7,"V":-8,"A":7,".":19,",":19}},"G":{"d":"96,-291v66,0,94,37,89,111r-74,0v-3,-26,7,-62,-13,-62v-14,0,-11,11,-11,32r0,137v0,20,-2,29,12,31v22,-1,11,-43,14,-68r-15,0r0,-43r87,0r0,153r-47,0r-7,-20v-9,16,-24,26,-46,26v-54,0,-72,-38,-72,-104r0,-84v-6,-76,20,-109,83,-109","w":198},"H":{"d":"185,-285r0,285r-74,0r0,-120r-22,0r0,120r-74,0r0,-285r74,0r0,102r22,0r0,-102r74,0","w":199},"I":{"d":"89,-285r0,285r-74,0r0,-285r74,0","w":103},"J":{"d":"3,-50v23,6,28,-9,28,-34r0,-201r74,0r0,191v3,72,-2,94,-65,94r-37,0r0,-50","w":119},"K":{"d":"191,-285r-42,129r46,156r-76,0r-30,-122r0,122r-74,0r0,-285r74,0r0,111r33,-111r69,0","w":193,"k":{"\u2026":-8,"\u00d6":7,"\u00c5":-7,"\u00c4":-7,"}":-5,"]":-5,"Z":-7,"S":5,"Q":7,"O":7,"J":-5,"C":7,"A":-7,".":-8,",":-8,")":-5}},"L":{"d":"89,-285r0,228r45,0r0,57r-119,0r0,-285r74,0","w":136,"k":{"\u2026":-10,"\u00d6":5,"\u00c5":-9,"\u00c4":-9,"y":9,"Z":-5,"Y":23,"X":-5,"W":13,"V":15,"T":26,"S":2,"Q":5,"O":5,"G":5,"C":5,"A":-9,".":-10,",":-10}},"M":{"d":"243,-285r0,285r-65,0r0,-192r-25,192r-46,0r-28,-188r0,188r-64,0r0,-285r96,0r19,133r17,-133r96,0","w":258},"N":{"d":"180,-285r0,285r-65,0r-38,-129r0,129r-62,0r0,-285r62,0r41,129r0,-129r62,0","w":194},"O":{"d":"98,-291v90,-3,86,75,86,173v0,85,-15,121,-86,124v-91,4,-85,-77,-85,-173v0,-85,14,-121,85,-124xm98,-42v16,-4,12,-13,12,-39r0,-130v-2,-19,4,-31,-11,-31v-14,0,-12,9,-12,31r0,132v2,25,-4,34,11,37","w":196},"P":{"d":"174,-205v7,70,-15,97,-85,90r0,115r-74,0r0,-285v83,1,172,-15,159,80xm89,-163v34,7,24,-45,19,-69v-3,-3,-9,-4,-19,-4r0,73","w":180,"k":{"\u2026":46,"\u00c5":9,"\u00c4":9,"J":14,"A":9,"\/":27,".":46,",":46}},"Q":{"d":"138,-14v-3,22,27,11,46,14r0,34v-41,-5,-105,17,-98,-34v-56,-4,-73,-34,-73,-102r0,-89v-4,-67,24,-100,82,-100v61,0,93,30,89,99v-5,72,21,172,-46,178xm98,-42v16,-4,12,-13,12,-39r0,-130v-2,-19,4,-31,-11,-31v-14,0,-12,9,-12,31r0,132v2,25,-4,34,11,37","w":196},"R":{"d":"139,-149v38,13,42,20,41,74r0,75r-69,0v-1,-38,3,-92,-3,-123v-2,-4,-9,-5,-19,-5r0,128r-74,0r0,-285r52,0v84,-2,113,5,113,78v0,42,-5,54,-41,58xm89,-173v31,8,24,-40,17,-59v-3,-3,-8,-4,-17,-4r0,63","w":193},"S":{"d":"89,-291v59,0,90,23,83,93r-69,0v-1,-17,5,-44,-12,-44v-17,0,-15,32,-9,43v43,43,96,44,96,126v0,60,-31,78,-82,79v-65,2,-92,-34,-85,-108r69,0v3,21,-8,59,13,60v22,1,15,-49,8,-56v-29,-30,-92,-45,-92,-113v0,-60,27,-80,80,-80","w":186},"T":{"d":"164,-285r0,57r-44,0r0,228r-74,0r0,-228r-44,0r0,-57r162,0","w":165,"k":{"\u2026":30,"\u00e6":15,"\u00e7":15,"\u00c5":14,"\u00c4":14,"y":-7,"w":-7,"v":-7,"e":15,"c":15,"a":15,"Z":2,"Y":-9,"W":-8,"V":-9,"J":16,"A":14,"\/":27,".":30,"-":24,",":30}},"U":{"d":"98,-42v14,-2,11,-12,11,-33r0,-210r74,0r0,191v5,71,-22,100,-82,100v-72,0,-87,-32,-87,-122r0,-169r74,0r0,214v1,18,-2,27,10,29","w":196},"V":{"d":"191,-285r-38,285r-112,0r-43,-285r78,0v9,78,15,145,19,199r17,-199r79,0","w":188,"k":{"\u2026":14,"\u00c5":5,"\u00c4":5,"y":-7,"Y":-9,"J":10,"A":5,"\/":13,".":14,",":14}},"W":{"d":"293,-285r-33,285r-92,0v-8,-44,-16,-93,-22,-149v-3,24,-10,73,-21,149r-92,0r-33,-285r72,0r15,196v3,-50,10,-115,21,-196r77,0r16,202v4,-69,10,-136,20,-202r72,0","w":293,"k":{"\u2026":12,"\u00c5":4,"\u00c4":4,"y":-5,"Y":-7,"J":10,"A":4,"\/":15,".":12,",":12}},"X":{"d":"165,-285r-26,126r39,159r-69,0v-8,-28,-15,-63,-22,-104r-15,104r-72,0r27,-159r-27,-126r72,0v1,17,11,58,15,78r16,-78r62,0","w":173,"k":{"\u2026":-13,"\u00c5":-9,"\u00c4":-9,"J":-7,"A":-9,".":-13,",":-13}},"Y":{"d":"172,-285r-54,182r0,103r-68,0r0,-103r-52,-182r68,0v11,55,17,93,18,112v4,-30,10,-68,20,-112r68,0","w":170,"k":{"\u2026":31,"\u00e6":16,"\u00e7":16,"\u00c5":18,"\u00c4":18,"s":12,"q":11,"o":16,"g":12,"e":16,"d":11,"c":16,"a":16,"J":16,"A":18,"\/":30,".":31,",":31}},"Z":{"d":"139,-285r0,57r-56,171r56,0r0,57r-137,0r0,-41r57,-187r-50,0r0,-57r130,0","w":142,"k":{"\u2026":-8,"\u00c5":-7,"\u00c4":-7,"y":-9,"A":-7,".":-8,",":-8}},"[":{"d":"95,-285r0,44r-16,0r0,197r16,0r0,44r-80,0r0,-285r80,0","w":101,"k":{"\u00c5":-9,"\u00c4":-9,"A":-9}},"\\":{"d":"2,-290r53,0r85,295r-53,0","w":142},"]":{"d":"6,0r0,-44r16,0r0,-197r-16,0r0,-44r81,0r0,285r-81,0","w":101},"^":{"d":"2,-144r66,-141r39,0r65,141r-50,0r-35,-86r-35,86r-50,0","w":174},"_":{"d":"-2,27r203,0r0,18r-203,0r0,-18","w":198},"`":{"d":"0,-311r63,0r31,47r-36,0","w":120},"a":{"d":"87,-196v-19,-1,-8,31,-11,53r-67,0v-5,-64,22,-94,81,-94v76,0,80,31,80,120r0,117r-69,0r0,-21v-19,41,-92,33,-92,-31v0,-53,7,-59,50,-77v35,-15,40,-5,40,-38v0,-18,1,-28,-12,-29xm88,-37v22,0,7,-49,11,-74v-19,15,-23,17,-23,45v0,18,-2,29,12,29","w":181},"b":{"d":"176,-65v11,69,-63,88,-92,47r-5,18r-66,0r0,-285r71,0r0,68v10,-13,23,-19,43,-20v77,-5,38,104,49,172xm95,-37v13,-3,10,-12,10,-32r0,-98v0,-18,2,-28,-11,-29v-13,2,-10,10,-10,29r0,101v1,19,-2,27,11,29","w":187},"c":{"d":"11,-154v-19,-95,124,-108,152,-42v5,12,7,29,7,51r-67,0v-2,-19,6,-51,-11,-51v-12,0,-10,9,-10,24r0,110v0,13,1,25,12,25v20,0,10,-37,12,-59r64,0v3,67,-19,97,-80,100v-86,5,-81,-74,-79,-158","w":178},"d":{"d":"11,-171v-14,-68,61,-82,92,-47r0,-67r71,0r0,285r-71,0r0,-17v-30,37,-106,23,-92,-45r0,-109xm92,-37v14,-2,10,-10,11,-30r0,-108v-1,-14,1,-21,-11,-21v-11,0,-10,7,-10,21r0,115v1,15,-1,21,10,23","w":187},"e":{"d":"89,-237v72,-1,90,46,84,125r-91,0v4,24,-10,71,11,75v20,-1,11,-38,13,-60r67,0v5,66,-18,101,-79,101v-58,-1,-83,-26,-83,-89r0,-68v-3,-57,26,-83,78,-84xm92,-196v-18,-1,-7,25,-10,46r20,0v-2,-19,5,-45,-10,-46"},"f":{"d":"15,-228v-7,-60,34,-57,88,-57r0,36v-27,1,-30,-3,-30,21r30,0r0,37r-17,0r0,191r-71,0r0,-191r-14,0r0,-37r14,0","w":104,"k":{"y":-9,"w":-7,"v":-8}},"g":{"d":"11,-175v-12,-66,64,-78,92,-41r5,-17r66,0r0,179v6,76,-24,92,-88,94v-45,1,-75,-12,-75,-57r68,0v0,10,4,16,12,16v18,0,12,-24,13,-42v-34,31,-93,17,-93,-47r0,-85xm92,-68v14,-2,11,-11,11,-31r0,-72v-1,-17,2,-24,-10,-25v-11,1,-11,9,-11,25r0,78v0,17,-2,24,10,25","w":186},"h":{"d":"95,-196v-12,2,-11,12,-11,30r0,166r-71,0r0,-285r71,0r0,64v40,-33,109,-13,93,60r0,161r-71,0r0,-164v-2,-21,3,-29,-11,-32","w":188},"i":{"d":"86,-285r0,37r-73,0r0,-37r73,0xm86,-233r0,233r-73,0r0,-233r73,0","w":98},"j":{"d":"88,-285r0,37r-73,0r0,-37r73,0xm-1,-5v26,1,16,-5,16,-38r0,-190r73,0r0,184v8,74,-21,85,-89,82r0,-38","w":100},"k":{"d":"166,-233r-29,93r37,140r-68,0r-22,-102r0,102r-71,0r0,-285r71,0r0,120r22,-68r60,0","w":172},"l":{"d":"86,-285r0,285r-73,0r0,-285r73,0","w":98},"m":{"d":"94,-196v-15,0,-12,19,-12,34r0,162r-69,0r0,-233r70,0r-1,22v15,-33,72,-36,90,0v10,-16,23,-26,45,-26v41,0,50,25,49,71r0,166r-69,0r0,-152v-2,-28,5,-40,-12,-44v-16,4,-12,16,-12,44r0,152r-68,0r0,-148v-3,-32,5,-43,-11,-48","w":277},"n":{"d":"95,-196v-15,3,-11,12,-11,38r0,158r-71,0r0,-233r72,0r-1,21v10,-16,21,-25,44,-25v42,0,48,25,48,74r0,163r-71,0r0,-162v-2,-23,5,-32,-10,-34","w":188},"o":{"d":"90,-237v56,2,86,24,83,86r0,57v4,68,-21,98,-80,98v-61,0,-82,-23,-82,-90v0,-82,-3,-155,79,-151xm92,-37v11,-2,10,-8,10,-24r0,-108v-2,-18,3,-26,-10,-27v-13,1,-10,9,-10,27r0,105v1,17,-2,25,10,27"},"p":{"d":"129,4v-21,0,-35,-10,-45,-24r0,53r-71,0r0,-266r72,0r-1,20v10,-14,25,-23,46,-24v70,-1,41,101,46,167v3,48,-7,74,-47,74xm95,-37v13,-2,10,-10,10,-28r0,-100v-2,-21,5,-31,-10,-31v-15,0,-11,12,-11,31r0,96v2,20,-4,31,11,32","w":186},"q":{"d":"11,-173v-10,-68,67,-81,92,-40r1,-20r70,0r0,266r-71,0r0,-52v-12,17,-17,22,-41,23v-75,1,-41,-106,-51,-177xm92,-37v13,-2,11,-9,11,-28r0,-105v-1,-15,0,-25,-11,-26v-12,2,-10,9,-10,26r0,104v1,20,-2,26,10,29","w":186},"r":{"d":"126,-155v-42,1,-43,13,-42,63r0,92r-71,0r0,-233r71,0r-3,30v10,-22,25,-33,45,-34r0,82","w":128,"k":{"\u2026":25,"y":-7,"w":-7,"v":-7,"t":-7,"f":-7,".":25,",":25}},"s":{"d":"81,-237v53,3,83,19,77,78r-63,0v-2,-18,5,-38,-11,-37v-18,1,-16,36,-2,42v28,22,81,30,81,85v0,54,-26,72,-74,73v-57,1,-85,-24,-80,-86r63,0v1,20,-4,43,12,45v20,3,15,-34,10,-41v-4,-6,-79,-41,-80,-57v-22,-55,5,-106,67,-102","w":169},"t":{"d":"110,0v-65,1,-94,4,-94,-72r0,-119r-15,0r0,-37r15,0r0,-36r72,0r0,36r19,0r0,37r-19,0r0,125v1,28,-6,28,22,28r0,38","w":109,"k":{"\u2026":-11,"z":-8,"y":-7,"v":-7,".":-11,",":-11}},"u":{"d":"93,-37v18,-2,11,-12,11,-39r0,-157r71,0r0,233r-72,0r1,-19v-9,14,-22,23,-43,23v-46,0,-49,-27,-49,-80r0,-157r71,0r0,158v2,26,-6,35,10,38","w":188},"v":{"d":"81,-63r15,-170r63,0r-33,233r-92,0r-36,-233r63,0","w":157,"k":{"\u2026":7,"z":-4,"y":-11,"t":-10,"f":-10,".":7,",":7}},"w":{"d":"242,-233r-28,233r-77,0v-4,-28,-9,-65,-15,-112r-16,112r-77,0r-30,-233r61,0v0,6,6,50,16,133v1,-8,5,-52,15,-133r59,0r15,133v2,-39,7,-83,16,-133r61,0","w":240,"k":{"z":-2,"y":-9,"f":-8}},"x":{"d":"153,-233r-28,111r34,122r-69,0v-7,-31,-11,-57,-15,-79v-5,28,-10,54,-16,79r-59,0r31,-122r-31,-111r59,0v9,48,15,75,16,81v7,-40,11,-67,15,-81r63,0","w":156,"k":{"\u2026":-8,"y":-5,".":-8,",":-8}},"y":{"d":"15,-5v30,1,29,-2,22,-33r-39,-195r64,0r24,157r11,-157r64,0r-28,223v-6,48,-61,44,-118,43r0,-38","w":161,"k":{"\u2026":7,"z":-2,"x":-7,"v":-7,"t":-7,"f":-7,".":7,",":7}},"z":{"d":"123,-233r0,51r-52,135r52,0r0,47r-121,0r0,-49r54,-138r-48,0r0,-46r115,0","w":126,"k":{"\u2026":-8,"z":-7,"y":-8,"w":-7,"v":-9,"t":-5,"f":-5,".":-8,",":-8}},"{":{"d":"45,-21v0,-50,2,-69,-39,-74r0,-42v35,-3,39,-17,39,-61v0,-68,18,-89,82,-87r0,42v-30,1,-35,1,-36,26v-3,61,1,75,-33,101v33,16,32,64,33,112v5,13,12,15,35,15r0,42v-59,2,-81,-13,-81,-74","w":133,"k":{"\u00c5":-9,"\u00c4":-9,"A":-9}},"|":{"d":"30,-285r38,0r0,332r-38,0r0,-332","w":97},"}":{"d":"88,-210v0,51,-3,68,39,73r0,42v-34,3,-39,19,-39,62v0,67,-16,89,-81,86r0,-42v29,-1,34,-1,35,-26v3,-61,0,-76,33,-101v-29,-20,-29,-33,-32,-81v-2,-42,5,-43,-37,-46r0,-42v59,-1,82,14,82,75","w":133},"~":{"d":"131,-158v23,-2,26,-11,48,-29r0,49v-41,42,-74,13,-120,0v-13,0,-29,9,-49,28r0,-48v17,-15,34,-23,51,-23v14,0,56,24,70,23","w":188},"\u00c4":{"d":"74,-339r0,45r-46,0r0,-45r46,0xm150,-339r0,45r-45,0r0,-45r45,0xm143,-285r42,285r-76,0r-4,-51r-26,0r-4,51r-77,0r38,-285r107,0xm103,-102v-4,-32,-7,-72,-11,-119v-8,54,-12,94,-14,119r25,0","w":182,"k":{"\u2026":-9,"\u00c5":-9,"\u00c4":-9,"}":-9,"z":-9,"x":-9,"]":-9,"Z":-9,"Y":22,"X":-9,"W":7,"V":8,"T":20,"J":-9,"A":-9,"\/":-9,".":-9,",":-9,")":-9}},"\u00c5":{"d":"52,-326v0,-20,17,-37,37,-37v21,-1,37,16,37,37v0,20,-17,37,-37,37v-20,0,-37,-17,-37,-37xm103,-325v0,-8,-6,-15,-14,-15v-8,0,-15,8,-15,15v0,7,7,14,15,14v7,1,14,-7,14,-14xm143,-285r42,285r-76,0r-4,-51r-26,0r-4,51r-77,0r38,-285r107,0xm103,-102v-4,-32,-7,-72,-11,-119v-8,54,-12,94,-14,119r25,0","w":182,"k":{"\u2026":-9,"\u00c5":-9,"\u00c4":-9,"}":-9,"z":-9,"x":-9,"]":-9,"Z":-9,"Y":22,"X":-9,"W":7,"V":8,"T":20,"J":-9,"A":-9,"\/":-9,".":-9,",":-9,")":-9}},"\u00d6":{"d":"83,-339r0,45r-46,0r0,-45r46,0xm160,-339r0,45r-46,0r0,-45r46,0xm98,-291v90,-3,86,75,86,173v0,85,-15,121,-86,124v-91,4,-85,-77,-85,-173v0,-85,14,-121,85,-124xm98,-42v16,-4,12,-13,12,-39r0,-130v-2,-19,4,-31,-11,-31v-14,0,-12,9,-12,31r0,132v2,25,-4,34,11,37","w":196},"\u00dc":{"d":"83,-339r0,45r-46,0r0,-45r46,0xm160,-339r0,45r-46,0r0,-45r46,0xm98,-42v14,-2,11,-12,11,-33r0,-210r74,0r0,191v5,71,-22,100,-82,100v-72,0,-87,-32,-87,-122r0,-169r74,0r0,214v1,18,-2,27,10,29","w":196},"\u00e1":{"d":"151,-297r-58,48r-36,0r31,-48r63,0xm87,-196v-19,-1,-8,31,-11,53r-67,0v-5,-64,22,-94,81,-94v76,0,80,31,80,120r0,117r-69,0r0,-21v-19,41,-92,33,-92,-31v0,-53,7,-59,50,-77v35,-15,40,-5,40,-38v0,-18,1,-28,-12,-29xm88,-37v22,0,7,-49,11,-74v-19,15,-23,17,-23,45v0,18,-2,29,12,29","w":181},"\u00e0":{"d":"87,-196v-19,-1,-8,31,-11,53r-67,0v-5,-64,22,-94,81,-94v76,0,80,31,80,120r0,117r-69,0r0,-21v-19,41,-92,33,-92,-31v0,-53,7,-59,50,-77v35,-15,40,-5,40,-38v0,-18,1,-28,-12,-29xm88,-37v22,0,7,-49,11,-74v-19,15,-23,17,-23,45v0,18,-2,29,12,29xm31,-296r63,0r31,47r-36,0","w":181},"\u00e2":{"d":"92,-272r-21,23r-49,0r45,-49r50,0r42,49r-47,0xm87,-196v-19,-1,-8,31,-11,53r-67,0v-5,-64,22,-94,81,-94v76,0,80,31,80,120r0,117r-69,0r0,-21v-19,41,-92,33,-92,-31v0,-53,7,-59,50,-77v35,-15,40,-5,40,-38v0,-18,1,-28,-12,-29xm88,-37v22,0,7,-49,11,-74v-19,15,-23,17,-23,45v0,18,-2,29,12,29","w":181},"\u00e4":{"d":"75,-295r0,46r-46,0r0,-46r46,0xm152,-295r0,46r-46,0r0,-46r46,0xm87,-196v-19,-1,-8,31,-11,53r-67,0v-5,-64,22,-94,81,-94v76,0,80,31,80,120r0,117r-69,0r0,-21v-19,41,-92,33,-92,-31v0,-53,7,-59,50,-77v35,-15,40,-5,40,-38v0,-18,1,-28,-12,-29xm88,-37v22,0,7,-49,11,-74v-19,15,-23,17,-23,45v0,18,-2,29,12,29","w":181},"\u00e3":{"d":"165,-282v-14,43,-65,31,-99,16v-9,0,-16,5,-22,17r-27,-18v21,-48,61,-33,100,-20v10,0,17,-5,20,-16xm87,-196v-19,-1,-8,31,-11,53r-67,0v-5,-64,22,-94,81,-94v76,0,80,31,80,120r0,117r-69,0r0,-21v-19,41,-92,33,-92,-31v0,-53,7,-59,50,-77v35,-15,40,-5,40,-38v0,-18,1,-28,-12,-29xm88,-37v22,0,7,-49,11,-74v-19,15,-23,17,-23,45v0,18,-2,29,12,29","w":181},"\u00e5":{"d":"54,-286v0,-20,17,-37,37,-37v20,0,37,16,37,37v0,20,-17,37,-37,37v-20,0,-37,-16,-37,-37xm105,-285v0,-8,-8,-15,-15,-15v-7,0,-14,7,-14,15v-1,7,7,14,14,14v8,0,15,-6,15,-14xm87,-196v-19,-1,-8,31,-11,53r-67,0v-5,-64,22,-94,81,-94v76,0,80,31,80,120r0,117r-69,0r0,-21v-19,41,-92,33,-92,-31v0,-53,7,-59,50,-77v35,-15,40,-5,40,-38v0,-18,1,-28,-12,-29xm88,-37v22,0,7,-49,11,-74v-19,15,-23,17,-23,45v0,18,-2,29,12,29","w":181},"\u00e7":{"d":"170,-96v2,64,-17,96,-74,100r0,5v13,0,26,10,25,23v0,37,-66,47,-72,5r26,0v3,12,21,10,20,-3v-1,-10,-9,-11,-20,-11r0,-20v-74,-3,-64,-80,-64,-157v0,-97,124,-108,152,-42v5,12,7,29,7,51r-67,0v-2,-19,6,-51,-11,-51v-12,0,-10,9,-10,24r0,110v0,13,1,25,12,25v20,0,10,-37,12,-59r64,0","w":178},"\u00e9":{"d":"152,-297r-58,48r-35,0r30,-48r63,0xm89,-237v72,-1,90,46,84,125r-91,0v4,24,-10,71,11,75v20,-1,11,-38,13,-60r67,0v5,66,-18,101,-79,101v-58,-1,-83,-26,-83,-89r0,-68v-3,-57,26,-83,78,-84xm92,-196v-18,-1,-7,25,-10,46r20,0v-2,-19,5,-45,-10,-46"},"\u00e8":{"d":"89,-237v72,-1,90,46,84,125r-91,0v4,24,-10,71,11,75v20,-1,11,-38,13,-60r67,0v5,66,-18,101,-79,101v-58,-1,-83,-26,-83,-89r0,-68v-3,-57,26,-83,78,-84xm92,-196v-18,-1,-7,25,-10,46r20,0v-2,-19,5,-45,-10,-46xm32,-296r63,0r31,47r-36,0"},"\u00ea":{"d":"93,-272r-20,23r-50,0r46,-49r49,0r42,49r-47,0xm89,-237v72,-1,90,46,84,125r-91,0v4,24,-10,71,11,75v20,-1,11,-38,13,-60r67,0v5,66,-18,101,-79,101v-58,-1,-83,-26,-83,-89r0,-68v-3,-57,26,-83,78,-84xm92,-196v-18,-1,-7,25,-10,46r20,0v-2,-19,5,-45,-10,-46"},"\u00ed":{"d":"86,-233r0,233r-73,0r0,-233r73,0xm110,-297r-58,48r-36,0r31,-48r63,0","w":98},"\u00ec":{"d":"86,-233r0,233r-73,0r0,-233r73,0xm-10,-296r63,0r31,47r-36,0","w":98},"\u00ee":{"d":"51,-272r-20,23r-50,0r46,-49r49,0r42,49r-47,0xm86,-233r0,233r-73,0r0,-233r73,0","w":98},"\u00ef":{"d":"86,-233r0,233r-73,0r0,-233r73,0xm34,-295r0,46r-45,0r0,-46r45,0xm111,-295r0,46r-46,0r0,-46r46,0","w":98},"\u00f1":{"d":"168,-282v-14,43,-64,30,-99,16v-9,0,-15,5,-21,17r-28,-18v21,-49,61,-32,101,-20v10,0,16,-5,19,-16xm95,-196v-15,3,-11,12,-11,38r0,158r-71,0r0,-233r72,0r-1,21v10,-16,21,-25,44,-25v42,0,48,25,48,74r0,163r-71,0r0,-162v-2,-23,5,-32,-10,-34","w":188},"\u00f3":{"d":"152,-297r-58,48r-35,0r30,-48r63,0xm90,-237v56,2,86,24,83,86r0,57v4,68,-21,98,-80,98v-61,0,-82,-23,-82,-90v0,-82,-3,-155,79,-151xm92,-37v11,-2,10,-8,10,-24r0,-108v-2,-18,3,-26,-10,-27v-13,1,-10,9,-10,27r0,105v1,17,-2,25,10,27"},"\u00f2":{"d":"90,-237v56,2,86,24,83,86r0,57v4,68,-21,98,-80,98v-61,0,-82,-23,-82,-90v0,-82,-3,-155,79,-151xm92,-37v11,-2,10,-8,10,-24r0,-108v-2,-18,3,-26,-10,-27v-13,1,-10,9,-10,27r0,105v1,17,-2,25,10,27xm32,-296r63,0r31,47r-36,0"},"\u00f4":{"d":"93,-272r-20,23r-50,0r46,-49r49,0r42,49r-47,0xm90,-237v56,2,86,24,83,86r0,57v4,68,-21,98,-80,98v-61,0,-82,-23,-82,-90v0,-82,-3,-155,79,-151xm92,-37v11,-2,10,-8,10,-24r0,-108v-2,-18,3,-26,-10,-27v-13,1,-10,9,-10,27r0,105v1,17,-2,25,10,27"},"\u00f6":{"d":"76,-295r0,46r-45,0r0,-46r45,0xm153,-295r0,46r-46,0r0,-46r46,0xm90,-237v56,2,86,24,83,86r0,57v4,68,-21,98,-80,98v-61,0,-82,-23,-82,-90v0,-82,-3,-155,79,-151xm92,-37v11,-2,10,-8,10,-24r0,-108v-2,-18,3,-26,-10,-27v-13,1,-10,9,-10,27r0,105v1,17,-2,25,10,27"},"\u00f5":{"d":"166,-282v-14,43,-64,30,-99,16v-9,0,-15,5,-21,17r-28,-18v21,-48,61,-33,100,-20v10,0,17,-5,20,-16xm90,-237v56,2,86,24,83,86r0,57v4,68,-21,98,-80,98v-61,0,-82,-23,-82,-90v0,-82,-3,-155,79,-151xm92,-37v11,-2,10,-8,10,-24r0,-108v-2,-18,3,-26,-10,-27v-13,1,-10,9,-10,27r0,105v1,17,-2,25,10,27"},"\u00fa":{"d":"154,-297r-58,48r-36,0r31,-48r63,0xm93,-37v18,-2,11,-12,11,-39r0,-157r71,0r0,233r-72,0r1,-19v-9,14,-22,23,-43,23v-46,0,-49,-27,-49,-80r0,-157r71,0r0,158v2,26,-6,35,10,38","w":188},"\u00f9":{"d":"93,-37v18,-2,11,-12,11,-39r0,-157r71,0r0,233r-72,0r1,-19v-9,14,-22,23,-43,23v-46,0,-49,-27,-49,-80r0,-157r71,0r0,158v2,26,-6,35,10,38xm34,-296r63,0r31,47r-36,0","w":188},"\u00fb":{"d":"95,-272r-20,23r-50,0r46,-49r49,0r43,49r-48,0xm93,-37v18,-2,11,-12,11,-39r0,-157r71,0r0,233r-72,0r1,-19v-9,14,-22,23,-43,23v-46,0,-49,-27,-49,-80r0,-157r71,0r0,158v2,26,-6,35,10,38","w":188},"\u00fc":{"d":"79,-295r0,46r-46,0r0,-46r46,0xm155,-295r0,46r-45,0r0,-46r45,0xm93,-37v18,-2,11,-12,11,-39r0,-157r71,0r0,233r-72,0r1,-19v-9,14,-22,23,-43,23v-46,0,-49,-27,-49,-80r0,-157r71,0r0,158v2,26,-6,35,10,38","w":188},"\u00a3":{"d":"96,-290v56,2,89,36,80,97r-64,0v-3,-21,8,-57,-14,-60v-38,4,3,72,0,91r45,0r0,49r-41,0v0,32,-12,56,-34,72v28,-6,68,14,56,-39r60,0v3,53,-3,88,-53,85v-33,-2,-90,-25,-118,0r0,-41v19,-12,25,-47,25,-77r-25,0r0,-49r17,0v-36,-59,-4,-131,66,-128","w":192},"\u00df":{"d":"94,-291v73,-7,119,68,65,111v28,11,27,49,27,95v0,66,-30,87,-93,85r0,-43v24,0,22,-1,22,-28r0,-70v0,-16,-1,-19,-14,-21r0,-44v10,-1,11,-3,11,-16v0,-15,-2,-27,-14,-27v-15,0,-14,10,-14,29r0,220r-71,0r0,-190v-5,-75,17,-95,81,-101","w":198},"\u2122":{"d":"47,-141r0,-119r-45,0r0,-25r117,0r0,25r-43,0r0,119r-29,0xm130,-141r0,-144r45,0r26,100r27,-100r45,0r0,144r-27,0r0,-114r-32,114r-26,0r-31,-114r0,114r-27,0","w":281},"\u00e6":{"d":"137,-225v57,-31,137,2,124,82r0,31r-93,0v4,25,-11,74,12,75v23,1,10,-39,13,-60r68,0v5,63,-19,101,-77,101v-33,0,-55,-7,-70,-26v-10,17,-27,24,-52,26v-54,4,-59,-55,-49,-101v9,-36,88,-16,82,-71v-1,-16,2,-26,-10,-28v-15,1,-7,31,-9,53r-66,0v-15,-85,64,-112,127,-82xm179,-196v-17,0,-9,29,-11,46r21,0v-2,-17,6,-47,-10,-46xm74,-62v-3,24,23,35,23,11r0,-59v-18,15,-20,16,-23,48","w":271},"\u00f8":{"d":"90,-237v25,0,45,6,59,17r7,-11r13,9r-9,14v19,22,11,73,13,114v4,68,-21,95,-80,98v-24,0,-46,-5,-59,-15r-6,9r-14,-9r8,-13v-18,-24,-9,-79,-11,-122v-2,-62,22,-89,79,-91xm92,-196v-20,3,-6,55,-10,81v8,-16,24,-26,20,-54v-2,-18,3,-26,-10,-27xm92,-37v20,-5,6,-54,10,-79v-8,16,-23,25,-20,52v1,17,-2,25,10,27"},"\u00bf":{"d":"103,-193r0,-57r66,0r0,57r-66,0xm90,-1v20,1,11,-31,13,-56r71,0v3,69,-23,97,-83,97v-74,0,-90,-53,-85,-134v-11,-63,64,-98,97,-54r0,-31r66,0r0,79r-64,0v0,-11,-4,-17,-12,-17v-25,2,-10,58,-14,90v2,15,-1,26,11,26","w":188},"\u00ab":{"d":"21,-218r42,0r-15,96r15,100r-42,0r-15,-100xm86,-218r41,0r-15,96r15,100r-41,0r-15,-100","w":133},"\u00bb":{"d":"112,-218r15,96r-15,100r-41,0r15,-100r-15,-96r41,0xm48,-218r15,96r-15,100r-42,0r15,-100r-15,-96r42,0","w":133},"\u2026":{"d":"60,-58r0,58r-54,0r0,-58r54,0xm193,-58r0,58r-54,0r0,-58r54,0xm126,-58r0,58r-53,0r0,-58r53,0","w":199},"\u2013":{"d":"-2,-139r184,0r0,44r-184,0r0,-44","w":180},"\u2014":{"d":"-2,-139r364,0r0,44r-364,0r0,-44","w":360},"\u201c":{"d":"70,-192v-4,-50,8,-87,48,-93r0,21v-7,4,-11,9,-12,16r12,0r0,56r-48,0xm6,-192v-4,-50,8,-86,48,-93r0,21v-7,4,-11,9,-12,16r12,0r0,56r-48,0","w":124},"\u201d":{"d":"118,-285v4,51,-9,85,-48,93r0,-21v7,-4,11,-9,12,-16r-12,0r0,-56r48,0xm54,-285v4,50,-9,86,-48,93r0,-21v7,-4,11,-9,12,-16r-12,0r0,-56r48,0","w":124},"\u2018":{"d":"6,-192v-4,-50,8,-86,48,-93r0,21v-7,4,-11,9,-12,16r12,0r0,56r-48,0","w":60},"\u2019":{"d":"54,-285v4,50,-9,86,-48,93r0,-21v7,-4,11,-9,12,-16r-12,0r0,-56r48,0","w":60},"\u00ff":{"d":"68,-295r0,46r-46,0r0,-46r46,0xm144,-295r0,46r-45,0r0,-46r45,0xm15,-5v30,1,29,-2,22,-33r-39,-195r64,0r24,157r11,-157r64,0r-28,223v-6,48,-61,44,-118,43r0,-38","w":161},"\u20ac":{"d":"99,-242v-27,0,-17,34,-19,60r20,0r0,30r-20,0r0,14r20,0r0,30r-20,0v2,26,-8,65,17,66v26,0,15,-37,17,-63r65,0v4,73,-17,111,-82,111v-65,0,-90,-38,-84,-114r-17,0r0,-30r17,0r0,-14r-17,0r0,-30r17,0v-6,-73,22,-109,86,-109v59,0,84,34,80,104r-65,0v-3,-22,8,-55,-15,-55","w":191},"\u0142":{"d":"88,-184r12,-3r0,30r-12,4r0,153r-73,0r0,-131r-13,4r0,-31r13,-3r0,-124r73,0r0,101","w":102},"\u00d7":{"d":"13,-197r30,-30r53,52r53,-52r30,30r-53,53r53,52r-31,30r-52,-52r-52,52r-30,-30r52,-52","w":191},"\u0107":{"d":"150,-297r-58,48r-36,0r31,-48r63,0xm11,-154v-19,-95,124,-108,152,-42v5,12,7,29,7,51r-67,0v-2,-19,6,-51,-11,-51v-12,0,-10,9,-10,24r0,110v0,13,1,25,12,25v20,0,10,-37,12,-59r64,0v3,67,-19,97,-80,100v-86,5,-81,-74,-79,-158","w":178},"\u0105":{"d":"90,-232v119,0,71,130,80,232r-23,0v-10,10,-15,18,-15,24v1,16,20,11,33,6r7,18v-25,14,-64,10,-65,-20v0,-10,4,-19,14,-28r-20,0r0,-21v-8,16,-19,18,-42,21v-59,8,-56,-67,-42,-106v5,-12,69,-32,74,-37v10,-5,14,-53,-3,-53v-21,0,-9,35,-12,53r-66,0v-4,-64,16,-89,80,-89xm76,-62v-2,26,23,35,23,10r0,-59v-19,16,-20,16,-23,49","w":181},"\u0119":{"d":"92,-37v23,0,11,-39,14,-61r67,0v4,58,-11,95,-65,98v-10,10,-15,18,-15,24v1,17,20,11,33,6r7,18v-26,14,-64,10,-66,-20v0,-10,5,-19,15,-28v-50,-4,-72,-28,-72,-85r0,-68v-2,-55,24,-80,79,-80v75,0,89,44,84,121r-92,0v3,24,-9,71,11,75xm92,-196v-17,1,-9,29,-11,46r21,0v-2,-20,7,-46,-10,-46"},"\u0151":{"d":"102,-303r-43,54r-26,0r21,-54r48,0xm170,-303r-42,54r-26,0r20,-54r48,0xm90,-237v56,2,86,24,83,86r0,57v4,68,-21,98,-80,98v-61,0,-82,-23,-82,-90v0,-82,-3,-155,79,-151xm92,-37v11,-2,10,-8,10,-24r0,-108v-2,-18,3,-26,-10,-27v-13,1,-10,9,-10,27r0,105v1,17,-2,25,10,27"},"\u015b":{"d":"143,-297r-58,48r-36,0r31,-48r63,0xm81,-237v53,3,83,19,77,78r-63,0v-2,-18,5,-38,-11,-37v-18,1,-16,36,-2,42v28,22,81,30,81,85v0,54,-26,72,-74,73v-57,1,-85,-24,-80,-86r63,0v1,20,-4,43,12,45v20,3,15,-34,10,-41v-4,-6,-79,-41,-80,-57v-22,-55,5,-106,67,-102","w":169},"\u0171":{"d":"100,-303r-42,54r-26,0r20,-54r48,0xm169,-303r-43,54r-26,0r21,-54r48,0xm93,-37v18,-2,11,-12,11,-39r0,-157r71,0r0,233r-72,0r1,-19v-9,14,-22,23,-43,23v-46,0,-49,-27,-49,-80r0,-157r71,0r0,158v2,26,-6,35,10,38","w":188},"\u017a":{"d":"120,-297r-58,48r-35,0r31,-48r62,0xm123,-233r0,51r-52,135r52,0r0,47r-121,0r0,-49r54,-138r-48,0r0,-46r115,0","w":126},"\u017c":{"d":"86,-295r0,46r-45,0r0,-46r45,0xm123,-233r0,51r-52,135r52,0r0,47r-121,0r0,-49r54,-138r-48,0r0,-46r115,0","w":126},"\u2032":{"d":"52,-193r-36,0r-2,-92r54,0","w":66},"\u2033":{"d":"52,-193r-36,0r-2,-92r54,0xm124,-193r-36,0r-2,-92r54,0","w":139},"\u00a0":{"w":63}}});
